/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.Channel;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class ChannelTable
implements Iterable<String> {
    private HashMap<String, List<Channel>> channelTable = new LinkedHashMap<String, List<Channel>>();

    public void update(JsonObject jsonObject) {
        this.channelTable.clear();
        for (String countryCode : jsonObject.keySet()) {
            ArrayList<Channel> channelList = new ArrayList<Channel>();
            JsonArray jsonArray = jsonObject.get(countryCode).getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                JsonArray freqBWChannelIndex = jsonElement.getAsJsonArray();
                double freq = freqBWChannelIndex.get(0).getAsDouble();
                int bw = freqBWChannelIndex.get(1).getAsInt();
                int channelIndex = freqBWChannelIndex.get(2).getAsInt();
                Channel channel = new Channel(freq, bw, channelIndex);
                channelList.add(channel);
            }
            this.channelTable.put(countryCode, channelList);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.channelTable.keySet().iterator();
    }

    public List<Channel> getChannelList(String countryCode) {
        System.out.println(this.channelTable);
        System.out.println(countryCode);
        System.out.println(this.channelTable.get(countryCode));
        return this.channelTable.get(countryCode);
    }
}

