/*
 * Decompiled with CFR 0.152.
 */
package Main;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

public class Connection {
    private Socket socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private BufferedReader reader;
    private PrintWriter writer;
    boolean connected;

    private static synchronized void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean connect(String ip, int port) {
        this.socket = new Socket();
        try {
            this.socket.setSoTimeout(3000);
            this.socket.connect(new InetSocketAddress(ip, port), 3000);
        }
        catch (IOException e) {
            Connection.close(this.socket);
            e.printStackTrace();
            return false;
        }
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            Connection.close(this.socket);
            e.printStackTrace();
            return false;
        }
        this.reader = new BufferedReader(new InputStreamReader(this.inputStream));
        this.writer = new PrintWriter(this.outputStream, true);
        this.connected = true;
        System.out.printf("[CONNECTED] %s:%d\n", ip, port);
        return true;
    }

    public synchronized void disconnect() {
        Connection.close(this.socket);
        Connection.close(this.reader);
        Connection.close(this.writer);
        this.connected = false;
        System.out.println("[DISCONNECTED]");
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public synchronized void writeLine(String line) {
        this.writer.println(line);
    }

    public synchronized String readLine() {
        try {
            return this.reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized String query(String line) {
        this.writeLine(line);
        return this.readLine();
    }
}

