/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.Channel;
import Main.ChannelTable;
import Main.Connection;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Main
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String VERSION = "v1.0";
    private static final String AP = "AP";
    private static final String STA = "STA";
    private static final String OPEN = "OPEN";
    private static final String WPA_PSK = "WPA-PSK";
    private static final String OWE = "OWE";
    private static final String SAE = "SAE";
    private JPanel topPanel = new JPanel(new GridLayout(1, 2));
    private JPanel ipPortPanel = new JPanel(new FlowLayout(1));
    private JTextField ipField = new JTextField(10);
    private JLabel colonLabel = new JLabel(":");
    private JTextField portField = new JTextField(6);
    private JPanel connectionPanel = new JPanel(new FlowLayout(1));
    private JButton connectButton = new JButton("Connect");
    private JButton disconnectButton = new JButton("Disconnect");
    private JPanel leftPanel = new JPanel(new GridLayout(2, 1));
    private JComboBox<String> modeComboBox = new JComboBox();
    private JComboBox<String> securityComboBox = new JComboBox();
    private JPanel centerPanel = new JPanel(new GridLayout(2, 1));
    private JPanel centerRowPanel1 = new JPanel(new GridLayout(1, 2));
    private JPanel passphrasePanel = new JPanel(new FlowLayout(1));
    private JTextField passphraseField = new JTextField(12);
    private JPanel centerRowPanel2 = new JPanel(new GridLayout(1, 2));
    private JPanel ssidPanel = new JPanel(new FlowLayout(1));
    private JTextField ssidField = new JTextField(12);
    private JComboBox<String> countryComboBox = new JComboBox();
    private JComboBox<Channel> channelComboBox = new JComboBox();
    private JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
    private JPanel operationPanel = new JPanel(new FlowLayout(1));
    private JButton startButton = new JButton("Start");
    private JButton stopButton = new JButton("Stop");
    private JButton statusButton = new JButton("Status");
    private JButton rebootButton = new JButton("Reboot");
    private JPanel autoStartPanel = new JPanel(new FlowLayout(1));
    private JButton autoStartEnableButton = new JButton("Enable");
    private JButton autoStartDisableButton = new JButton("Disable");
    private Connection connection = new Connection();
    private ChannelTable channelTable = new ChannelTable();

    public Main() {
        this.setTitle("NRC Start Wizard v1.0");
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.ipPortPanel.add(this.ipField);
        this.ipPortPanel.add(this.colonLabel);
        this.ipPortPanel.add(this.portField);
        this.topPanel.add(this.ipPortPanel);
        this.connectionPanel.add(this.connectButton);
        this.connectionPanel.add(this.disconnectButton);
        this.topPanel.add(this.connectionPanel);
        this.add((Component)this.topPanel, "North");
        this.leftPanel.add(this.modeComboBox);
        this.leftPanel.add(this.securityComboBox);
        this.add((Component)this.leftPanel, "West");
        this.centerRowPanel1.add(this.ssidPanel);
        this.centerRowPanel1.add(this.countryComboBox);
        this.centerPanel.add(this.centerRowPanel1);
        this.ssidPanel.add(this.ssidField);
        this.passphrasePanel.add(this.passphraseField);
        this.centerRowPanel2.add(this.passphrasePanel);
        this.centerRowPanel2.add(this.channelComboBox);
        this.centerPanel.add(this.centerRowPanel2);
        this.add((Component)this.centerPanel, "Center");
        this.operationPanel.add(this.startButton);
        this.operationPanel.add(this.stopButton);
        this.operationPanel.add(this.statusButton);
        this.operationPanel.add(this.rebootButton);
        this.bottomPanel.add(this.operationPanel);
        this.autoStartPanel.add(this.autoStartEnableButton);
        this.autoStartPanel.add(this.autoStartDisableButton);
        this.bottomPanel.add(this.autoStartPanel);
        this.add((Component)this.bottomPanel, "South");
        this.ipField.setText("172.16.73.94");
        this.portField.setText("12347");
        this.ssidField.setText("halow_demo");
        this.modeComboBox.addItem(AP);
        this.modeComboBox.addItem(STA);
        this.securityComboBox.addItem(OPEN);
        this.securityComboBox.addItem(WPA_PSK);
        this.securityComboBox.addItem(OWE);
        this.securityComboBox.addItem(SAE);
        this.ipPortPanel.setBorder(BorderFactory.createTitledBorder("Start Wizard Server IP/Port"));
        this.connectionPanel.setBorder(BorderFactory.createTitledBorder("Connection"));
        this.modeComboBox.setBorder(BorderFactory.createTitledBorder("Mode"));
        this.securityComboBox.setBorder(BorderFactory.createTitledBorder("Security"));
        this.ssidPanel.setBorder(BorderFactory.createTitledBorder("SSID"));
        this.countryComboBox.setBorder(BorderFactory.createTitledBorder("Country"));
        this.channelComboBox.setBorder(BorderFactory.createTitledBorder("Channel"));
        this.passphrasePanel.setBorder(BorderFactory.createTitledBorder("Passphrase"));
        this.operationPanel.setBorder(BorderFactory.createTitledBorder("Operation"));
        this.autoStartPanel.setBorder(BorderFactory.createTitledBorder("Auto-Start on Reboot"));
        this.connectButton.addActionListener(event -> {
            this.connect();
            this.resetControl();
        });
        this.disconnectButton.addActionListener(event -> {
            this.disconnect();
            this.resetControl();
        });
        this.countryComboBox.addActionListener(event -> {
            String selectedCountry = Main.getSelectedItem(this.countryComboBox);
            if (selectedCountry == null) {
                return;
            }
            this.channelComboBox.removeAllItems();
            List<Channel> channelList = this.channelTable.getChannelList(selectedCountry);
            for (Channel channel : channelList) {
                this.channelComboBox.addItem(channel);
            }
            this.resetControl();
        });
        this.modeComboBox.addActionListener(event -> this.resetControl());
        this.securityComboBox.addActionListener(event -> this.resetControl());
        this.startButton.addActionListener(event -> {
            try {
                this.start();
            }
            catch (Exception e) {
                this.displayErrorMessage("Communication failed. Try reconnecting.");
                this.disconnect();
            }
            this.resetControl();
        });
        this.stopButton.addActionListener(event -> {
            try {
                this.stop();
            }
            catch (Exception e) {
                this.displayErrorMessage("Communication failed. Try reconnecting.");
                this.disconnect();
            }
            this.resetControl();
        });
        this.statusButton.addActionListener(event -> {
            try {
                this.status();
            }
            catch (Exception e) {
                this.displayErrorMessage("Communication failed. Try reconnecting.");
                this.disconnect();
            }
            this.resetControl();
        });
        this.rebootButton.addActionListener(event -> {
            try {
                this.reboot();
                this.disconnect();
            }
            catch (Exception e) {
                this.displayErrorMessage("Communication failed. Try reconnecting.");
                this.disconnect();
            }
            this.resetControl();
        });
        this.autoStartEnableButton.addActionListener(event -> {
            try {
                this.autoStart(true);
            }
            catch (Exception e) {
                this.displayErrorMessage("Communication failed. Try reconnecting.");
                this.disconnect();
            }
            this.resetControl();
        });
        this.autoStartDisableButton.addActionListener(event -> {
            try {
                this.autoStart(false);
            }
            catch (Exception e) {
                this.displayErrorMessage("Communication failed. Try reconnecting.");
                this.disconnect();
            }
            this.resetControl();
        });
        this.pack();
        this.setLocationRelativeTo(null);
        this.resetControl();
    }

    private static <T> T getSelectedItem(JComboBox<T> comboBox) {
        int selectedIndex = comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return comboBox.getItemAt(selectedIndex);
    }

    private void displayMessage(Object message) {
        JOptionPane.showMessageDialog(this, message, "Message", -1, null);
    }

    private void displayErrorMessage(Object message) {
        JOptionPane.showMessageDialog(this, message, "Error", -1, null);
    }

    private void connect() {
        int port;
        String ip = this.ipField.getText().trim();
        if (!this.connection.connect(ip, port = Integer.parseInt(this.portField.getText().trim()))) {
            this.displayErrorMessage("Connection failed.");
            return;
        }
        JsonObject channelRequest = new JsonObject();
        channelRequest.addProperty("operation", "channel");
        String channelRequestText = channelRequest.toString();
        String channelResponseText = this.connection.query(channelRequestText);
        System.out.println(channelResponseText);
        JsonObject channelResponse = JsonParser.parseString(channelResponseText).getAsJsonObject();
        this.channelTable.update(channelResponse);
        this.countryComboBox.removeAllItems();
        this.channelComboBox.removeAllItems();
        for (String country : this.channelTable) {
            this.countryComboBox.addItem(country);
        }
        this.repaint();
    }

    private void disconnect() {
        this.connection.disconnect();
    }

    private void start() {
        JsonObject startRequest = new JsonObject();
        startRequest.addProperty("operation", "start");
        startRequest.addProperty("mode", Main.getSelectedItem(this.modeComboBox));
        startRequest.addProperty("security", Main.getSelectedItem(this.securityComboBox));
        startRequest.addProperty("country_code", Main.getSelectedItem(this.countryComboBox));
        startRequest.addProperty("ssid", this.ssidField.getText().trim());
        startRequest.addProperty("channel", Main.getSelectedItem(this.channelComboBox).getChannelIndex());
        startRequest.addProperty("passphrase", this.passphraseField.getText());
        String startRequestText = startRequest.toString();
        String startResponseText = this.connection.query(startRequestText);
        System.out.println(startResponseText);
        JsonObject startResponse = JsonParser.parseString(startResponseText).getAsJsonObject();
        this.displayMessage(startResponse.get("status").getAsString());
    }

    private void stop() {
        JsonObject stopRequest = new JsonObject();
        stopRequest.addProperty("operation", "stop");
        String stopRequestText = stopRequest.toString();
        String stopResponseText = this.connection.query(stopRequestText);
        System.out.println(stopResponseText);
        JsonObject stopResponse = JsonParser.parseString(stopResponseText).getAsJsonObject();
        this.displayMessage(stopResponse.get("status").getAsString());
    }

    private void autoStart(boolean enable) {
        JsonObject autoStartRequest = new JsonObject();
        autoStartRequest.addProperty("operation", "auto_start");
        autoStartRequest.addProperty("mode", Main.getSelectedItem(this.modeComboBox));
        autoStartRequest.addProperty("security", Main.getSelectedItem(this.securityComboBox));
        autoStartRequest.addProperty("country_code", Main.getSelectedItem(this.countryComboBox));
        autoStartRequest.addProperty("ssid", this.ssidField.getText().trim());
        autoStartRequest.addProperty("channel", Main.getSelectedItem(this.channelComboBox).getChannelIndex());
        autoStartRequest.addProperty("passphrase", this.passphraseField.getText());
        autoStartRequest.addProperty("enable", enable);
        String autoStartRequestText = autoStartRequest.toString();
        String autoStartResponseText = this.connection.query(autoStartRequestText);
        System.out.println(autoStartResponseText);
        JsonObject autoStartResponse = JsonParser.parseString(autoStartResponseText).getAsJsonObject();
        this.displayMessage(autoStartResponse.get("status").getAsString());
    }

    private void status() {
        JsonObject statusRequest = new JsonObject();
        statusRequest.addProperty("operation", "status");
        String statusRequestText = statusRequest.toString();
        String statusResponseText = this.connection.query(statusRequestText);
        System.out.println(statusResponseText);
        JsonObject statusResponse = JsonParser.parseString(statusResponseText).getAsJsonObject();
        JTabbedPane statusPane = new JTabbedPane();
        for (String key : statusResponse.keySet()) {
            JTextArea textArea = new JTextArea();
            textArea.setFont(new Font("Monospaced", 0, 12));
            textArea.setEditable(false);
            JsonElement element = statusResponse.get(key);
            textArea.setText(element.isJsonNull() ? "N/A" : element.getAsString());
            statusPane.add(key, textArea);
        }
        JOptionPane.showMessageDialog(this, statusPane, "Status", -1, null);
    }

    private void reboot() {
        JsonObject rebootRequest = new JsonObject();
        rebootRequest.addProperty("operation", "reboot");
        String rebootRequestText = rebootRequest.toString();
        String rebootResponseText = this.connection.query(rebootRequestText);
        System.out.println(rebootResponseText);
        JsonObject rebootResponse = JsonParser.parseString(rebootResponseText).getAsJsonObject();
        this.displayMessage(rebootResponse.get("status").getAsString());
    }

    private void resetControl() {
        boolean connected = this.connection.isConnected();
        boolean apSelected = this.modeComboBox.getSelectedItem().equals(AP);
        boolean openSelected = this.securityComboBox.getSelectedItem().equals(OPEN);
        this.ipField.setEnabled(!connected);
        this.portField.setEnabled(!connected);
        this.connectButton.setEnabled(!connected);
        this.disconnectButton.setEnabled(connected);
        this.modeComboBox.setEnabled(connected);
        this.ssidPanel.setEnabled(connected);
        this.ssidField.setEnabled(connected);
        this.securityComboBox.setEnabled(connected);
        this.countryComboBox.setEnabled(connected);
        this.channelComboBox.setEnabled(connected && apSelected);
        this.passphrasePanel.setEnabled(connected && !openSelected);
        this.passphraseField.setEnabled(connected && !openSelected);
        this.autoStartPanel.setEnabled(connected);
        this.autoStartEnableButton.setEnabled(connected);
        this.autoStartDisableButton.setEnabled(connected);
        this.operationPanel.setEnabled(connected);
        this.startButton.setEnabled(connected);
        this.stopButton.setEnabled(connected);
        this.statusButton.setEnabled(connected);
        this.rebootButton.setEnabled(connected);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Main main = new Main();
            main.setVisible(true);
        });
    }
}

