/*
 * Decompiled with CFR 0.152.
 */
package AppWAVE;

import AppWAVE.DataPoint;
import AppWAVE.DataSet;
import AppWAVE.HeatmapProgressObserver;
import Data.IJ;
import Data.XY;
import Util.UtilMath;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;

public class Heatmap {
    public static final String VORONOI = "VORONOI";
    public static final String BLUR = "BLUR";
    private final int width;
    private final int height;
    private double[][] values;
    private boolean[][] mask;

    public Heatmap(int w, int h) {
        this.width = w;
        this.height = h;
        this.values = new double[w][h];
        this.mask = new boolean[w][h];
    }

    public double[][] getValues() {
        return this.values;
    }

    public boolean[][] getMask() {
        return this.mask;
    }

    public static Heatmap generate(String type, DataSet dataSet, int w, int h, int r, HeatmapProgressObserver observer) {
        switch (type) {
            case "VORONOI": {
                return Heatmap.generateVoronoi(dataSet, w, h, r, observer);
            }
            case "BLUR": {
                return Heatmap.generateBlur(dataSet, w, h, r, observer);
            }
        }
        return null;
    }

    public static Heatmap generateVoronoi(DataSet dataSet, int w, int h, int r, HeatmapProgressObserver observer) {
        long initTime = System.currentTimeMillis();
        Heatmap heatmap = new Heatmap(w, h);
        ArrayList<IJ> circleEnum = new ArrayList<IJ>();
        int limit = r * r;
        int i = -r;
        while (i <= r) {
            int j = -r;
            while (j <= r) {
                if (i * i + j * j <= limit) {
                    circleEnum.add(new IJ(i, j));
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(circleEnum);
        int circleEnumSize = circleEnum.size();
        int[] circleEnumX = new int[circleEnumSize];
        int[] circleEnumY = new int[circleEnumSize];
        int i2 = 0;
        while (i2 < circleEnumSize) {
            IJ ij = (IJ)circleEnum.get(i2);
            circleEnumX[i2] = ij.getI();
            circleEnumY[i2] = ij.getJ();
            ++i2;
        }
        circleEnum = null;
        int dataSetSize = dataSet.size();
        int[] dataPointsX = new int[dataSetSize];
        int[] dataPointsY = new int[dataSetSize];
        double[] dataPointsV = new double[dataSetSize];
        int i3 = 0;
        while (i3 < dataSetSize) {
            DataPoint dataPoint = dataSet.get(i3);
            XY xy = dataPoint.getPosition();
            dataPointsX[i3] = (int)Math.round(xy.getX());
            dataPointsY[i3] = (int)Math.round(xy.getY());
            dataPointsV[i3] = dataPoint.getValue();
            ++i3;
        }
        i3 = 0;
        while (i3 < circleEnumSize) {
            if (observer != null && observer.communicateHeatmapProgress((double)i3 / (double)circleEnumSize).get()) {
                return null;
            }
            int traceX = circleEnumX[i3];
            int traceY = circleEnumY[i3];
            int j = 0;
            while (j < dataSetSize) {
                int x = dataPointsX[j] + traceX;
                int y = dataPointsY[j] + traceY;
                if (UtilMath.isBetween(x, 0.0, w - 1) && UtilMath.isBetween(y, 0.0, h - 1) && !heatmap.mask[x][y]) {
                    heatmap.values[x][y] = dataPointsV[j];
                    heatmap.mask[x][y] = true;
                }
                ++j;
            }
            ++i3;
        }
        long endTime = System.currentTimeMillis();
        System.out.println("HEATMAP GENERATION TOOK " + (endTime - initTime) + "ms.");
        return heatmap;
    }

    public static Heatmap generateBlur(DataSet dataSet, int w, int h, int r, HeatmapProgressObserver observer) {
        long initTime = System.currentTimeMillis();
        Heatmap heatmap = new Heatmap(w, h);
        int dataSetSize = dataSet.size();
        int[] dataSetXs = new int[dataSetSize];
        int[] dataSetYs = new int[dataSetSize];
        double[] dataSetZs = new double[dataSetSize];
        int i = 0;
        while (i < dataSetSize) {
            DataPoint dataPoint = dataSet.get(i);
            XY position = dataPoint.getPosition();
            dataSetXs[i] = (int)position.getX();
            dataSetYs[i] = (int)position.getY();
            dataSetZs[i] = dataPoint.getValue();
            ++i;
        }
        boolean boundedExtrapolation = r >= 0;
        int rSquared = r * r;
        int i2 = 0;
        while (i2 < w) {
            if (observer != null && observer.communicateHeatmapProgress((double)i2 / (double)w).get()) {
                return null;
            }
            int j = 0;
            while (j < h) {
                double numerator = 0.0;
                double denominator = 0.0;
                boolean useExactValue = false;
                int k = 0;
                while (k < dataSetSize) {
                    int dx = dataSetXs[k] - i2;
                    int dy = dataSetYs[k] - j;
                    if (dx == 0 && dy == 0) {
                        useExactValue = true;
                        heatmap.values[i2][j] = dataSetZs[k];
                        heatmap.mask[i2][j] = true;
                        break;
                    }
                    double normSquared = dx * dx + dy * dy;
                    if (!boundedExtrapolation || !(normSquared > (double)rSquared)) {
                        heatmap.mask[i2][j] = true;
                        double weight = 1.0 / normSquared;
                        weight *= weight;
                        numerator += dataSetZs[k] * weight;
                        denominator += weight;
                    }
                    ++k;
                }
                if (!useExactValue && denominator != 0.0) {
                    heatmap.values[i2][j] = numerator / denominator;
                }
                ++j;
            }
            ++i2;
        }
        long endTime = System.currentTimeMillis();
        System.out.println("HEATMAP GENERATION TOOK " + (endTime - initTime) + "ms.");
        return heatmap;
    }

    public static void saveHeatmap(Heatmap heatmap, File outputFile) {
        StringBuilder s = new StringBuilder();
        s.append("X,Y,VALUE\n");
        int i = 0;
        while (i < heatmap.width) {
            int j = 0;
            while (j < heatmap.height) {
                if (heatmap.mask[i][j]) {
                    s.append(String.format("%d,%d,%f\n", i, j, heatmap.values[i][j]));
                }
                ++j;
            }
            ++i;
        }
        try {
            Files.write(outputFile.toPath(), s.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

