/*
 * Decompiled with CFR 0.152.
 */
package AppWAVE;

import AppWAVE.DataPoint;
import AppWAVE.DataSet;
import AppWAVE.Heatmap;
import GUIModule.ColorGradient;
import Util.UtilMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class HeatmapImageGenerator {
    private static final String[] FONT_3x5 = new String[]{" #   #  ##  ### # # ###  ## ### ###  #  ", "# # ##    #   # # # #   #     # # # # # ", "# #  #   #  ### ### ##  ###  #  ### ### ", "# #  #  #     #   #   # # #  #  # #   # ", " #  ### ### ###   # ##   #   #  ### ##  "};

    public static BufferedImage generateImage(int w, int h, DataSet dataSet, Heatmap heatmap, double valueMin, double valueMax, double scale, int alpha, int decimalPoint, boolean heatmapPlot, boolean pointPlot, boolean valuePlot, boolean apLocationAvailable, int apX, int apY, String fontName, int fontSize, Color fontColor) {
        double intensity;
        BufferedImage canvas = new BufferedImage(w, h, 2);
        Graphics g = canvas.getGraphics();
        if (heatmap != null && heatmapPlot) {
            ColorGradient alphaRGBMapper = ColorGradient.getRainbowScheme(alpha);
            double[][] values = heatmap.getValues();
            boolean[][] mask = heatmap.getMask();
            int i = 0;
            while (i < w) {
                int j = 0;
                while (j < h) {
                    int rgb = alpha << 24;
                    if (mask[i][j]) {
                        intensity = UtilMath.map(values[i][j], valueMin, valueMax, 0.0, 1.0);
                        rgb = alphaRGBMapper.getARGB(intensity);
                    }
                    canvas.setRGB(i, j, rgb);
                    ++j;
                }
                ++i;
            }
        }
        if (pointPlot) {
            ColorGradient pointRGBMapper = ColorGradient.getRainbowScheme(255);
            int r = 1;
            for (DataPoint dataPoint : dataSet) {
                int x = (int)dataPoint.getPosition().getX();
                int y = (int)dataPoint.getPosition().getY();
                intensity = UtilMath.map(dataPoint.getValue(), valueMin, valueMax, 0.0, 1.0);
                int rgb = pointRGBMapper.getARGB(intensity);
                g.setColor(new Color(rgb));
                g.fillRect(x - r, y - r, 2 * r + 1, 2 * r + 1);
                g.setColor(Color.BLACK);
                g.drawRect(x - r, y - r, 2 * r + 1, 2 * r + 1);
            }
        }
        if (valuePlot) {
            g.setFont(new Font("ARIAL", 0, 10));
            for (DataPoint dataPoint : dataSet) {
                int x = (int)dataPoint.getPosition().getX();
                int y = (int)dataPoint.getPosition().getY();
                g.setColor(Color.BLACK);
                String text = String.format("%." + decimalPoint + "f", scale * dataPoint.getValue());
                boolean useFont3x5 = fontName.equals("SWiSS 3x5");
                if (useFont3x5) {
                    int textLength = text.length();
                    g.setColor(Color.BLACK);
                    g.fillRect((x += 2 - 2 * textLength) - 1, y -= 6, 4 * textLength + 1, 5);
                    g.setColor(Color.WHITE);
                    char[] cArray = text.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int py;
                        int px;
                        char c = cArray[n2];
                        if (c == '.') {
                            px = x + 1;
                            py = y + 4;
                            g.drawLine(px, py, px, py);
                        } else if (c == '-') {
                            px = x;
                            py = y + 2;
                            g.drawLine(px, py, px + 2, py);
                        } else if ('0' <= c && c <= '9') {
                            int i = 0;
                            while (i < 3) {
                                int j = 0;
                                while (j < 5) {
                                    int digit = c - 48;
                                    px = x + i;
                                    py = y + j;
                                    if (FONT_3x5[j].charAt(4 * digit + i) != ' ') {
                                        g.drawLine(px, py, px, py);
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                        x += 4;
                        ++n2;
                    }
                    continue;
                }
                g.setFont(new Font(fontName, 0, fontSize));
                g.setColor(fontColor);
                g.drawString(text, x -= g.getFontMetrics().stringWidth(text) / 2, y -= 6);
            }
        }
        if (apLocationAvailable) {
            int apRadius = 2;
            int apDiameter = 2 * apRadius + 1;
            g.setColor(Color.DARK_GRAY);
            g.fillOval(apX - apRadius, apY - apRadius, apDiameter, apDiameter);
            g.setColor(Color.BLACK);
            g.drawOval(apX - apRadius, apY - apRadius, apDiameter, apDiameter);
            g.setFont(new Font(fontName, 0, fontSize));
            String apText = "AP";
            int apTextOffsetX = -g.getFontMetrics().stringWidth(apText) / 2;
            int apTextOffsetY = g.getFont().getSize();
            g.setColor(Color.BLACK);
            int i = -1;
            while (i <= 1) {
                int j = -1;
                while (j <= 1) {
                    g.drawString(apText, apX + apTextOffsetX + i, apY + apTextOffsetY + j);
                    ++j;
                }
                ++i;
            }
            g.setColor(Color.WHITE);
            g.drawString(apText, apX + apTextOffsetX, apY + apTextOffsetY);
        }
        g.dispose();
        return canvas;
    }
}

