/*
 * Decompiled with CFR 0.152.
 */
package GUIModule.Art;

import GUIModule.ColorGradient;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class IntroAnimationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int DIMENSION = 300;
    private AtomicBoolean animationOn = new AtomicBoolean();
    private Random random = new Random();
    private long initTime = System.currentTimeMillis();
    private BufferedImage image;
    private Color[] GRAYSCALE = new Color[256];
    private ColorGradient rainbow = ColorGradient.getSeamlessRainbowScheme();

    public IntroAnimationPanel() {
        this.setPreferredSize(new Dimension(600, 600));
        this.setBackground(Color.BLACK);
        this.image = new BufferedImage(300, 300, 2);
        int i = 0;
        while (i < 256) {
            this.GRAYSCALE[i] = new Color(i, i, i);
            ++i;
        }
    }

    private void addCircle() {
        int rMaxHalf;
        int rLimit;
        int py;
        int ry;
        int px = this.random.nextInt(300);
        int rx = px - 150;
        double rr = Math.sqrt(rx * rx + (ry = (py = this.random.nextInt(300)) - 150) * ry);
        if (rr > 150.0) {
            return;
        }
        int rMax = (int)Math.min(150.0, 150.0 - rr);
        if (rMax > (rLimit = px)) {
            rMax = rLimit;
        }
        if (rMax > (rLimit = py)) {
            rMax = rLimit;
        }
        if (rMax > (rLimit = 300 - px)) {
            rMax = rLimit;
        }
        if (rMax > (rLimit = 300 - py)) {
            rMax = rLimit;
        }
        if ((rMaxHalf = rMax / 2) > 0) {
            int r = rMaxHalf + this.random.nextInt(rMaxHalf);
            int r2 = r * r;
            int rgbNew = this.random.nextInt() | 0xFF000000;
            int rNew = rgbNew >> 16 & 0xFF;
            int gNew = rgbNew >> 8 & 0xFF;
            int bNew = rgbNew & 0xFF;
            int i = -r;
            while (i <= r) {
                int j = -r;
                while (j <= r) {
                    if (i * i + j * j < r2 / 32) {
                        int rgbOld = this.image.getRGB(px + i, py + j);
                        int rOld = rgbOld >> 16 & 0xFF;
                        int gOld = rgbOld >> 8 & 0xFF;
                        int bOld = rgbOld & 0xFF;
                        int rMixed = (rNew + rOld) / 2;
                        int gMixed = (gNew + gOld) / 2;
                        int bMixed = (bNew + bOld) / 2;
                        int rgbMixed = 0xFF000000 | rMixed << 16 | gMixed << 8 | bMixed;
                        this.image.setRGB(px + i, py + j, rgbMixed);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void drawWave(Graphics g, int cycleOffset, double colorLevelOffset) {
        int RESOLUTION = 2048;
        int CYCLE_PERIOD = 64;
        int cycle = (int)(((System.currentTimeMillis() >> 6) + (long)cycleOffset) % (long)CYCLE_PERIOD);
        int r = cycle + 75;
        int cx = this.getWidth() / 2;
        int cy = this.getHeight() / 2;
        Graphics2D g2 = (Graphics2D)g;
        Stroke originalStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(2.0f));
        double baseColorLevel = (double)((System.currentTimeMillis() >> 2) % (long)RESOLUTION) / (double)RESOLUTION;
        baseColorLevel += colorLevelOffset;
        if (baseColorLevel > 1.0) {
            baseColorLevel -= 1.0;
        }
        int baseColor = this.rainbow.getARGB(baseColorLevel);
        int baseR = baseColor >> 16 & 0xFF;
        int baseG = baseColor >> 8 & 0xFF;
        int baseB = baseColor & 0xFF;
        do {
            int intensity = (r - 75) / 2;
            int adjustedR = Math.max(baseR - 2 * intensity, 0);
            int adjustedG = Math.max(baseG - 2 * intensity, 0);
            int adjustedB = Math.max(baseB - 2 * intensity, 0);
            g.setColor(new Color(adjustedR, adjustedG, adjustedB));
            int d = 2 * r + 1;
            g.drawOval(cx - r, cy - r, d, d);
        } while ((r += CYCLE_PERIOD) <= 300);
        g2.setStroke(originalStroke);
    }

    public void startAnimation() {
        this.animationOn.set(true);
        int i = 0;
        while (i < 50000) {
            this.addCircle();
            ++i;
        }
        new Thread(() -> {
            while (this.animationOn.get()) {
                SwingUtilities.invokeLater(() -> {
                    this.addCircle();
                    this.repaint();
                });
                IntroAnimationPanel.sleep(16);
            }
        }).start();
    }

    public void stopAnimation() {
        this.animationOn.set(false);
    }

    private static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void drawSatellite(Graphics g, double theta, double coef1, double coef2) {
        int r = (int)Math.round(8.0 + 6.0 * coef1 * Math.cos(theta));
        int cx = (int)Math.round(150.0 * Math.cos(theta));
        int cy = (int)Math.round(150.0 * Math.sin(theta));
        int px = (int)Math.round((double)cx * coef1 + (double)cy * coef2);
        int py = (int)Math.round((double)cx * coef2 + (double)cy * coef1);
        int x = this.getWidth() / 2 + px;
        int y = this.getHeight() / 2 + py;
        g.setColor(Color.DARK_GRAY);
        g.fillRect(x - 2 * r, y - r / 4, 4 * r + 1, r / 2 + 1);
        g.fillRect(x - r / 4, y - 2 * r, r / 2 + 1, 4 * r + 1);
        g.setColor(Color.GRAY);
        g.fillRect(x - r, y - r / 4, 2 * r + 1, r / 2 + 1);
        g.fillRect(x - r / 4, y - r, r / 2 + 1, 2 * r + 1);
        g.setColor(Color.BLACK);
        g.drawRect(x - 2 * r, y - r / 4, 4 * r + 1, r / 2 + 1);
        g.drawRect(x - r / 4, y - 2 * r, r / 2 + 1, 4 * r + 1);
        g.drawRect(x - r, y - r / 4, 2 * r + 1, r / 2 + 1);
        g.drawRect(x - r / 4, y - r, r / 2 + 1, 2 * r + 1);
        g.setColor(Color.BLACK);
        g.fillOval(x - r / 2, y - r / 2, r + 1, r + 1);
        g.setColor(Color.BLACK);
        g.setColor(this.GRAYSCALE[(int)((System.currentTimeMillis() >> 3) % 256L)]);
        g.fillOval(x - r / 4, y - r / 4, r / 2 + 1, r / 2 + 1);
    }

    private void introFade(Graphics g, int bgX, int bgY, int bgW, int bgH) {
        int maxDuration = 10000;
        long elapsedTime = System.currentTimeMillis() - this.initTime;
        if (elapsedTime > (long)maxDuration) {
            return;
        }
        int intensity = (int)(255L - 255L * elapsedTime / (long)maxDuration);
        g.setColor(new Color(0, 0, 0, intensity));
        g.fillRect(bgX, bgY, bgW, bgH);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int thetaCount = 8;
        double c1 = Math.sqrt(0.6);
        double c2 = Math.sqrt(0.8);
        double[] thetas1 = new double[thetaCount];
        double[] thetas2 = new double[thetaCount];
        thetas1[0] = (double)System.currentTimeMillis() / 10000.0 % (Math.PI * 2);
        int i = 1;
        while (i < thetaCount) {
            thetas1[i] = (thetas1[i - 1] + Math.PI * 2 / (double)thetaCount) % (Math.PI * 2);
            ++i;
        }
        i = 0;
        while (i < thetaCount) {
            thetas2[i] = (thetas1[i] + Math.PI * 2 / (double)(2 * thetaCount)) % (Math.PI * 2);
            ++i;
        }
        double[] dArray = thetas1;
        int n = thetas1.length;
        int n2 = 0;
        while (n2 < n) {
            double theta1 = dArray[n2];
            if (theta1 < Math.PI) {
                this.drawSatellite(g, theta1, c1, c2);
            }
            ++n2;
        }
        dArray = thetas2;
        n = thetas2.length;
        n2 = 0;
        while (n2 < n) {
            double theta2 = dArray[n2];
            if (theta2 < Math.PI) {
                this.drawSatellite(g, theta2, -c2, c1);
            }
            ++n2;
        }
        int waveCount = 3;
        int i2 = 0;
        while (i2 < waveCount) {
            this.drawWave(g, waveCount * i2, 1.0 - 1.0 / (double)waveCount * (double)i2);
            ++i2;
        }
        int imageX = (this.getWidth() - 300) / 2;
        int imageY = (this.getHeight() - 300) / 2;
        g.drawImage(this.image, imageX, imageY, null);
        double[] dArray2 = thetas1;
        int n3 = thetas1.length;
        int n4 = 0;
        while (n4 < n3) {
            double theta1 = dArray2[n4];
            if (theta1 >= Math.PI) {
                this.drawSatellite(g, theta1, c1, c2);
            }
            ++n4;
        }
        dArray2 = thetas2;
        n3 = thetas2.length;
        n4 = 0;
        while (n4 < n3) {
            double theta2 = dArray2[n4];
            if (theta2 >= Math.PI) {
                this.drawSatellite(g, theta2, -c2, c1);
            }
            ++n4;
        }
        this.introFade(g, 0, 0, this.getWidth(), this.getHeight());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            IntroAnimationPanel introAnimation = new IntroAnimationPanel();
            JFrame frame = new JFrame("Fading Circles");
            frame.setUndecorated(true);
            frame.setDefaultCloseOperation(3);
            frame.setContentPane(introAnimation);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
            introAnimation.startAnimation();
        });
    }
}

