/*
 * Decompiled with CFR 0.152.
 */
package GUIModule.UIGuideBar;

import Assets.Asset;
import GUIModule.Colors;
import GUIModule.GUIFactory;
import GUIModule.UIGuideBar.UIGuideBarListener;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UIGuideBarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;

    public UIGuideBarPanel() {
        this.setLayout(new FlowLayout(1));
        this.setBackground(Colors.DARKER_GRAY_COLOR);
    }

    public UIGuideBarPanel addAspectFit(final UIGuideBarListener listener) {
        JLabel label = GUIFactory.makeIconLabel('A', "Aspect fit");
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                listener.applyAspectFit();
            }
        });
        this.add(label);
        return this;
    }

    public UIGuideBarPanel addOriginalFit(final UIGuideBarListener listener) {
        JLabel label = GUIFactory.makeIconLabel('O', "Original fit");
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                listener.applyOriginalFit();
            }
        });
        this.add(label);
        return this;
    }

    public UIGuideBarPanel addDeleteLastCoordinate() {
        ImageIcon imageIconBackspace = new ImageIcon(Asset.get("backspace.png"));
        this.add(GUIFactory.makeIconLabel(imageIconBackspace, "Delete last coordinate"));
        return this;
    }

    public UIGuideBarPanel addZoomIn(final UIGuideBarListener listener) {
        ImageIcon imageIconMouseWheel = new ImageIcon(Asset.get("mouse_wheel.png"));
        JLabel label = GUIFactory.makeIconLabel(imageIconMouseWheel, "Zoom in");
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                listener.adjustZoomRelativeToCurrent(2.0);
            }
        });
        this.add(label);
        return this;
    }

    public UIGuideBarPanel addZoomOut(final UIGuideBarListener listener) {
        ImageIcon imageIconMouseWheel = new ImageIcon(Asset.get("mouse_wheel.png"));
        JLabel label = GUIFactory.makeIconLabel(imageIconMouseWheel, "Zoom Out");
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                listener.adjustZoomRelativeToCurrent(0.5);
            }
        });
        this.add(label);
        return this;
    }

    public UIGuideBarPanel addMove() {
        ImageIcon imageIconMouseLeft = new ImageIcon(Asset.get("mouse_left.png"));
        this.add(GUIFactory.makeIconLabel(imageIconMouseLeft, "Move"));
        return this;
    }

    public UIGuideBarPanel addMarkCoordinate() {
        ImageIcon imageIconMouseLeft = new ImageIcon(Asset.get("mouse_right.png"));
        this.add(GUIFactory.makeIconLabel(imageIconMouseLeft, "Mark coordinate"));
        return this;
    }

    public UIGuideBarPanel addMeasure() {
        ImageIcon imageIconMouseLeft = new ImageIcon(Asset.get("mouse_right.png"));
        this.add(GUIFactory.makeIconLabel(imageIconMouseLeft, "Measure (Manual Mode Only)"));
        return this;
    }

    public UIGuideBarPanel addPosition() {
        ImageIcon imageIconMouseLeft = new ImageIcon(Asset.get("mouse_right.png"));
        this.add(GUIFactory.makeIconLabel(imageIconMouseLeft, "Position (Non-GPS Only)"));
        return this;
    }
}

