/*
 * Decompiled with CFR 0.152.
 */
package Graphing;

import Graphing.GraphIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphIterables
implements Iterable<GraphIterable> {
    private String title;
    private List<GraphIterable> iterables = new ArrayList<GraphIterable>();

    public GraphIterables(String title) {
        this.title = title;
    }

    public GraphIterables() {
        this("");
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return String.format("GraphIterables[title=%s,size=%d]", this.title, this.iterables.size());
    }

    public void add(GraphIterable iterable) {
        this.iterables.add(iterable);
    }

    public int size() {
        return this.iterables.size();
    }

    public double getXMin() {
        double xMin = 0.0;
        for (GraphIterable iterable : this.iterables) {
            double iterableXMin = iterable.getXMin();
            double d = xMin = iterableXMin < xMin ? iterableXMin : xMin;
        }
        return xMin;
    }

    public double getYMin() {
        double yMin = 0.0;
        for (GraphIterable iterable : this.iterables) {
            double iterableYMin = iterable.getYMin();
            double d = yMin = iterableYMin < yMin ? iterableYMin : yMin;
        }
        return yMin;
    }

    public double getXMax() {
        double xMax = 0.0;
        for (GraphIterable iterable : this.iterables) {
            double iterableXMax = iterable.getXMax();
            double d = xMax = iterableXMax > xMax ? iterableXMax : xMax;
        }
        return xMax;
    }

    public double getYMax() {
        double yMax = 0.0;
        for (GraphIterable iterable : this.iterables) {
            double iterableYMax = iterable.getYMax();
            double d = yMax = iterableYMax > yMax ? iterableYMax : yMax;
        }
        return yMax;
    }

    @Override
    public Iterator<GraphIterable> iterator() {
        return this.iterables.iterator();
    }
}

