/*
 * Decompiled with CFR 0.152.
 */
package Loader;

import Config.HeatmapRenderConfig;
import Config.InitConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedHashMap;
import java.util.List;

public class InitConfigFileLoader {
    private static HeatmapRenderConfig createDefaultRenderConfig() {
        HeatmapRenderConfig config = new HeatmapRenderConfig();
        config.setImagePlotEnabled(true);
        config.setHeatmapPlotEnabled(true);
        config.setPointPlotEnabled(true);
        config.setValuePlotEnabled(true);
        return config;
    }

    private static String pathRelativeTo(File baseFile, File targetFile) {
        String baseDirectory = baseFile.getParent();
        return new File(baseDirectory, targetFile.getPath()).getAbsolutePath();
    }

    private static String getPathFromJsonObject(File baseFile, JsonObject pathConfig, String key) {
        if (!pathConfig.has(key)) {
            return null;
        }
        String targetPath = pathConfig.get(key).getAsString();
        File targetFile = new File(targetPath);
        return InitConfigFileLoader.pathRelativeTo(baseFile, targetFile);
    }

    public static InitConfig loadJSON(File file) {
        try {
            String configPath = file.getAbsolutePath();
            String csvPath = null;
            String dataPath = null;
            String coordinatesPath = null;
            String imagePath = null;
            LinkedHashMap<String, HeatmapRenderConfig> plotConfigMap = new LinkedHashMap<String, HeatmapRenderConfig>();
            String jsonText = new String(Files.readAllBytes(file.toPath()));
            JsonObject config = JsonParser.parseString(jsonText).getAsJsonObject();
            JsonObject pathConfig = config.get("path").getAsJsonObject();
            csvPath = InitConfigFileLoader.getPathFromJsonObject(file, pathConfig, "csv");
            dataPath = InitConfigFileLoader.getPathFromJsonObject(file, pathConfig, "data");
            coordinatesPath = InitConfigFileLoader.getPathFromJsonObject(file, pathConfig, "coordinates");
            imagePath = InitConfigFileLoader.getPathFromJsonObject(file, pathConfig, "image");
            boolean apLocationAvailable = false;
            int apX = -1;
            int apY = -1;
            if (config.has("ap")) {
                JsonObject apConfig = config.get("ap").getAsJsonObject();
                apLocationAvailable = true;
                apX = apConfig.get("pixelX").getAsInt();
                apY = apConfig.get("pixelY").getAsInt();
            }
            JsonObject plotSetConfig = config.get("plot").getAsJsonObject();
            for (String key : plotSetConfig.keySet()) {
                HeatmapRenderConfig renderConfig = new HeatmapRenderConfig();
                JsonObject plotConfig = plotSetConfig.get(key).getAsJsonObject();
                for (String plotKey : plotConfig.keySet()) {
                    JsonElement value = plotConfig.get(plotKey);
                    switch (plotKey) {
                        case "type": {
                            renderConfig.setType(value.getAsString());
                            break;
                        }
                        case "bounded": {
                            renderConfig.setBoundedRadius(value.getAsBoolean());
                            break;
                        }
                        case "radius": {
                            renderConfig.setRadius(value.getAsInt());
                            break;
                        }
                        case "alpha": {
                            renderConfig.setAlpha(value.getAsInt());
                            break;
                        }
                        case "decimal": {
                            renderConfig.setDecimal(value.getAsInt());
                            break;
                        }
                        case "data_min": {
                            renderConfig.setDataMin(value.getAsDouble());
                            break;
                        }
                        case "data_max": {
                            renderConfig.setDataMax(value.getAsDouble());
                            break;
                        }
                        case "data_scale": {
                            renderConfig.setDataScale(value.getAsDouble());
                            break;
                        }
                        case "plot_value": {
                            renderConfig.setValuePlotEnabled(value.getAsBoolean());
                            break;
                        }
                        case "font_name": {
                            renderConfig.setFontName(value.getAsString());
                            break;
                        }
                        case "font_size": {
                            renderConfig.setFontSize(value.getAsInt());
                            break;
                        }
                        case "font_color": {
                            try {
                                int rgb = 0xFF000000 | Integer.parseInt(value.getAsString().trim(), 16);
                                renderConfig.setFontColor(new Color(rgb));
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                plotConfigMap.put(key, renderConfig);
            }
            return new InitConfig(configPath, csvPath, dataPath, coordinatesPath, imagePath, plotConfigMap, apLocationAvailable, apX, apY);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InitConfig loadCFG(File file) {
        try {
            String configPath = file.getAbsolutePath();
            String csvPath = null;
            String dataPath = null;
            String coordinatesPath = null;
            String imagePath = null;
            LinkedHashMap<String, HeatmapRenderConfig> configMap = new LinkedHashMap<String, HeatmapRenderConfig>();
            HeatmapRenderConfig renderConfig = null;
            List<String> lines = Files.readAllLines(file.toPath());
            block50: for (String line : lines) {
                if ((line = line.trim()).isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
                int assignIndex = line.indexOf(61);
                String key = line.substring(0, assignIndex).trim().toUpperCase();
                String value = line.substring(assignIndex + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                }
                String[] keyFields = key.split("_", -1);
                String type = keyFields[0];
                String dataKey = keyFields[1];
                block5 : switch (type) {
                    case "PATH": {
                        switch (dataKey) {
                            case "CSV": {
                                csvPath = InitConfigFileLoader.pathRelativeTo(file, new File(value));
                                break;
                            }
                            case "DATA": {
                                dataPath = InitConfigFileLoader.pathRelativeTo(file, new File(value));
                                break;
                            }
                            case "COORDINATES": {
                                coordinatesPath = InitConfigFileLoader.pathRelativeTo(file, new File(value));
                                break;
                            }
                            case "IMAGE": {
                                imagePath = InitConfigFileLoader.pathRelativeTo(file, new File(value));
                            }
                        }
                        continue block50;
                    }
                    case "HEATMAP": {
                        String configType;
                        if (!configMap.containsKey(dataKey)) {
                            configMap.put(dataKey, InitConfigFileLoader.createDefaultRenderConfig());
                        }
                        renderConfig = (HeatmapRenderConfig)configMap.get(dataKey);
                        switch (configType = keyFields[2]) {
                            case "TYPE": {
                                renderConfig.setType(value);
                                break block5;
                            }
                            case "BOUNDED": {
                                renderConfig.setBoundedRadius(value.equalsIgnoreCase("true"));
                                break block5;
                            }
                            case "RADIUS": {
                                renderConfig.setRadius(Integer.parseInt(value));
                                break block5;
                            }
                            case "ALPHA": {
                                renderConfig.setAlpha(Integer.parseInt(value));
                                break block5;
                            }
                            case "DECIMAL": {
                                renderConfig.setDecimal(Integer.parseInt(value));
                                break block5;
                            }
                            case "MIN": {
                                renderConfig.setDataMin(Double.parseDouble(value));
                                break block5;
                            }
                            case "MAX": {
                                renderConfig.setDataMax(Double.parseDouble(value));
                                break block5;
                            }
                            case "SCALE": {
                                renderConfig.setDataScale(Double.parseDouble(value));
                                break block5;
                            }
                            case "PLOT-IMAGE": {
                                renderConfig.setImagePlotEnabled(value.equalsIgnoreCase("true"));
                                break block5;
                            }
                            case "PLOT-HEATMAP": {
                                renderConfig.setHeatmapPlotEnabled(value.equalsIgnoreCase("true"));
                                break block5;
                            }
                            case "PLOT-POINT": {
                                renderConfig.setPointPlotEnabled(value.equalsIgnoreCase("true"));
                                break block5;
                            }
                            case "PLOT-VALUE": {
                                renderConfig.setValuePlotEnabled(value.equalsIgnoreCase("true"));
                            }
                        }
                    }
                }
            }
            return new InitConfig(configPath, csvPath, dataPath, coordinatesPath, imagePath, configMap, false, -1, -1);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

