/*
 * Decompiled with CFR 0.152.
 */
package Main;

import AppSCAN.MainSCAN;
import AppSPOT.MainSPOT;
import AppSTAT.MainSTAT;
import AppWAVE.MainWAVE;
import Assets.Asset;
import GUIModule.Art.IntroAnimationPanel;
import GUIModule.Colors;
import Main.SwissMainMenuButton;
import Util.UtilSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class Main
extends JFrame {
    public static final String VERSION = "v1.0";
    public static final String AUTHOR = "Dareun Geum";
    private static final long serialVersionUID = 1L;
    private JPanel titlePanel = new JPanel(new FlowLayout(1));
    private JLabel titleLabel = new JLabel("Newracom SWiSS (Spatial WiFi Site Survey) Toolkit");
    private BufferedImage swissImageIcon = Main.loadImageFromURL(Asset.get("intro_swiss.png"));
    private BufferedImage statImageIcon = Main.loadImageFromURL(Asset.get("intro_stat.png"));
    private BufferedImage waveImageIcon = Main.loadImageFromURL(Asset.get("intro_wave.png"));
    private BufferedImage spotImageIcon = Main.loadImageFromURL(Asset.get("intro_spot.png"));
    private BufferedImage scanImageIcon = Main.loadImageFromURL(Asset.get("intro_scan.png"));
    private IntroAnimationPanel introAnimationPanel = new IntroAnimationPanel();
    private ImagePanel imagePanel = new ImagePanel();
    private JPanel bottomPanel = new JPanel(new BorderLayout());
    private List<SwissMainMenuButton> swissMainMenuButtons = new ArrayList<SwissMainMenuButton>();
    private SwissMainMenuButton statButton = this.createButton("STAT: Spatial Test Automation Tool");
    private SwissMainMenuButton waveButton = this.createButton("WAVE: WiFi Area Visual Evaluator");
    private SwissMainMenuButton instButton = this.createButton("instructions");
    private SwissMainMenuButton spotButton = this.createButton("SPOT: Spatial Position Organizing Tool");
    private SwissMainMenuButton scanButton = this.createButton("SCAN: Station Control & Activity Nexus");
    private JPanel buttonPanel = new JPanel(new GridLayout(5, 1));
    private JPanel descriptionPanel = new JPanel(new BorderLayout());
    private JTextArea descriptionTextArea = new JTextArea();
    public static final String SWISS_DESCRIPTION = "Newracom SWiSS (Spatial WiFi Site Survey)\nv1.0\n\nby Dareun Geum\n\n[Helpful Feedback and Suggestions]\n - David Fix\n - Mark Qureshey\n - Eddie Lim\n";
    private static final String STAT_DESCRIPTION = "STAT (Spatial Test Automation Tool) automates real-time throughput and RSSI/SNR data collection for GPS-mounted stations. The tool also supports non-GPS-assisted operation.";
    private static final String WAVE_DESCRIPTION = "WAVE (WiFi Area Visual Evaluator) is a post-processing tool that turns STAT data logs into heatmaps.";
    private static final String INST_DESCRIPTION = "Documentation on SWiSS usage";
    private static final String SPOT_DESCRIPTION = "SPOT (Spatial Position Organizing Tool) is a helper tool to manually create an indexed list of spatial coordinates on a map image file.";
    private static final String SCAN_DESCRIPTION = "SCAN (Station Control & Activity Nexus) is a centralized station monitoring tool for the access point.";
    public static final String SWISS_3x5_FONT = "SWiSS 3x5";
    private boolean buttonAnimationOn;

    private static BufferedImage loadImageFromURL(URL url) {
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private SwissMainMenuButton createButton(String title) {
        SwissMainMenuButton button = new SwissMainMenuButton(title);
        this.swissMainMenuButtons.add(button);
        return button;
    }

    private synchronized boolean isButtonAnimationOn() {
        return this.buttonAnimationOn;
    }

    private synchronized void setButtonAnimation(boolean value) {
        this.buttonAnimationOn = value;
    }

    private void startButtonAnimation() {
        this.setButtonAnimation(true);
        new Thread(() -> {
            while (this.isButtonAnimationOn()) {
                SwingUtilities.invokeLater(() -> {
                    for (SwissMainMenuButton button : this.swissMainMenuButtons) {
                        button.nextFrame();
                    }
                    this.buttonPanel.repaint();
                });
                UtilSystem.sleep(16);
            }
        }).start();
    }

    public Main() {
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        Dimension minimumWindowSize = new Dimension(900, 900);
        this.setMinimumSize(minimumWindowSize);
        this.setLocationRelativeTo(null);
        this.setTitle("Spatial WiFi Signal Survey (SWiSS) Toolkit v1.0");
        this.titlePanel.add(this.titleLabel);
        this.setIconImage(this.swissImageIcon);
        this.add((Component)this.titlePanel, "North");
        this.introAnimationPanel.startAnimation();
        this.add((Component)this.introAnimationPanel, "Center");
        this.descriptionPanel.add(this.descriptionTextArea);
        this.descriptionPanel.setPreferredSize(new Dimension(450, 200));
        this.bottomPanel.add((Component)this.descriptionPanel, "West");
        this.buttonPanel.add(this.statButton);
        this.buttonPanel.add(this.waveButton);
        this.buttonPanel.add(this.instButton);
        this.buttonPanel.add(this.spotButton);
        this.buttonPanel.add(this.scanButton);
        this.buttonPanel.setPreferredSize(new Dimension(1, 200));
        this.bottomPanel.add((Component)this.buttonPanel, "Center");
        this.startButtonAnimation();
        this.add((Component)this.bottomPanel, "South");
        this.descriptionTextArea.setText(SWISS_DESCRIPTION);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.scanButton.setEnabled(false);
        this.setBackground(Colors.DARK_BLUE_COLOR);
        this.titlePanel.setBackground(Colors.DARKER_GRAY_COLOR.darker());
        this.titleLabel.setFont(new Font("ARIAL", 1, 20));
        this.titleLabel.setForeground(new Color(240, 134, 16));
        this.imagePanel.setBackground(Colors.DARK_BLUE_COLOR);
        this.buttonPanel.setBackground(Color.DARK_GRAY);
        this.descriptionTextArea.setFont(new Font("COURIER NEW", 0, 16));
        this.descriptionTextArea.setForeground(Color.GREEN);
        this.descriptionTextArea.setBackground(Colors.DARKER_GRAY_COLOR);
        this.setButtonInterface(this.statButton, this.statImageIcon, STAT_DESCRIPTION, () -> this.statHandler());
        this.setButtonInterface(this.waveButton, this.waveImageIcon, WAVE_DESCRIPTION, () -> this.waveHandler());
        this.setButtonInterface(this.instButton, this.swissImageIcon, INST_DESCRIPTION, () -> this.instHandler());
        this.setButtonInterface(this.spotButton, this.spotImageIcon, SPOT_DESCRIPTION, () -> this.spotHandler());
        this.setButtonInterface(this.scanButton, this.scanImageIcon, SCAN_DESCRIPTION, () -> this.scanHandler());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                String message = "Are you sure you want to close the program?\n\nAny opened tool instances will also close.";
                String title = "Closing the program";
                int option = JOptionPane.showConfirmDialog(Main.this, message, title, 2, -1, null);
                if (option == 0) {
                    System.exit(0);
                }
            }
        });
    }

    private void statHandler() {
        MainSTAT.main(new String[0]);
    }

    private void waveHandler() {
        MainWAVE.main(new String[0]);
    }

    private void instHandler() {
        try {
            Desktop.getDesktop().open(new File("./docs/index.html"));
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void spotHandler() {
        MainSPOT.main(new String[0]);
    }

    private void scanHandler() {
        MainSCAN.main(new String[0]);
    }

    private void setButtonInterface(SwissMainMenuButton button, final BufferedImage imageIcon, final String description, final Runnable clickHandler) {
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                Main.this.remove(Main.this.imagePanel);
                Main.this.remove(Main.this.introAnimationPanel);
                if (imageIcon != null) {
                    Main.this.add((Component)Main.this.imagePanel, "Center");
                    Main.this.imagePanel.setImage(imageIcon);
                } else {
                    Main.this.add((Component)Main.this.introAnimationPanel, "Center");
                }
                if (description != null) {
                    Main.this.descriptionTextArea.setText(description);
                }
                Main.this.revalidate();
                Main.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent event) {
                Main.this.remove(Main.this.imagePanel);
                Main.this.remove(Main.this.introAnimationPanel);
                Main.this.add((Component)Main.this.introAnimationPanel, "Center");
                Main.this.descriptionTextArea.setText(Main.SWISS_DESCRIPTION);
                Main.this.revalidate();
                Main.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                Main.this.setButtonAnimation(false);
                Main.this.introAnimationPanel.stopAnimation();
                clickHandler.run();
                Main.this.dispose();
            }
        });
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            Main main = new Main();
            main.setVisible(true);
        });
    }

    private class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image image;

        private ImagePanel() {
        }

        public void setImage(Image image) {
            this.image = image;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int w = this.getWidth();
            int h = this.getHeight();
            int imageWidth = this.image.getWidth(null);
            int imageHeight = this.image.getHeight(null);
            if (this.image != null) {
                int offsetX = (w - imageWidth) / 2;
                int offsetY = (h - imageHeight) / 2;
                g.drawImage(this.image, offsetX, offsetY, null);
            }
        }
    }
}

