/*
 * Decompiled with CFR 0.152.
 */
package Main;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class SwissMainMenuButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static int BIG_FONT_SIZE = 32;
    private static int SMALL_FONT_SIZE = 16;
    private static int MAX_FRAME_INDEX = 32;
    private int animationFrame;
    private int animationDelta;
    private String title;
    private static final String FONT_NAME = "COURIER NEW";
    private static final double PHI;
    private static final double PHI0 = 1.0;
    private static final double PHI1;
    private static final double PHI2;
    private static final double PHI3;

    static {
        PHI1 = PHI = Math.sqrt((1.0 + Math.sqrt(5.0)) / 2.0);
        PHI2 = PHI * PHI;
        PHI3 = PHI * PHI * PHI;
    }

    public SwissMainMenuButton(String title) {
        this.title = title;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SwissMainMenuButton.this.animationDelta = 1;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SwissMainMenuButton.this.animationDelta = -2;
            }
        });
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int w = this.getWidth();
        int h = this.getHeight();
        boolean highlight = this.animationFrame > 0 && this.animationDelta > 0;
        String firstChar = this.title.substring(0, 1);
        Font firstCharFont = new Font(FONT_NAME, highlight ? 1 : 0, BIG_FONT_SIZE);
        g.setFont(firstCharFont);
        int firstCharWidth = g.getFontMetrics().stringWidth(firstChar);
        String rest = this.title.substring(1);
        Font restFont = new Font(FONT_NAME, highlight ? 1 : 0, SMALL_FONT_SIZE);
        g.setFont(restFont);
        int x = 10;
        int y = 2 * h / 3;
        g.setColor(highlight ? Color.DARK_GRAY : Color.BLACK);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.WHITE);
        g.setFont(firstCharFont);
        g.drawString(firstChar, x, y);
        g.setFont(restFont);
        g.setColor(Color.LIGHT_GRAY);
        g.drawString(rest, x += firstCharWidth, y);
        int n = rest.length();
        g.setColor(Color.RED);
        g.drawString(rest.substring(0, (int)Math.min((double)n, (double)this.animationFrame * PHI3 * (double)n / (double)MAX_FRAME_INDEX)), x, y);
        g.setColor(Color.GREEN);
        g.drawString(rest.substring(0, (int)Math.min((double)n, (double)this.animationFrame * PHI2 * (double)n / (double)MAX_FRAME_INDEX)), x, y);
        g.setColor(Color.CYAN);
        g.drawString(rest.substring(0, (int)Math.min((double)n, (double)this.animationFrame * PHI1 * (double)n / (double)MAX_FRAME_INDEX)), x, y);
        g.setColor(Color.WHITE);
        g.drawString(rest.substring(0, (int)Math.min((double)n, (double)this.animationFrame * 1.0 * (double)n / (double)MAX_FRAME_INDEX)), x, y);
        g.setColor(Color.DARK_GRAY);
        g.drawLine(0, 0, w, 0);
        g.drawLine(0, h, w, h);
        g.setColor(Color.WHITE);
        g.drawLine(0, 0, (int)Math.min((double)w, 2.5 * (double)w * (double)this.animationFrame / (double)MAX_FRAME_INDEX), 0);
        g.drawLine(0, h - 1, (int)Math.min((double)w, 2.5 * (double)w * (double)this.animationFrame / (double)MAX_FRAME_INDEX), h - 1);
    }

    public void nextFrame() {
        int nextAnimationFrame = this.animationFrame + this.animationDelta;
        this.animationFrame = nextAnimationFrame < 0 ? 0 : (nextAnimationFrame > MAX_FRAME_INDEX ? MAX_FRAME_INDEX : nextAnimationFrame);
    }
}

