/*
 * Decompiled with CFR 0.152.
 */
package Map;

import Config.HeatmapRenderConfig;
import GUIModule.Colors;
import GUIModule.GUIFactory;
import Map.MapConfigChangeObserver;
import Util.UtilSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MapConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title;
    private JTextField decimalField = GUIFactory.makeTextField(2);
    private JSlider decimalSlider = GUIFactory.makeSlider(0, 9, 0);
    private JLabel dataMinLabel = GUIFactory.makeLabel("Min:");
    private JTextField dataMinField = GUIFactory.makeTextField(10);
    private JLabel dataMaxLabel = GUIFactory.makeLabel("Max:");
    private JTextField dataMaxField = GUIFactory.makeTextField(10);
    private JLabel dataScaleLabel = GUIFactory.makeLabel("Scale:");
    private JTextField dataScaleField = GUIFactory.makeTextField(10);
    private JCheckBox valueCheckBox = GUIFactory.makeCheckBox("Value");
    private JButton applyButton = GUIFactory.makeButton("Apply");

    private static JPanel WC(LayoutManager layoutManager, String title, JComponent ... components) {
        JPanel panel = new JPanel(layoutManager){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                Dimension defaultMax = super.getMaximumSize();
                Dimension preferred = this.getPreferredSize();
                return new Dimension(defaultMax.width, preferred.height);
            }
        };
        panel.setBackground(Color.DARK_GRAY);
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent component = jComponentArray[n2];
            panel.add(component);
            ++n2;
        }
        if (title != null) {
            UtilSwing.setBorder(panel, title);
        }
        return panel;
    }

    private static JPanel WC(String title, JComponent ... components) {
        return MapConfigPanel.WC(new FlowLayout(1), title, components);
    }

    private void synchronizeSliderWithField(JSlider slider, JTextField field) {
        field.setText(String.format(" %s ", slider.getValue()));
        slider.addChangeListener(event -> {
            field.setText(String.format(" %s ", slider.getValue()));
            this.repaint();
        });
        this.repaint();
    }

    public MapConfigPanel(String title, MapConfigChangeObserver observer) {
        this.title = title;
        this.setBackground(Color.GRAY);
        this.setLayout(new BoxLayout(this, 1));
        this.add(MapConfigPanel.WC(new GridLayout(2, 1), "DECIMAL", MapConfigPanel.WC(new FlowLayout(1), null, this.decimalField), this.decimalSlider));
        this.add(MapConfigPanel.WC(new GridLayout(3, 1), "DATA", MapConfigPanel.WC(new FlowLayout(2), null, this.dataMinLabel, this.dataMinField), MapConfigPanel.WC(new FlowLayout(2), null, this.dataMaxLabel, this.dataMaxField), MapConfigPanel.WC(new FlowLayout(2), null, this.dataScaleLabel, this.dataScaleField)));
        this.add(MapConfigPanel.WC(new GridLayout(1, 1), "PLOT OPTIONS", this.valueCheckBox));
        this.add(MapConfigPanel.WC(null, this.applyButton));
        this.valueCheckBox.setForeground(Colors.LIGHTER_GRAY_COLOR);
        this.decimalField.setHorizontalAlignment(0);
        this.decimalField.setEditable(false);
        this.dataMinField.setText("0");
        this.dataMaxField.setText("100");
        this.dataScaleField.setText("1");
        this.valueCheckBox.setSelected(true);
        this.synchronizeSliderWithField(this.decimalSlider, this.decimalField);
        this.applyButton.addActionListener(event -> {
            if (observer != null) {
                observer.configChanged(this.getTitle(), this.get());
            }
        });
        SwingUtilities.invokeLater(() -> {
            if (observer != null) {
                observer.configChanged(this.getTitle(), this.get());
            }
        });
    }

    private String getTitle() {
        return this.title;
    }

    private static double GTFD(JTextField field) {
        return Double.parseDouble(field.getText());
    }

    public HeatmapRenderConfig get() {
        try {
            HeatmapRenderConfig config = new HeatmapRenderConfig();
            config.setDecimal(this.decimalSlider.getValue());
            config.setDataMin(MapConfigPanel.GTFD(this.dataMinField));
            config.setDataMax(MapConfigPanel.GTFD(this.dataMaxField));
            config.setDataScale(MapConfigPanel.GTFD(this.dataScaleField));
            config.setValuePlotEnabled(this.valueCheckBox.isSelected());
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void set(HeatmapRenderConfig config) {
        this.decimalSlider.setValue(config.getDecimal());
        this.dataMinField.setText(String.format("%s", config.getDataMin()));
        this.dataMaxField.setText(String.format("%s", config.getDataMax()));
        this.dataScaleField.setText(String.format("%s", config.getDataScale()));
        this.valueCheckBox.setSelected(config.getValuePlotEnabled());
    }
}

