/*
 * Decompiled with CFR 0.152.
 */
package Map;

import Map.Marker;
import Util.UtilTime;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NodeState
implements Iterable<String> {
    private String id;
    private int gpsIndex = -1;
    private long gpsTime = -1L;
    private double gpsLatitude;
    private double gpsLongitude;
    private int gpsSatInView = -1;
    private int gpsSatFixed = -1;
    private boolean gpsValid;
    private int distance;
    private boolean gpsEnabled = true;
    private Marker marker;
    private boolean selected;
    private Map<String, Integer> measurementIndices = new LinkedHashMap<String, Integer>();
    private Map<String, Double> measurementValues = new LinkedHashMap<String, Double>();

    public NodeState(String id) {
        this.id = id;
        this.marker = new Marker(id);
    }

    public String toString() {
        return this.id;
    }

    public String getID() {
        return this.id;
    }

    public void setGPSEnabled(boolean value) {
        this.gpsEnabled = value;
    }

    public boolean isGPSEnabled() {
        return this.gpsEnabled;
    }

    public synchronized boolean updateGPS(JsonObject gps) {
        int index;
        block4: {
            index = gps.get("index").getAsInt();
            if (index != -1) break block4;
            this.gpsValid = false;
            return false;
        }
        try {
            if (this.gpsIndex != index) {
                long time = UtilTime.inMilliseconds();
                double latitude = gps.get("latitude").getAsDouble();
                double longitude = gps.get("longitude").getAsDouble();
                int satInView = gps.get("sat_in_view").getAsInt();
                int satFixed = gps.get("sat_fixed").getAsInt();
                this.gpsIndex = index;
                this.gpsTime = time;
                this.gpsLatitude = latitude;
                this.gpsLongitude = longitude;
                this.gpsSatInView = satInView;
                this.gpsSatFixed = satFixed;
                this.gpsValid = true;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void updateGPSManually(double latitude, double longitude) {
        this.gpsIndex = this.gpsIndex++;
        this.gpsTime = UtilTime.inSeconds();
        this.gpsLatitude = latitude;
        this.gpsLongitude = longitude;
        this.gpsSatInView = 0;
        this.gpsSatFixed = 0;
        this.gpsValid = true;
    }

    public void setSelected(boolean value) {
        this.selected = value;
        this.marker.setSelected(value);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public synchronized boolean getGPSValid() {
        return this.gpsValid;
    }

    public synchronized long getGPSTime() {
        return this.gpsTime;
    }

    public synchronized double getGPSLatitude() {
        return this.gpsLatitude;
    }

    public synchronized double getGPSLongitude() {
        return this.gpsLongitude;
    }

    public synchronized int getSatInView() {
        return this.gpsSatInView;
    }

    public synchronized int getSatFixed() {
        return this.gpsSatFixed;
    }

    public synchronized List<String> updateMeasurements(JsonObject measurements) {
        ArrayList<String> newMeasurementKeys = new ArrayList<String>();
        for (String measurementKey : measurements.keySet()) {
            JsonObject measurementValue = measurements.get(measurementKey).getAsJsonObject();
            try {
                int index = measurementValue.get("index").getAsInt();
                if (index == -1) continue;
                double value = measurementValue.get("value").getAsDouble();
                if (this.measurementIndices.containsKey(measurementKey) && this.measurementIndices.get(measurementKey) == index) continue;
                this.measurementIndices.put(measurementKey, index);
                this.measurementValues.put(measurementKey, value);
                newMeasurementKeys.add(measurementKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newMeasurementKeys;
    }

    public synchronized double getMeasurementValue(String measurementKey) {
        return this.measurementValues.get(measurementKey);
    }

    @Override
    public Iterator<String> iterator() {
        return this.measurementIndices.keySet().iterator();
    }

    public int getMaxKeyLength() {
        int max = 0;
        for (String key : this) {
            int length = key.length();
            if (max >= length) continue;
            max = length;
        }
        return max;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }
}

