/*
 * Decompiled with CFR 0.152.
 */
package Map;

import Map.WebMercator;

public class WebMercatorConverter {
    private double phi1;
    private double psi1;
    private double phi2;
    private double psi2;
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public WebMercatorConverter(double phi1, double psi1, double phi2, double psi2) {
        this.phi1 = phi1;
        this.psi1 = psi1;
        this.phi2 = phi2;
        this.psi2 = psi2;
        if (phi1 != 0.0 || psi1 != 0.0 || phi2 != 0.0 || psi2 != 0.0) {
            this.x1 = WebMercator.psiToNormalizedResourceX(psi1);
            this.y1 = WebMercator.phiToNormalizedResourceY(phi1);
            this.x2 = WebMercator.psiToNormalizedResourceX(psi2);
            this.y2 = WebMercator.phiToNormalizedResourceY(phi2);
        }
    }

    public double getStartPhi() {
        return this.phi1;
    }

    public double getStartPsi() {
        return this.psi1;
    }

    public double getEndPhi() {
        return this.phi2;
    }

    public double getEndPsi() {
        return this.psi2;
    }

    public double getRatioX(double psi) {
        return (WebMercator.psiToNormalizedResourceX(psi) - this.x1) / (this.x2 - this.x1);
    }

    public double getRatioY(double phi) {
        return (WebMercator.phiToNormalizedResourceY(phi) - this.y1) / (this.y2 - this.y1);
    }

    public double getPsi(double ratioX) {
        return WebMercator.normalizedResourceXToPsi(this.x1 + ratioX * (this.x2 - this.x1));
    }

    public double getPhi(double ratioY) {
        return WebMercator.normalizedResourceYToPhi(this.y1 + ratioY * (this.y2 - this.y1));
    }
}

