/*
 * Decompiled with CFR 0.152.
 */
package Server.AP;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public class SWiSSAPServerConfig {
    private int port;
    private boolean gpsEnabled;
    private String gpsPath;
    private boolean monitorRemoteSTA;
    private int remoteSTAServerPort;
    private boolean retrieveSTAIPFromARP;
    private String arpNetworkInterface;
    private List<String> staAddressList = new ArrayList<String>();

    public SWiSSAPServerConfig(File file) throws IOException {
        String text = new String(Files.readAllBytes(file.toPath()));
        JsonObject json = JsonParser.parseString(text).getAsJsonObject();
        block20: for (String key : json.keySet()) {
            System.out.println("KEY=[" + key + "]");
            JsonElement value = json.get(key);
            System.out.println("VALUE=[" + value + "]");
            switch (key) {
                case "AP_SWISS_SERVER_PORT": {
                    this.port = value.getAsInt();
                    break;
                }
                case "USE_GPS": {
                    this.gpsEnabled = json.get(key).getAsBoolean();
                    break;
                }
                case "GPS_PATH": {
                    this.gpsPath = json.get(key).getAsString();
                    break;
                }
                case "MONITOR_REMOTE_STA": {
                    this.monitorRemoteSTA = value.getAsBoolean();
                    break;
                }
                case "REMOTE_STA_SWISS_SERVER_PORT": {
                    this.remoteSTAServerPort = value.getAsInt();
                    break;
                }
                case "RETRIEVE_STA_IP_FROM_ARP": {
                    this.retrieveSTAIPFromARP = value.getAsBoolean();
                    break;
                }
                case "ARP_NETWORK_INTERFACE": {
                    this.arpNetworkInterface = value.getAsString();
                    break;
                }
                case "EXPLICIT_STA_ADDRESS_LIST": {
                    JsonArray array = value.getAsJsonArray();
                    for (JsonElement element : array) {
                        JsonArray innerArray = element.getAsJsonArray();
                        String identifier = String.valueOf(innerArray.get(0).getAsString()) + "/" + innerArray.get(1).getAsString();
                        this.staAddressList.add(identifier);
                    }
                    continue block20;
                }
                default: {
                    System.err.printf("[ERROR] Unknown STA configuration parameter: %s\n", key);
                }
            }
        }
    }

    public int port() {
        return this.port;
    }

    public boolean gpsEnabled() {
        return this.gpsEnabled;
    }

    public String gpsPath() {
        return this.gpsPath;
    }

    public boolean monitorRemoteSTA() {
        return this.monitorRemoteSTA;
    }

    public int remoteSTAServerPort() {
        return this.remoteSTAServerPort;
    }

    public boolean retrieveSTAIPFromARP() {
        return this.retrieveSTAIPFromARP;
    }

    public String arpNetworkInterface() {
        return this.arpNetworkInterface;
    }

    public List<String> explicitSTAAddressList() {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(this.staAddressList);
        return copy;
    }
}

