/*
 * Decompiled with CFR 0.152.
 */
package Server.STA.NRC5292Modem;

import com.fazecast.jSerialComm.SerialPort;

public class Serial {
    private SerialPort port;
    private boolean isConnected;
    private int CHAR_DELAY = 1;
    private int LINE_DELAY = 10;
    private byte[] READ_BUFFER = new byte[1];
    private byte[] WRITE_BUFFER = new byte[1];

    public SerialPort getSerialPort() {
        return this.port;
    }

    public int getCharDelay() {
        return this.CHAR_DELAY;
    }

    public int getLineDelay() {
        return this.LINE_DELAY;
    }

    public void setCharDelay(int value) {
        this.CHAR_DELAY = value;
    }

    public void setLineDelay(int value) {
        this.LINE_DELAY = value;
    }

    public boolean connect(String name, int baudrate) {
        try {
            this.port = SerialPort.getCommPort(name);
            this.port.setBaudRate(baudrate);
            this.isConnected = this.port.openPort();
            return this.isConnected;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
            return false;
        }
    }

    public boolean connect(String name) {
        return this.connect(name, 115200);
    }

    public void disconnect() {
        if (this.port != null) {
            this.port.closePort();
        }
        this.isConnected = false;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public static String[] getSerialPortNames() {
        SerialPort[] ports = SerialPort.getCommPorts();
        String[] names = new String[ports.length];
        int i = 0;
        while (i < ports.length) {
            names[i] = ports[i].getSystemPortName();
            ++i;
        }
        return names;
    }

    public void writeRaw(byte b) {
        this.WRITE_BUFFER[0] = b;
        this.port.writeBytes(this.WRITE_BUFFER, 1L);
    }

    public void write(char c) throws InterruptedException {
        this.writeRaw((byte)c);
        System.out.print(c);
        Thread.sleep(this.getCharDelay());
    }

    public void delay(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void writeLine(String line, String terminator) throws InterruptedException {
        int n = line.length();
        int i = 0;
        while (i < n) {
            this.write(line.charAt(i));
            ++i;
        }
        int m = terminator.length();
        int i2 = 0;
        while (i2 < m) {
            this.write(terminator.charAt(i2));
            ++i2;
        }
        Thread.sleep(this.getLineDelay());
    }

    public void writeLine(String line) throws InterruptedException {
        this.writeLine(line, "\r");
    }

    public int bytesAvailable() {
        return this.port.bytesAvailable();
    }

    public boolean availableBytesExist() {
        return this.bytesAvailable() > 0;
    }

    public void blockUntilAvailableBytesExist() {
        while (!this.availableBytesExist()) {
        }
    }

    public int readNonBlocking() {
        if (this.port.bytesAvailable() <= 0 || this.port.readBytes(this.READ_BUFFER, 1L) <= 0) {
            return -1;
        }
        byte b = this.READ_BUFFER[0];
        return b;
    }

    public byte readBlocking() {
        this.blockUntilAvailableBytesExist();
        this.port.readBytes(this.READ_BUFFER, 1L);
        byte b = this.READ_BUFFER[0];
        return b;
    }

    public boolean read(StringBuffer buffer, int timeout) throws InterruptedException {
        long initTime = System.currentTimeMillis();
        while (!this.availableBytesExist()) {
            if (System.currentTimeMillis() - initTime > (long)timeout) {
                return false;
            }
            Thread.sleep(1L);
        }
        this.port.readBytes(this.READ_BUFFER, 1L);
        byte b = this.READ_BUFFER[0];
        buffer.append((char)b);
        System.out.print((char)b);
        return true;
    }

    public int flush() throws InterruptedException {
        int count = 0;
        while (this.availableBytesExist()) {
            this.port.readBytes(this.READ_BUFFER, 1L);
            byte b = this.READ_BUFFER[0];
            System.out.print((char)b);
            ++count;
        }
        return count;
    }

    public String query(String format, Object ... args) throws InterruptedException {
        String terminator = "_evk>";
        int timeout = 10;
        String line = String.format(format, args);
        StringBuffer buffer = new StringBuffer();
        this.writeLine(line);
        while (!buffer.toString().endsWith(terminator)) {
            if (!this.read(buffer, timeout)) break;
        }
        while (this.availableBytesExist()) {
            this.read(buffer, timeout);
        }
        System.out.printf("query(%s,%s,%d)\n", line, terminator, timeout);
        System.out.printf("<%s>\n", buffer.toString());
        return buffer.toString();
    }
}

