/*
 * Decompiled with CFR 0.152.
 */
package Server.STA.NRC7394Host;

import Main.Encryption;
import Server.STA.NRC7394Host.SWiSSSTAServerConfig;
import Server._Common.Client;
import Server._Common.Execution;
import Server._Common.GPSData;
import Server._Common.MeasurementData;
import Server._Common.TCPServer;
import Util.UtilSystem;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SWiSSSTAServer
extends TCPServer {
    private SWiSSSTAServerConfig config;
    private GPSData gps;
    private Map<String, MeasurementData> measurements = new LinkedHashMap<String, MeasurementData>();
    private Object lockCliApp = new Object();
    private int getIndex = -1;

    public SWiSSSTAServer(SWiSSSTAServerConfig config) {
        super(config.getPort());
        this.config = config;
    }

    private synchronized void setGPSData(GPSData gps) {
        this.gps = gps;
    }

    private synchronized GPSData getGPSData() {
        return this.gps;
    }

    private synchronized void addMeasurementData(MeasurementData measurement) {
        this.measurements.put(measurement.getName(), measurement);
    }

    private Thread updateAsynchronouslyForever(Runnable runnable) {
        return UtilSystem.startThread(() -> {
            while (true) {
                try {
                    while (true) {
                        runnable.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UtilSystem.sleep(1000);
                    continue;
                }
                break;
            }
        });
    }

    private Thread updateAsynchronouslyForeverPassively(Runnable runnable) {
        return UtilSystem.startThread(() -> {
            int lastGetIndex = -1;
            while (true) {
                try {
                    while (true) {
                        int getIndex;
                        if ((getIndex = this.getGetIndex()) == lastGetIndex) {
                            continue;
                        }
                        runnable.run();
                        lastGetIndex = getIndex;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UtilSystem.sleep(1000);
                    continue;
                }
                break;
            }
        });
    }

    private synchronized int getGetIndex() {
        return this.getIndex;
    }

    private synchronized void incrementGetIndex() {
        ++this.getIndex;
    }

    private void updateIperf3(MeasurementData tcpUl, MeasurementData tcpDl, MeasurementData udpUl, MeasurementData udpDl) {
        String timeoutPath = Execution.which("timeout");
        String iperf3Path = Execution.which("iperf3");
        int timeout = this.config.iperf3Duration() + this.config.iperf3Omission() + 5;
        String baseCommand = String.format("%s %d %s -c %s -p %s -t %d -f k -O %s --json", timeoutPath, timeout, iperf3Path, this.config.remoteIP(), this.config.iperf3RemotePort(), this.config.iperf3Duration(), this.config.iperf3Omission());
        MeasurementData[] dataList = new MeasurementData[]{tcpUl, tcpDl, udpUl, udpDl};
        String[] protoDirArgs = new String[]{" ", " -R", " -u -b 15m", " -u -b 15m -R"};
        String[] protoDirNames = new String[]{"TCP-UL", "TCP-DL", "UDP-UL", "UDP-DL"};
        int i = 0;
        while (i < 4) {
            boolean isUDP;
            MeasurementData data = dataList[i];
            boolean bl = isUDP = i >= 2;
            if (data != null) {
                String command = String.valueOf(baseCommand) + protoDirArgs[i];
                if (this.config.iperf3RemoteSessionRenewEnabled()) {
                    while (true) {
                        Client client = null;
                        try {
                            client = new Client(this.config.remoteIP(), this.config.remoteControlServerPort());
                            String line = Encryption.encodeLine("IPERF3 " + this.config.iperf3RemotePort());
                            client.writeLine(line);
                            client.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            continue;
                        }
                        finally {
                            UtilSystem.sleep(2000);
                            if (client == null) continue;
                            client.close();
                            continue;
                        }
                        break;
                    }
                }
                try {
                    String jsonOutput = Execution.executeAndGetSTDOUTAsString(command);
                    JsonObject json = JsonParser.parseString(jsonOutput).getAsJsonObject();
                    System.out.println(command);
                    System.out.println(json);
                    json = json.getAsJsonObject("end");
                    json = json.getAsJsonObject(isUDP && json.has("sum") ? "sum" : "sum_received");
                    double rate = json.get("bits_per_second").getAsDouble();
                    data.update(rate);
                    System.out.printf("[UPDATE] %s=%.1f\n", protoDirNames[i], rate);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    data.update(0.0);
                }
            }
            ++i;
        }
        UtilSystem.sleep(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalRSSISNR(MeasurementData localRSSIData, MeasurementData localSNRData) {
        String command = "/home/pi/nrc_pkg/script/cli_app show signal";
        try {
            String[] lines;
            String stdout = null;
            Object object = this.lockCliApp;
            synchronized (object) {
                stdout = Execution.executeAndGetSTDOUTAsString(command);
            }
            String[] stringArray = lines = stdout.split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if ((line = line.trim()).contains("rssi") && line.contains("snr")) {
                    line = line.substring(line.indexOf("rssi"));
                    int rssi = Integer.parseInt(line.substring(line.indexOf(":") + 1, line.indexOf("snr")).trim());
                    line = line.substring(line.indexOf("snr"));
                    int snr = Integer.parseInt(line.substring(line.indexOf(":") + 1).trim());
                    localRSSIData.update(rssi);
                    localSNRData.update(snr);
                    System.out.printf("[UPDATE] RSSI(LOCAL)=%d SNR(LOCAL)=%d\n", rssi, snr);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UtilSystem.sleep(this.config.localRSSISNRPeriod() * 1000);
    }

    private int[] stringsToInts(String[] strings) {
        int[] ints = new int[strings.length];
        int i = 0;
        while (i < strings.length) {
            ints[i] = Integer.parseInt(strings[i]);
            ++i;
        }
        return ints;
    }

    private String getNetworkAddress(String ip, String netmask) {
        int[] splitIP = this.stringsToInts(ip.split("[.]"));
        int[] splitNetmask = this.stringsToInts(netmask.split("[.]"));
        int[] splitAnd = new int[4];
        int i = 0;
        while (i < 4) {
            splitAnd[i] = splitIP[i] & splitNetmask[i];
            ++i;
        }
        return String.format("%d.%d.%d.%d", splitAnd[0], splitAnd[1], splitAnd[2], splitAnd[3]);
    }

    private String getLocalMACAddress() {
        String command = "ifconfig";
        Execution execution = new Execution(command);
        execution.run();
        String stdout = new String(execution.stdout());
        String[] lines = stdout.split("\n");
        String interfaceName = null;
        String ip = null;
        String netmask = null;
        String ether = null;
        String remoteIP = this.config.remoteIP();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fields;
            String line = stringArray[n2];
            if (line.contains(": ")) {
                interfaceName = line.substring(0, line.indexOf(58));
                ip = null;
                netmask = null;
                ether = null;
            } else if (line.contains("netmask")) {
                fields = line.trim().split("\\s+");
                ip = fields[1];
                netmask = fields[3];
            } else if (line.contains("ether")) {
                fields = line.trim().split("\\s+");
                ether = fields[1];
            }
            if (ip != null && netmask != null && ether != null) {
                String networkAddressLocal = this.getNetworkAddress(ip, netmask);
                String networkAddressRemote = this.getNetworkAddress(remoteIP, netmask);
                System.out.printf("%s/%s/%s/%s\n", interfaceName, ip, netmask, ether);
                if (networkAddressLocal.equals(networkAddressRemote)) {
                    return ether;
                }
            }
            ++n2;
        }
        return null;
    }

    private void updateRemoteRSSISNR(MeasurementData remoteRSSIData, MeasurementData remoteSNRData) {
        UtilSystem.sleep(this.config.remoteRSSISNRPeriod() * 1000);
        String localMACAddress = this.getLocalMACAddress();
        if (localMACAddress == null) {
            System.out.println("[MESSAGE] Local MAC address not found.");
            UtilSystem.sleep(1000);
            return;
        }
        try (Client client = null;){
            try {
                client = new Client(this.config.remoteIP(), this.config.remoteControlServerPort());
                String line = Encryption.encodeLine("RSSI_SNR " + localMACAddress);
                client.writeLine(line);
                String response = Encryption.decodeLine(client.readLine());
                JsonObject jsonRSSISNR = JsonParser.parseString(response).getAsJsonObject();
                jsonRSSISNR = jsonRSSISNR.get("rssi_snr").getAsJsonObject();
                int rssi = jsonRSSISNR.get("rssi").getAsInt();
                int snr = jsonRSSISNR.get("snr").getAsInt();
                remoteRSSIData.update(rssi);
                remoteSNRData.update(snr);
                System.out.printf("[UPDATE] RSSI(REMOTE)=%d SNR(REMOTE)=%d\n", rssi, snr);
            }
            catch (IOException e) {
                e.printStackTrace();
                UtilSystem.sleep(2000);
                if (client != null) {
                    client.close();
                }
            }
        }
    }

    private void updatePing(MeasurementData rttData) {
        String pingPath = Execution.which("ping");
        String command = String.format("%s %s -c 1", pingPath, this.config.remoteIP());
        try {
            String[] lines;
            Execution execution = new Execution(command);
            execution.run();
            byte[] stdout = execution.stdout();
            String[] stringArray = lines = new String(stdout).split("\n");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if ((line = line.trim()).contains("time=") && line.endsWith("ms")) {
                    line = line.substring(line.indexOf("time=") + 5, line.length() - 2).trim();
                    double rtt = Double.parseDouble(line);
                    rttData.update(rtt);
                    System.out.printf("[UPDATE] RTT=%s\n", rtt);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UtilSystem.sleep(this.config.pingPeriod() * 1000);
    }

    @Override
    public void preStart() {
        if (this.config.gpsEnabled()) {
            this.gps = new GPSData();
            this.setGPSData(this.gps);
            String gpsPath = this.config.gpsPath();
            this.updateAsynchronouslyForever(() -> GPSData.updateGPS(gpsPath, this.gps));
        }
        if (this.config.iperf3Enabled()) {
            MeasurementData tcpUl = null;
            MeasurementData tcpDl = null;
            MeasurementData udpUl = null;
            MeasurementData udpDl = null;
            if (this.config.iperf3TCPUplink()) {
                tcpUl = new MeasurementData("TCP-UL[bps]", 0.0, 1.0E7, 1.0E-6, 1);
                this.addMeasurementData(tcpUl);
            }
            if (this.config.iperf3TCPDownlink()) {
                tcpDl = new MeasurementData("TCP-DL[bps]", 0.0, 1.0E7, 1.0E-6, 1);
                this.addMeasurementData(tcpDl);
            }
            if (this.config.iperf3UDPUplink()) {
                udpUl = new MeasurementData("UDP-UL[bps]", 0.0, 1.0E7, 1.0E-6, 1);
                this.addMeasurementData(udpUl);
            }
            if (this.config.iperf3UDPDownlink()) {
                udpDl = new MeasurementData("UDP-DL[bps]", 0.0, 1.0E7, 1.0E-6, 1);
                this.addMeasurementData(udpDl);
            }
            MeasurementData tu = tcpUl;
            MeasurementData td = tcpDl;
            MeasurementData uu = udpUl;
            MeasurementData ud = udpDl;
            this.updateAsynchronouslyForeverPassively(() -> this.updateIperf3(tu, td, uu, ud));
        }
        if (this.config.localRSSISNREnabled()) {
            MeasurementData localRSSIData = new MeasurementData("RSSI(LOCAL)[dBm]", -80.0, 0.0, 1.0, 0);
            MeasurementData localSNRData = new MeasurementData("SNR(LOCAL)[dB]", 0.0, 35.0, 1.0, 0);
            this.addMeasurementData(localRSSIData);
            this.addMeasurementData(localSNRData);
            this.updateAsynchronouslyForeverPassively(() -> this.updateLocalRSSISNR(localRSSIData, localSNRData));
        }
        if (this.config.remoteRSSISNREnabled()) {
            MeasurementData remoteRSSIData = new MeasurementData("RSSI(REMOTE)[dBm]", -80.0, 0.0, 1.0, 0);
            MeasurementData remoteSNRData = new MeasurementData("SNR(REMOTE)[dB]", 0.0, 35.0, 1.0, 0);
            this.addMeasurementData(remoteRSSIData);
            this.addMeasurementData(remoteSNRData);
            this.updateAsynchronouslyForeverPassively(() -> this.updateRemoteRSSISNR(remoteRSSIData, remoteSNRData));
        }
        if (this.config.pingEnabled()) {
            MeasurementData rttData = new MeasurementData("RTT[ms]", 1000.0, 0.0, 1.0, 0);
            this.addMeasurementData(rttData);
            this.updateAsynchronouslyForeverPassively(() -> this.updatePing(rttData));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStatus(JsonObject buf) {
        String cli_app_path = "/home/pi/nrc_pkg/script/cli_app";
        buf.addProperty("ifconfig", Execution.executeAndGetSTDOUTAsString("ifconfig"));
        Object object = this.lockCliApp;
        synchronized (object) {
            buf.addProperty("cli_app(config)", Execution.executeAndGetSTDOUTAsString(String.valueOf(cli_app_path) + " show config"));
            buf.addProperty("cli_app(uinfo)", Execution.executeAndGetSTDOUTAsString(String.valueOf(cli_app_path) + " show uinfo 0"));
        }
    }

    @Override
    public void handleClientRequest(Client client, String address) {
        try {
            String command = client.readLine();
            command = Encryption.decodeLine(command);
            System.out.printf("[COMMAND(%s)] %s\n", address, command);
            JsonObject res = new JsonObject();
            switch (command) {
                case "HEAD": {
                    res.addProperty("version", "v1.0");
                    res.addProperty("passive_mode", false);
                    JsonObject measurementHead = new JsonObject();
                    for (String key : this.measurements.keySet()) {
                        measurementHead.add(key, this.measurements.get(key).head());
                    }
                    res.add("measurements", measurementHead);
                    break;
                }
                case "GET": {
                    this.incrementGetIndex();
                    GPSData gpsData = this.getGPSData();
                    if (gpsData != null) {
                        res.add("gps", gpsData.get());
                    }
                    JsonObject measurementGet = new JsonObject();
                    for (String key : this.measurements.keySet()) {
                        measurementGet.add(key, this.measurements.get(key).get());
                    }
                    res.add("measurements", measurementGet);
                    break;
                }
                case "STATUS": {
                    this.getStatus(res);
                    break;
                }
                default: {
                    System.err.printf("[ERROR(%s)] Unknown Command: %s\n", address, command);
                    return;
                }
            }
            String line = res.toString();
            line = Encryption.encodeLine(line);
            client.writeLine(line);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

