/*
 * Decompiled with CFR 0.152.
 */
package Server._Common;

import Util.UtilSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Execution {
    private String command;
    private List<Byte> stdout = new ArrayList<Byte>();
    private List<Byte> stderr = new ArrayList<Byte>();
    private int exitCode;

    public Execution(String command) {
        this.command = command;
    }

    private synchronized void putByte(byte b, List<Byte> container) {
        container.add(b);
    }

    private void gobbleStream(String name, InputStream stream, List<Byte> container) {
        try {
            int b;
            while ((b = stream.read()) != -1) {
                this.putByte((byte)b, container);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void join(int millis, Thread ... threads) {
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = threadArray[n2];
            try {
                thread.join(millis);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void run() {
        ProcessBuilder builder = new ProcessBuilder(this.command.split("\\s+"));
        Process process = null;
        try {
            process = builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        InputStream is = process.getInputStream();
        InputStream es = process.getErrorStream();
        Thread isThread = UtilSystem.startThread(() -> this.gobbleStream("IS", is, this.stdout));
        Thread esThread = UtilSystem.startThread(() -> this.gobbleStream("ES", es, this.stderr));
        while (process.isAlive()) {
            UtilSystem.sleep(1);
        }
        this.join(1000, isThread, esThread);
        this.exitCode = process.exitValue();
    }

    public String command() {
        return this.command;
    }

    public synchronized byte[] stdout() {
        int n = this.stdout.size();
        byte[] res = new byte[n];
        int i = 0;
        while (i < n) {
            res[i] = this.stdout.get(i);
            ++i;
        }
        return res;
    }

    public synchronized byte[] stderr() {
        int n = this.stderr.size();
        byte[] res = new byte[n];
        int i = 0;
        while (i < n) {
            res[i] = this.stderr.get(i);
            ++i;
        }
        return res;
    }

    public int exitCode() {
        return this.exitCode;
    }

    public static String executeAndGetSTDOUTAsString(String command) {
        Execution execution = new Execution(command);
        execution.run();
        return new String(execution.stdout());
    }

    public static String which(String util) {
        String stdout = Execution.executeAndGetSTDOUTAsString("which " + util);
        String line = stdout.split("\n")[0].trim();
        return line;
    }
}

