/*
 * Decompiled with CFR 0.152.
 */
package Server._Common;

import com.google.gson.JsonObject;

public class MeasurementData {
    private String name;
    private long index = -1L;
    private long time;
    private double value;
    private double dataMin;
    private double dataMax;
    private double dataScale;
    private int decimal;

    public MeasurementData(String name, double dataMin, double dataMax, double dataScale, int decimal) {
        this.name = name;
        this.dataMin = dataMin;
        this.dataMax = dataMax;
        this.dataScale = dataScale;
        this.decimal = decimal;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void update(double value) {
        ++this.index;
        this.time = System.currentTimeMillis();
        this.value = value;
        System.out.printf("[UPDATE(%s)] %s\n", this.name, value);
    }

    public synchronized JsonObject head() {
        JsonObject res = new JsonObject();
        res.addProperty("data_min", this.dataMin);
        res.addProperty("data_max", this.dataMax);
        res.addProperty("data_scale", this.dataScale);
        res.addProperty("decimal", this.decimal);
        return res;
    }

    public synchronized JsonObject get() {
        JsonObject res = new JsonObject();
        res.addProperty("index", this.index);
        res.addProperty("time", this.time);
        res.addProperty("value", this.value);
        return res;
    }

    public String toString() {
        return this.get().toString();
    }
}

