/*
 * Decompiled with CFR 0.152.
 */
package AppSPOT;

import AppSPOT.Coordinate;
import AppSPOT.CoordinateMarkerPanel;
import GUIModule.Colors;
import GUIModule.GUIFactory;
import GUIModule.UIGuideBar.UIGuideBarListener;
import GUIModule.UIGuideBar.UIGuideBarPanel;
import Main.AboutPanel;
import Main.Main;
import Util.UtilDate;
import Util.UtilSwing;
import Util.UtilSystem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MainSPOT
extends JFrame
implements UIGuideBarListener {
    private static final long serialVersionUID = 1L;
    private AboutPanel aboutPanel = new AboutPanel();
    private JPanel coordinateListPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel buttonPanel = GUIFactory.makePanel(new GridLayout(7, 1));
    private JPanel indexPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JLabel indexLabel = GUIFactory.makeLabel("Next Coordinate Index:");
    private JTextField indexField = GUIFactory.makeTextField(3);
    private JButton coordinateCopyButton = GUIFactory.makeButton("Copy to Clipboard");
    private JButton shiftUpButton = GUIFactory.makeButton("Shift Up the Selected Coordinate");
    private JButton shiftDownButton = GUIFactory.makeButton("Shift Down the Selected Coordinate");
    private JButton deleteSelectedCoordinateButton = GUIFactory.makeButton("Delete Selected Coordinate");
    private JButton saveToFileButton = GUIFactory.makeButton("Save the Coordinates to a File");
    private JButton loadFromFileButton = GUIFactory.makeButton("Load Coordinates from a File");
    private DefaultListModel<Coordinate> coordinateListModel = new DefaultListModel();
    private JList<Coordinate> coordinateList = new JList<Coordinate>(this.coordinateListModel);
    private JScrollPane coordinatePane = GUIFactory.makeScrollPane(this.coordinateList);
    private UIGuideBarPanel uiGuidePanel = new UIGuideBarPanel().addAspectFit(this).addOriginalFit(this).addDeleteLastCoordinate().addZoomIn(this).addZoomOut(this).addMove().addMarkCoordinate();
    private CoordinateMarkerPanel coordinateMarkerPanel = new CoordinateMarkerPanel(this.coordinateListModel);
    private JFileChooser fileChooser = new JFileChooser();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu swissMenu = new JMenu("SWiSS");
    private JMenuItem aboutMenuItem = new JMenuItem("About");
    private JMenu mapMenu = new JMenu("Map");
    private JMenuItem loadImageFileMenuItem = new JMenuItem("Load Image");
    private JMenuItem saveImageFileMenuItem = new JMenuItem("Save Marked Image");

    public MainSPOT(String imagePath) {
        this.fileChooser.setCurrentDirectory(new File("~"));
        this.setIconImage(Main.swissImageIcon);
        this.setTitle("Newracom Spatial Position Organizing Tool (SPOT) v1.0");
        this.setDefaultCloseOperation(0);
        this.setSize(new Window(null).getGraphicsConfiguration().getBounds().getSize());
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.coordinateListPanel.setBorder(BorderFactory.createTitledBorder("Indexed Spatial Coordinates"));
        this.setBackground(Color.BLACK);
        this.coordinateList.setBackground(Colors.DARKER_GRAY_COLOR);
        this.coordinateList.setForeground(Color.ORANGE);
        this.coordinateList.setSelectionMode(0);
        this.coordinateCopyButton.setBackground(Color.LIGHT_GRAY);
        this.add((Component)this.coordinateMarkerPanel, "Center");
        UtilSwing.add(this.buttonPanel, UtilSwing.add(this.indexPanel, this.indexLabel, this.indexField), this.coordinateCopyButton, this.deleteSelectedCoordinateButton, this.shiftUpButton, this.shiftDownButton, this.saveToFileButton, this.loadFromFileButton);
        this.coordinateListPanel.add((Component)this.buttonPanel, "North");
        this.coordinateListPanel.add((Component)this.coordinatePane, "Center");
        this.indexField.setText("0");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                String message = "Are you sure you want to close the program?";
                String title = "Closing the program";
                int option = JOptionPane.showConfirmDialog(MainSPOT.this, message, title, 2, -1, null);
                if (option == 0) {
                    MainSPOT.this.dispose();
                    System.exit(0);
                }
            }
        });
        this.coordinateCopyButton.addActionListener(event -> {
            String text = this.getIndexedCoordinatesAsString();
            UtilSystem.copyToClipboard(text.toString());
        });
        this.saveToFileButton.addActionListener(event -> {
            this.fileChooser.setSelectedFile(new File("coordinates.csv"));
            this.fileChooser.setFileSelectionMode(0);
            if (this.fileChooser.showSaveDialog(this) != 0) {
                return;
            }
            File file = this.fileChooser.getSelectedFile();
            String text = this.getIndexedCoordinatesAsString();
            try {
                Files.write(file.toPath(), text.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.loadFromFileButton.addActionListener(event -> {
            this.fileChooser.setDialogTitle("Loading coordinates");
            this.fileChooser.setFileSelectionMode(0);
            if (this.fileChooser.showOpenDialog(this) != 0) {
                return;
            }
            this.coordinateListModel.removeAllElements();
            File file = this.fileChooser.getSelectedFile();
            try {
                List<String> lines = Files.readAllLines(file.toPath());
                int lineIndex = 0;
                for (String line : lines) {
                    ++lineIndex;
                    if ((line = line.trim()).isEmpty()) continue;
                    System.out.println(line);
                    long maxIndex = 0L;
                    try {
                        String[] fields = line.split(",", -1);
                        long index = Long.parseLong(fields[0]);
                        int px = Integer.parseInt(fields[1]);
                        int py = Integer.parseInt(fields[2]);
                        this.addCoordinate(index, px, py);
                        maxIndex = index > maxIndex ? index : maxIndex;
                    }
                    catch (Exception e) {
                        System.err.printf("[ERROR: LINE%d could not be parsed.]\n", lineIndex);
                        e.printStackTrace();
                    }
                    this.indexField.setText(String.format("%d", maxIndex + 1L));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.repaint();
        });
        this.deleteSelectedCoordinateButton.addActionListener(event -> {
            int selectedIndex = this.coordinateList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            this.coordinateListModel.remove(selectedIndex);
            int n = this.coordinateListModel.getSize();
            int i = selectedIndex;
            while (i < n) {
                this.coordinateListModel.get(i).shiftIndex(-1);
                ++i;
            }
            this.coordinateList.setSelectedIndex(selectedIndex);
            this.repaint();
        });
        this.shiftUpButton.addActionListener(event -> {
            int selectedIndex = this.coordinateList.getSelectedIndex();
            if (selectedIndex == -1 || selectedIndex == 0) {
                return;
            }
            this.swapCoordinates(selectedIndex - 1, selectedIndex);
            this.coordinateList.setSelectedIndex(selectedIndex - 1);
            this.repaint();
        });
        this.shiftDownButton.addActionListener(event -> {
            int selectedIndex = this.coordinateList.getSelectedIndex();
            int n = this.coordinateListModel.getSize();
            if (selectedIndex == -1 || selectedIndex == n - 1) {
                return;
            }
            this.swapCoordinates(selectedIndex, selectedIndex + 1);
            this.coordinateList.setSelectedIndex(selectedIndex + 1);
            this.repaint();
        });
        this.coordinateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                Coordinate selectedCoordinate = (Coordinate)MainSPOT.this.coordinateList.getSelectedValue();
                if (selectedCoordinate != null) {
                    MainSPOT.this.unselectAllCoordinates();
                    selectedCoordinate.setSelected(true);
                }
                MainSPOT.this.repaint();
            }
        });
        this.add((Component)this.coordinateListPanel, "East");
        this.add((Component)this.uiGuidePanel, "South");
        this.setupMenu();
        this.enableMouseUI();
        this.enableKeyboardUI();
        if (imagePath != null) {
            this.loadImage(new File(imagePath));
        } else {
            SwingUtilities.invokeLater(() -> this.openLoadImageFileSelector(true));
        }
    }

    private void addCoordinate(long index, int x, int y) {
        Image image = this.coordinateMarkerPanel.getImage();
        double imageWidth = image.getWidth(null);
        double imageHeight = image.getHeight(null);
        if (x < 0 || imageWidth < (double)x || y < 0 || imageHeight < (double)y) {
            return;
        }
        double ratioX = (double)x / imageWidth;
        double ratioY = (double)y / imageHeight;
        Coordinate coordinate = new Coordinate(index, x, y, ratioX, ratioY);
        this.coordinateListModel.addElement(coordinate);
    }

    private void swapCoordinates(int i, int j) {
        Coordinate c1 = this.coordinateListModel.get(i);
        Coordinate c2 = this.coordinateListModel.get(j);
        this.coordinateListModel.set(j, c1);
        this.coordinateListModel.set(i, c2);
        long tempIndex = c1.getIndex();
        c1.setIndex(c2.getIndex());
        c2.setIndex(tempIndex);
        this.repaint();
    }

    private void unselectAllCoordinates() {
        Enumeration<Coordinate> coordinates = this.coordinateListModel.elements();
        while (coordinates.hasMoreElements()) {
            coordinates.nextElement().setSelected(false);
        }
    }

    private String getIndexedCoordinatesAsString() {
        StringBuilder s = new StringBuilder();
        int n = this.coordinateListModel.getSize();
        int i = 0;
        while (i < n) {
            Coordinate coordinate = this.coordinateListModel.get(i);
            s.append(coordinate);
            s.append('\n');
            ++i;
        }
        return s.toString();
    }

    private void setupMenu() {
        this.swissMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.swissMenu);
        this.mapMenu.add(this.loadImageFileMenuItem);
        this.mapMenu.add(this.saveImageFileMenuItem);
        this.menuBar.add(this.mapMenu);
        this.setJMenuBar(this.menuBar);
        this.aboutMenuItem.addActionListener(event -> {
            this.aboutPanel.startAnimation();
            JOptionPane.showMessageDialog(this, this.aboutPanel, "About", -1, null);
            this.aboutPanel.stopAnimation();
            this.aboutPanel.setVisible(true);
        });
        this.loadImageFileMenuItem.addActionListener(event -> this.openLoadImageFileSelector(false));
        this.saveImageFileMenuItem.addActionListener(event -> {
            this.unselectAllCoordinates();
            this.coordinateList.clearSelection();
            this.openSaveImageFileSelector();
        });
    }

    private void openSaveImageFileSelector() {
        this.fileChooser.setDialogTitle("Saving the marked map image file");
        this.fileChooser.setSelectedFile(new File(String.valueOf(UtilDate.getDate_YYYY_MM_DD_hh_mm_ss()) + "_marked.png"));
        if (this.fileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File outputImageFile = this.fileChooser.getSelectedFile();
        Image mapImage = this.coordinateMarkerPanel.getImage();
        int width = mapImage.getWidth(null);
        int height = mapImage.getHeight(null);
        BufferedImage markedImage = new BufferedImage(width, height, 2);
        Graphics2D g = markedImage.createGraphics();
        this.coordinateMarkerPanel.paint(g, 0.0, 0.0, 1.0);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)markedImage, "png", outputImageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void openLoadImageFileSelector(boolean firstTime) {
        File imageFile;
        this.fileChooser.setDialogTitle("Opening a map image file");
        if (this.fileChooser.showOpenDialog(this) != 0) {
            if (firstTime) {
                this.dispose();
            } else {
                return;
            }
        }
        if ((imageFile = this.fileChooser.getSelectedFile()) != null && !this.loadImage(imageFile)) {
            String errorMessage = String.format("The image file could not be loaded: %s", imageFile.getName());
            UtilSwing.displayErrorMessage(this, errorMessage, new Object[0]);
            this.openLoadImageFileSelector(firstTime);
        }
    }

    private boolean loadImage(File imageFile) {
        try {
            if (imageFile == null) {
                return false;
            }
            BufferedImage image = ImageIO.read(imageFile);
            if (image == null) {
                return false;
            }
            this.coordinateMarkerPanel.setImage(image);
            this.coordinateListModel.removeAllElements();
            this.coordinateMarkerPanel.reset(1);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        finally {
            this.revalidate();
            this.repaint();
            this.requestFocusInWindow();
        }
    }

    private boolean indexTaken(long index) {
        int n = this.coordinateListModel.getSize();
        int i = 0;
        while (i < n) {
            Coordinate coordinate = this.coordinateListModel.get(i);
            if (coordinate.getIndex() == index) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void enableMouseUI() {
        this.coordinateMarkerPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MainSPOT.this.requestFocusInWindow();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                switch (e.getButton()) {
                    case 3: {
                        long index = Long.parseLong(MainSPOT.this.indexField.getText());
                        if (MainSPOT.this.indexTaken(index)) {
                            UtilSwing.displayErrorMessage(MainSPOT.this, "The index %s is already taken.", index);
                            return;
                        }
                        int x = (int)Math.round(MainSPOT.this.coordinateMarkerPanel.getTrueX(e.getX()));
                        int y = (int)Math.round(MainSPOT.this.coordinateMarkerPanel.getTrueY(e.getY()));
                        MainSPOT.this.addCoordinate(index, x, y);
                        MainSPOT.this.indexField.setText(String.format("%d", Long.parseLong(MainSPOT.this.indexField.getText()) + 1L));
                        MainSPOT.this.repaint();
                    }
                }
            }
        });
    }

    private void enableKeyboardUI() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 8: {
                        if (MainSPOT.this.coordinateListModel.isEmpty()) break;
                        MainSPOT.this.coordinateListModel.remove(MainSPOT.this.coordinateListModel.getSize() - 1);
                        break;
                    }
                    case 65: {
                        MainSPOT.this.applyAspectFit();
                        break;
                    }
                    case 79: {
                        MainSPOT.this.applyOriginalFit();
                    }
                }
                MainSPOT.this.repaint();
            }
        });
    }

    @Override
    public void applyAspectFit() {
        this.coordinateMarkerPanel.reset(1);
    }

    @Override
    public void applyOriginalFit() {
        this.coordinateMarkerPanel.reset(0);
    }

    @Override
    public void adjustZoomRelativeToCurrent(double factor) {
        this.coordinateMarkerPanel.adjustZoomRelativeToCurrent(factor);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            String imagePath = null;
            if (args.length >= 1) {
                imagePath = args[0];
            }
            MainSPOT main = new MainSPOT(imagePath);
            main.setVisible(true);
        });
    }
}

