/*
 * Decompiled with CFR 0.152.
 */
package AppSTAT;

import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class APLocatorPanel
extends ZoomableImagePanel {
    private static final long serialVersionUID = 1L;
    private boolean currentLocationAvailable;
    private double currentX;
    private double currentY;
    private double apX;
    private double apY;

    public APLocatorPanel() {
        this.setPreferredSize(new Dimension(800, 800));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                APLocatorPanel.this.apX = APLocatorPanel.this.getTrueX(event.getX());
                APLocatorPanel.this.apY = APLocatorPanel.this.getTrueY(event.getY());
                APLocatorPanel.this.repaint();
            }
        });
    }

    public void setAPLocation(double x, double y) {
        this.apX = x;
        this.apY = y;
        this.repaint();
    }

    public double getAPLocationX() {
        return this.apX;
    }

    public double getAPLocationY() {
        return this.apY;
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        this.apX = image.getWidth(null) / 2;
        this.apY = image.getHeight(null) / 2;
    }

    private void drawCrossHair(Graphics g, int x, int y, Color color) {
        int crossHairRadius = 5;
        int crossHairDiameter = crossHairRadius * 2 + 1;
        g.setColor(Color.WHITE);
        g.drawRect(x - crossHairRadius, y - 1, crossHairDiameter, 3);
        g.drawRect(x - 1, y - crossHairRadius, 3, crossHairDiameter);
        g.setColor(color);
        g.drawRect(x - --crossHairRadius, y, crossHairDiameter -= 2, 1);
        g.drawRect(x, y - crossHairRadius, 1, crossHairDiameter);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.currentLocationAvailable) {
            this.drawCrossHair(g, (int)Math.round(this.currentX), (int)Math.round(this.currentY), Color.GRAY);
        }
        this.drawCrossHair(g, (int)Math.round(this.apX), (int)Math.round(this.apY), Color.RED);
    }

    public void setCurrentLocation(double x, double y) {
        this.currentLocationAvailable = true;
        this.currentX = x;
        this.currentY = y;
    }

    public boolean setAPLocationToCurrentLocation() {
        if (this.currentLocationAvailable) {
            this.setAPLocation(this.currentX, this.currentY);
        }
        return this.currentLocationAvailable;
    }
}

