/*
 * Decompiled with CFR 0.152.
 */
package AppSTAT;

import AppSTAT.APLocatorMasterPanel;
import AppSTAT.APLocatorPanel;
import AppSTAT.STATNetwork;
import Config.HeatmapRenderConfig;
import Data.XY;
import GUIModule.AnimatedIcons.SatelliteIcon;
import GUIModule.AnimatedIcons.SpinningLEDIcon;
import GUIModule.AnimatedIcons.WiFiIcon;
import GUIModule.DynamicTable.DynamicTable;
import GUIModule.GUIFactory;
import GUIModule.UIGuideBar.UIGuideBarListener;
import GUIModule.UIGuideBar.UIGuideBarPanel;
import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import GUIModule.ZoomableImageModule.ZoomableImageUIObserver;
import Main.AboutPanel;
import Main.GlobalAnimationThread;
import Main.Main;
import Map.GraphCascadingPanel;
import Map.MapConfigChangeObserver;
import Map.MapConfigPanel;
import Map.MapScaleMasterPanel;
import Map.MapScalePanel;
import Map.Marker;
import Map.NodeState;
import Map.SatelliteMap;
import Map.SatelliteMapMasterPanel;
import Map.SatelliteMapPanel;
import Map.SpatialMeasurementNode;
import Map.WebMercator;
import Map.WebMercatorConverter;
import Sound.Sound;
import Util.UtilDate;
import Util.UtilSwing;
import Util.UtilTime;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class MainSTAT
extends JFrame
implements ZoomableImageUIObserver,
MapConfigChangeObserver,
UIGuideBarListener {
    private static final long serialVersionUID = 1L;
    private AboutPanel aboutPanel = new AboutPanel();
    private SatelliteMap map;
    private WebMercatorConverter mercatorConverter;
    private JPanel openPathPanel = new JPanel(new FlowLayout(1));
    private JLabel openPathLabel = new JLabel();
    private ZoomableImagePanel previewMapPanel = new ZoomableImagePanel();
    private Map<String, SatelliteMapMasterPanel> satelliteMapMasterPanels = new LinkedHashMap<String, SatelliteMapMasterPanel>();
    private JTabbedPane satelliteMapPane = new JTabbedPane();
    private GraphCascadingPanel graphCascadingPanel = new GraphCascadingPanel();
    private JPanel rightPanel = GUIFactory.makeCascadingPanel();
    private JScrollPane rightPane = new JScrollPane(this.rightPanel);
    private JPanel serverPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel serverTopPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JTextField serverIPField = GUIFactory.makeTextField(12);
    private JLabel serverColonLabel = GUIFactory.makeLabel(":");
    private JTextField serverPortField = GUIFactory.makeTextField(5);
    private JPanel serverCenterPanel = GUIFactory.makePanel(new FlowLayout(0));
    private WiFiIcon serverWiFiIcon = new WiFiIcon();
    private JButton serverConnectButton = GUIFactory.makeButton("Connect");
    private JButton serverInfoButton = GUIFactory.makeButton("Info");
    private JPanel positioningPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel positioningModePanel = GUIFactory.makePanel(new FlowLayout(0));
    private SatelliteIcon positioningGPSIcon = new SatelliteIcon();
    private JRadioButton positioningGPSModeButton = GUIFactory.makeRadioButton("GPS");
    private JRadioButton positioningManualModeButton = GUIFactory.makeRadioButton("Manual");
    private JPanel positioningSatellitesPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel positioningSatelliteCountPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JLabel positioningSatellitesInViewLabel = GUIFactory.makeLabel("In View:");
    private JTextField positioningSatellitesInViewField = GUIFactory.makeTextField(2);
    private JLabel positioningSatellitesFixedLabel = GUIFactory.makeLabel("Fixed:");
    private JTextField positioningSatellitesFixedField = GUIFactory.makeTextField(2);
    private JPanel loggingPanel = GUIFactory.makePanel(new FlowLayout(0));
    private SpinningLEDIcon loggingIcon = new SpinningLEDIcon();
    private JRadioButton loggingOnButton = GUIFactory.makeRadioButton("On");
    private JRadioButton loggingOffButton = GUIFactory.makeRadioButton("Off");
    private JPanel locationPanel = GUIFactory.makeCascadingPanel();
    private JPanel locationMapScalePanel = GUIFactory.makeCascadingPanel();
    private JPanel locationMapScaleLabelPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JLabel locationMapScaleLabel = GUIFactory.makeBorderLabel("Map Scale:");
    private JButton locationMapScaleSetButton = GUIFactory.makeButton("Set");
    private JPanel locationMapScaleFieldPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationMapScaleField = GUIFactory.makeTextField(16);
    private JPanel locationMapScaleUnitLabelPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JLabel locationMapScaleUnitLabel = GUIFactory.makeLabel("Meters per Pixel");
    private JPanel locationGPSMapPanel = GUIFactory.makeCascadingPanel();
    private JPanel locationMapTopLabelPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JLabel locationMapTopLabel = GUIFactory.makeBorderLabel("Map GPS Coordinates:");
    private JPanel locationTopLeftLatLonPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationTopLeftLatLonField = GUIFactory.makeTextField(16);
    private JPanel locationBottomRightPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel locationBottomRightLatLonPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationBottomRightLatLonField = GUIFactory.makeTextField(16);
    private JPanel locationMapBottomLabelPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JLabel locationMapBottomLabel = GUIFactory.makeLabel("Top-Left/Bottom-Right");
    private JPanel locationAPPanel = GUIFactory.makeCascadingPanel();
    private JPanel locationAPLabelPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JLabel locationAPLabel = GUIFactory.makeBorderLabel("AP:");
    private JButton locationAPSetButton = GUIFactory.makeButton("Set");
    private JButton locationAPClearButton = GUIFactory.makeButton("Clear");
    private JPanel locationAPPixelPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationAPPixelField = GUIFactory.makeTextField(8);
    private JLabel locationAPPixelLabel = GUIFactory.makeLabel("pixels");
    private JPanel locationAPLatLonPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationAPLatLonField = GUIFactory.makeTextField(16);
    private JPanel locationCurrentPanel = GUIFactory.makeCascadingPanel();
    private JPanel locationCurrentLabelPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JLabel locationCurrentLabel = GUIFactory.makeBorderLabel("GPS Current:");
    private JPanel locationCurrentLatLonPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationCurrentLatLonField = GUIFactory.makeTextField(16);
    private JPanel locationCurrentDistancePanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationCurrentDistanceField = GUIFactory.makeTextField(5);
    private JLabel locationCurrentDistanceLabel = GUIFactory.makeLabel("meters");
    private JCheckBox locationCurrentFollowCheckBox = GUIFactory.makeCheckBox("Follow");
    private JPanel tablePanel = GUIFactory.makePanel(new BorderLayout());
    DynamicTable<SpatialMeasurementNode> table = new DynamicTable();
    private JScrollPane tablePane = new JScrollPane(this.table);
    private JPanel controlPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JButton showHideGraphButton = GUIFactory.makeButton("Hide Graphs");
    private JButton showHideTableButton = GUIFactory.makeButton("Hide Table");
    private JButton showHideControlButton = GUIFactory.makeButton("Hide Control");
    private JButton removeSelectedRowsButton = GUIFactory.makeButton("Remove Selected Rows");
    private JButton clearAllRowsButton = GUIFactory.makeButton("Clear All Rows");
    private JCheckBox autoScrollCheckBox = GUIFactory.makeCheckBox("Auto-Scroll");
    private JCheckBox beepSoundCheckBox = GUIFactory.makeCheckBox("Beep Sound");
    private JPanel bottomPanel = GUIFactory.makePanel(new BorderLayout());
    private UIGuideBarPanel uiGuidePanel = new UIGuideBarPanel().addAspectFit(this).addOriginalFit(this).addZoomIn(this).addZoomOut(this).addMove().addMeasure();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu swissMenu = new JMenu("SWiSS");
    private JMenuItem aboutMenuItem = new JMenuItem("About");
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem saveResultsMenuItem = new JMenuItem("Save Results");
    private Map<String, Long> lastDataTimeMap = new HashMap<String, Long>();
    private boolean connected = false;
    private Thread connectionThread;
    private APLocatorMasterPanel apLocatorMasterPanel = new APLocatorMasterPanel();
    private NodeState apState = new NodeState("AP");
    private NodeState staState = new NodeState("STA");
    private MapScaleMasterPanel mapScaleMasterPanel = new MapScaleMasterPanel();
    private boolean mapScaleAvailable = false;
    private double distancePerPixel;
    private int[] referenceScaleXs = new int[2];
    private int[] referenceScaleYs = new int[2];
    private Sound soundBeep = new Sound("beep.wav");
    private Sound soundDoubleBeep = new Sound("double_beep.wav");
    private static final int DATA_FETCH_PERIOD_MS = 200;
    private XY clickedMapPosition = null;

    public MainSTAT() {
        this.soundBeep.open();
        this.soundDoubleBeep.open();
        this.setIconImage(Main.swissImageIcon);
        this.setTitle("Newracom Spatial Test Automation Tool (STAT) v1.0");
        this.setDefaultCloseOperation(0);
        Dimension fullSize = new Window(null).getGraphicsConfiguration().getBounds().getSize();
        this.setSize(fullSize);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.previewMapPanel.addObserver(this);
        this.previewMapPanel.setBackground(Color.BLACK);
        this.serverIPField.setText("172.16.73.94");
        this.serverPortField.setText("12345");
        UtilSwing.setEditable(false, this.positioningSatellitesInViewField, this.positioningSatellitesFixedField, this.locationTopLeftLatLonField, this.locationBottomRightLatLonField, this.locationCurrentLatLonField, this.locationCurrentDistanceField, this.locationAPPixelField, this.locationAPLatLonField);
        this.openPathPanel.add(this.openPathLabel);
        this.add((Component)this.openPathPanel, "North");
        this.add((Component)this.previewMapPanel, "Center");
        this.add((Component)this.graphCascadingPanel, "West");
        UtilSwing.groupRadioButtons(this.positioningGPSModeButton, this.positioningManualModeButton);
        this.positioningManualModeButton.setSelected(true);
        UtilSwing.groupRadioButtons(this.loggingOnButton, this.loggingOffButton);
        this.loggingOffButton.setSelected(true);
        this.serverPanel.add((Component)UtilSwing.add(this.serverTopPanel, this.serverIPField, this.serverColonLabel, this.serverPortField), "North");
        this.serverPanel.add((Component)UtilSwing.add(this.serverCenterPanel, this.serverWiFiIcon, this.serverConnectButton, this.serverInfoButton), "Center");
        this.positioningSatellitesPanel.add((Component)UtilSwing.add(this.positioningSatelliteCountPanel, this.positioningSatellitesInViewLabel, this.positioningSatellitesInViewField, this.positioningSatellitesFixedLabel, this.positioningSatellitesFixedField), "Center");
        this.positioningPanel.add((Component)UtilSwing.add(this.positioningModePanel, this.positioningGPSIcon, this.positioningGPSModeButton, this.positioningManualModeButton), "North");
        this.positioningPanel.add((Component)this.positioningSatellitesPanel, "Center");
        UtilSwing.add(this.locationMapScalePanel, UtilSwing.add(this.locationMapScaleLabelPanel, this.locationMapScaleLabel, this.locationMapScaleSetButton), UtilSwing.add(this.locationMapScaleFieldPanel, this.locationMapScaleField), UtilSwing.add(this.locationMapScaleUnitLabelPanel, this.locationMapScaleUnitLabel));
        UtilSwing.add(this.locationGPSMapPanel, UtilSwing.add(this.locationMapTopLabelPanel, this.locationMapTopLabel), UtilSwing.add(this.locationTopLeftLatLonPanel, this.locationTopLeftLatLonField), UtilSwing.add(this.locationBottomRightLatLonPanel, this.locationBottomRightLatLonField), UtilSwing.add(this.locationMapBottomLabelPanel, this.locationMapBottomLabel));
        UtilSwing.add(this.locationAPPanel, UtilSwing.add(this.locationAPLabelPanel, this.locationAPLabel, this.locationAPSetButton, this.locationAPClearButton), UtilSwing.add(this.locationAPPixelPanel, this.locationAPPixelField, this.locationAPPixelLabel), UtilSwing.add(this.locationAPLatLonPanel, this.locationAPLatLonField));
        UtilSwing.add(this.locationCurrentPanel, UtilSwing.add(this.locationCurrentLabelPanel, this.locationCurrentLabel, this.locationCurrentFollowCheckBox), UtilSwing.add(this.locationCurrentLatLonPanel, this.locationCurrentLatLonField), UtilSwing.add(this.locationCurrentDistancePanel, this.locationCurrentDistanceField, this.locationCurrentDistanceLabel));
        this.rightPanel.add(this.positioningPanel);
        this.rightPanel.add(this.serverPanel);
        this.rightPanel.add(UtilSwing.add(this.loggingPanel, this.loggingIcon, this.loggingOnButton, this.loggingOffButton));
        this.rightPanel.add(UtilSwing.add(this.locationPanel, this.locationCurrentPanel, this.locationAPPanel, this.locationMapScalePanel, this.locationGPSMapPanel));
        this.add((Component)this.rightPane, "East");
        this.tablePane.setPreferredSize(new Dimension(200, 200));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addColumns("TIMESTAMP", "PIXEL(X)", "PIXEL(Y)", "RATIO(X)", "RATIO(Y)", "LATITUDE[deg]", "LONGITUDE[deg]", "DISTANCE[m]");
        this.table.setDefaultRenderer(Object.class, new ColoredTableCellRenderer());
        this.tablePane.getViewport().setBackground(Color.BLACK);
        this.tablePanel.add((Component)this.tablePane, "Center");
        this.bottomPanel.add(this.tablePanel);
        UtilSwing.add(this.controlPanel, this.showHideControlButton, this.showHideGraphButton, this.showHideTableButton, this.removeSelectedRowsButton, this.clearAllRowsButton, this.autoScrollCheckBox, this.beepSoundCheckBox);
        this.tablePanel.add((Component)this.controlPanel, "South");
        this.bottomPanel.add((Component)this.uiGuidePanel, "South");
        this.add((Component)this.bottomPanel, "South");
        this.autoScrollCheckBox.setSelected(true);
        this.beepSoundCheckBox.setSelected(false);
        this.positioningSatellitesPanel.setVisible(false);
        this.locationPanel.setVisible(false);
        this.locationCurrentPanel.setVisible(false);
        this.locationMapScalePanel.setVisible(false);
        this.locationGPSMapPanel.setVisible(false);
        Marker apMarker = this.apState.getMarker();
        apMarker.setColor(Color.RED);
        apMarker.setLocationUnsure(false);
        GlobalAnimationThread.add(this.serverWiFiIcon);
        GlobalAnimationThread.add(this.positioningGPSIcon);
        GlobalAnimationThread.add(this.loggingIcon);
        UtilSwing.setBorder(this.serverPanel, "STA Server Connection");
        UtilSwing.setBorder(this.positioningPanel, "Positioning");
        UtilSwing.setBorder(this.loggingPanel, "Continuous Logging");
        UtilSwing.setBorder(this.locationPanel, "Location");
        this.locationMapScalePanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationGPSMapPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationBottomRightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationAPPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationCurrentPanel.setBorder(BorderFactory.createEtchedBorder());
        UtilSwing.fixPreferredHeight(this.serverPanel);
        UtilSwing.fixPreferredHeight(this.positioningPanel);
        UtilSwing.fixPreferredHeight(this.loggingPanel);
        UtilSwing.fixPreferredHeight(this.locationPanel);
        this.setupMenu();
        this.enableKeyboardMouseUI();
        this.setupButtonUI();
        this.resetControl();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                String message = "Are you sure you want to close the program?";
                String title = "Closing the program";
                int option = JOptionPane.showConfirmDialog(MainSTAT.this, message, title, 2, -1, null);
                if (option == 0) {
                    MainSTAT.this.disconnect();
                    MainSTAT.this.dispose();
                    System.exit(0);
                }
            }
        });
        SwingUtilities.invokeLater(() -> {
            this.openMapImageFileSelector();
            if (this.map == null) {
                this.dispose();
                System.exit(0);
            }
        });
    }

    private String getTableAsCSVs() {
        StringBuffer s = new StringBuffer();
        s.append("TIMESTAMP,PIXEL(X),PIXEL(Y),RATIO(X),RATIO(Y),LATITUDE[deg],LONGITUDE[deg],DISTANCE[m]");
        for (String key : this.satelliteMapMasterPanels.keySet()) {
            s.append("," + key);
        }
        s.append('\n');
        for (SpatialMeasurementNode node : this.table) {
            s.append(node.asSingleLineCombinedCSV());
            s.append('\n');
        }
        return s.toString();
    }

    private void setupMenu() {
        this.swissMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.swissMenu);
        this.fileMenu.add(this.saveResultsMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.aboutMenuItem.addActionListener(event -> {
            this.aboutPanel.startAnimation();
            JOptionPane.showMessageDialog(this, this.aboutPanel, "About", -1, null);
            this.aboutPanel.stopAnimation();
        });
        this.saveResultsMenuItem.addActionListener(event -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(new File("~"));
            fileChooser.setDialogTitle("Select the output directory");
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showSaveDialog(this) != 0) {
                return;
            }
            String timestamp = UtilDate.getDate_YYYY_MM_DD_hh_mm_ss();
            String logDirectoryName = String.valueOf(timestamp) + "_swiss_stat_logs";
            File directory = new File(String.valueOf(fileChooser.getSelectedFile().getAbsolutePath()) + "/" + logDirectoryName);
            try {
                if (!Files.exists(directory.toPath(), new LinkOption[0])) {
                    Files.createDirectories(directory.toPath(), new FileAttribute[0]);
                }
                String directoryPath = directory.getAbsolutePath();
                String csvFileName = String.valueOf(timestamp) + "_raw.csv";
                String configFileName = String.valueOf(timestamp) + "_config.json";
                String imageFileName = String.valueOf(timestamp) + "_" + this.map.getImageFile().getName();
                System.out.println(imageFileName);
                File csvFile = new File(String.valueOf(directoryPath) + "/" + csvFileName);
                Files.write(csvFile.toPath(), this.getTableAsCSVs().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                JsonObject config = new JsonObject();
                JsonObject appConfig = new JsonObject();
                appConfig.addProperty("name", "STAT");
                appConfig.addProperty("version", "v1.0");
                config.add("app", appConfig);
                JsonObject pathConfig = new JsonObject();
                pathConfig.addProperty("csv", "./" + csvFileName);
                pathConfig.addProperty("image", "./" + imageFileName);
                config.add("path", pathConfig);
                Marker apMarker = this.apState.getMarker();
                if (apMarker.isEnabled()) {
                    JsonObject apConfig = new JsonObject();
                    int apX = apMarker.getPixelX();
                    int apY = apMarker.getPixelY();
                    double apLatitude = this.mercatorConverter.getPhi(apY);
                    double apLongitude = this.mercatorConverter.getPsi(apX);
                    apConfig.addProperty("pixelX", apX);
                    apConfig.addProperty("pixelY", apY);
                    double ratioX = (double)apX / (double)this.map.getImage().getWidth(null);
                    double ratioY = (double)apY / (double)this.map.getImage().getHeight(null);
                    apConfig.addProperty("ratioX", ratioX);
                    apConfig.addProperty("ratioY", ratioY);
                    if (this.map.gpsCoordinateAvailable()) {
                        apConfig.addProperty("latitude", apLatitude);
                        apConfig.addProperty("longitude", apLongitude);
                    }
                    config.add("ap", apConfig);
                }
                JsonObject plotSetConfig = new JsonObject();
                for (String key : this.satelliteMapMasterPanels.keySet()) {
                    HeatmapRenderConfig renderConfig = this.satelliteMapMasterPanels.get(key).getConfigPanel().get();
                    JsonObject plotConfig = new JsonObject();
                    plotConfig.addProperty("decimal", renderConfig.getDecimal());
                    plotConfig.addProperty("data_min", renderConfig.getDataMin());
                    plotConfig.addProperty("data_max", renderConfig.getDataMax());
                    plotConfig.addProperty("data_scale", renderConfig.getDataScale());
                    plotConfig.addProperty("plot_value", renderConfig.getValuePlotEnabled());
                    plotSetConfig.add(key, plotConfig);
                }
                config.add("plot", plotSetConfig);
                String configText = new GsonBuilder().setPrettyPrinting().create().toJson(config);
                File configFile = new File(String.valueOf(directoryPath) + "/" + configFileName);
                Files.write(configFile.toPath(), configText.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                File imageFile = new File(String.valueOf(directoryPath) + "/" + imageFileName);
                ImageIO.write((RenderedImage)this.map.getImage(), this.map.getImageFileExtension(), imageFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void resetControl() {
        boolean connected = this.isConnected();
        boolean isGPSMode = this.positioningGPSModeButton.isSelected();
        boolean measuringInGPSMode = connected && isGPSMode && this.loggingOnButton.isSelected();
        boolean mapGPSCoordinateAvailable = this.map != null && this.map.gpsCoordinateAvailable();
        this.serverConnectButton.setText(connected ? "Disconnect" : "Connect");
        this.serverInfoButton.setEnabled(connected);
        UtilSwing.setEnabled(!connected, this.serverIPField, this.serverPortField, this.positioningManualModeButton);
        this.positioningGPSModeButton.setEnabled(mapGPSCoordinateAvailable && !connected);
        UtilSwing.setEnabled(connected && isGPSMode, this.loggingOnButton, this.loggingOffButton);
        this.positioningGPSIcon.setAvailable(isGPSMode);
        this.positioningGPSIcon.setOnOff(connected && isGPSMode);
        this.loggingIcon.setOnOff(measuringInGPSMode);
        if (!isGPSMode) {
            this.locationCurrentFollowCheckBox.setSelected(false);
        }
    }

    private void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connectionThread.interrupt();
        this.connectionThread = null;
        this.setConnected(false);
        this.loggingOffButton.setSelected(true);
        this.resetControl();
        this.repaint();
    }

    private void setupButtonUI() {
        this.serverConnectButton.addActionListener(event -> {
            this.clearFields();
            if (this.connected) {
                this.disconnect();
            } else {
                String ip = this.serverIPField.getText().trim();
                int port = Integer.parseInt(this.serverPortField.getText().trim());
                String headLine = STATNetwork.query("HEAD", ip, port);
                System.out.println(headLine);
                if (headLine == null) {
                    UtilSwing.displayErrorMessage(this, "Could not connect to %s:%d.", ip, port);
                    return;
                }
                try {
                    JsonObject head = JsonParser.parseString(headLine).getAsJsonObject();
                    JsonObject measurements = head.getAsJsonObject("measurements");
                    for (String measurementName : measurements.keySet()) {
                        SatelliteMapMasterPanel satelliteMapMasterPanel;
                        this.graphCascadingPanel.addGraphMasterPanel(measurementName);
                        JsonObject headValue = measurements.get(measurementName).getAsJsonObject();
                        if (!this.satelliteMapMasterPanels.containsKey(measurementName)) {
                            this.table.addColumn(measurementName);
                            satelliteMapMasterPanel = new SatelliteMapMasterPanel(this.graphCascadingPanel, this.map, this.table, measurementName);
                            SatelliteMapPanel satelliteMapPanel = satelliteMapMasterPanel.getSatelliteMapPanel();
                            satelliteMapPanel.setAPMarker(this.apState.getMarker());
                            satelliteMapPanel.addSTAMarker(this.staState.getMarker());
                            this.addSatelliteMapMasterPanel(measurementName, satelliteMapMasterPanel);
                            this.lastDataTimeMap.put(measurementName, -1L);
                        }
                        satelliteMapMasterPanel = this.satelliteMapMasterPanels.get(measurementName);
                        MapConfigPanel configPanel = satelliteMapMasterPanel.getConfigPanel();
                        HeatmapRenderConfig config = new HeatmapRenderConfig();
                        config.setDataMin(headValue.get("data_min") == null ? 0.0 : headValue.get("data_min").getAsDouble());
                        config.setDataMax(headValue.get("data_max") == null ? 100.0 : headValue.get("data_max").getAsDouble());
                        config.setDataScale(headValue.get("data_scale") == null ? 1.0 : headValue.get("data_scale").getAsDouble());
                        config.setDecimal(headValue.get("decimal") == null ? 1 : headValue.get("decimal").getAsInt());
                        config.setValuePlotEnabled(true);
                        configPanel.set(config);
                        this.graphCascadingPanel.setGraphConfig(measurementName, config);
                    }
                }
                catch (Exception e) {
                    UtilSwing.displayErrorMessage(this, "Malformed JSON: %s", headLine);
                    return;
                }
                if (this.previewMapPanel != null) {
                    this.remove(this.previewMapPanel);
                    this.previewMapPanel = null;
                }
                this.add((Component)this.satelliteMapPane, "Center");
                this.revalidate();
                this.repaint();
                this.connectionThread = new Thread(() -> {
                    if (this.positioningGPSModeButton.isSelected()) {
                        this.startUpdatingDataOnThreadGPSMode(ip, port);
                    } else if (this.positioningManualModeButton.isSelected()) {
                        this.startUpdatingDataOnThreadManualMode(ip, port);
                    }
                });
                this.connectionThread.start();
                this.setConnected(true);
                this.resetControl();
            }
        });
        this.serverInfoButton.addActionListener(event -> {
            String ip = this.serverIPField.getText().trim();
            int port = Integer.parseInt(this.serverPortField.getText().trim());
            String infoLine = STATNetwork.query("STATUS", ip, port);
            JsonObject info = JsonParser.parseString(infoLine).getAsJsonObject();
            JTabbedPane infoPane = new JTabbedPane();
            for (String key : info.keySet()) {
                JTextArea textArea = new JTextArea();
                textArea.setFont(new Font("Monospaced", 0, 12));
                textArea.setEditable(false);
                textArea.setText(info.get(key).getAsString());
                infoPane.add(key, textArea);
            }
            JOptionPane.showMessageDialog(this, infoPane, "Info", -1, null);
        });
        this.loggingOnButton.addActionListener(event -> this.resetControl());
        this.loggingOffButton.addActionListener(event -> this.resetControl());
        this.positioningGPSModeButton.addActionListener(event -> this.resetControl());
        this.positioningManualModeButton.addActionListener(event -> this.resetControl());
        this.removeSelectedRowsButton.addActionListener(event -> this.table.removeSelectedIndices());
        this.clearAllRowsButton.addActionListener(event -> {
            String message = "Are you sure you want to clear all the rows?";
            String title = "Warning";
            int option = JOptionPane.showConfirmDialog(this, message, title, 2, -1, null);
            if (option != 0) {
                return;
            }
            this.clearCoordinates();
        });
        this.showHideControlButton.addActionListener(event -> {
            this.rightPane.setVisible(!this.rightPane.isVisible());
            this.showHideControlButton.setText(this.rightPane.isVisible() ? "Hide Control" : "Show Control");
            this.revalidate();
            this.repaint();
        });
        this.showHideGraphButton.addActionListener(event -> {
            this.graphCascadingPanel.setVisible(!this.graphCascadingPanel.isVisible());
            this.showHideGraphButton.setText(this.graphCascadingPanel.isVisible() ? "Hide Graphs" : "Show Graphs");
            this.revalidate();
            this.repaint();
        });
        this.showHideTableButton.addActionListener(event -> {
            this.tablePane.setVisible(!this.tablePane.isVisible());
            UtilSwing.setEnabled(this.tablePane.isVisible(), this.removeSelectedRowsButton, this.clearAllRowsButton, this.autoScrollCheckBox);
            this.showHideTableButton.setText(this.tablePane.isVisible() ? "Hide Table" : "Show Table");
            this.table.clearSelection();
            this.revalidate();
            this.repaint();
        });
        this.locationAPSetButton.addActionListener(event -> {
            int option;
            APLocatorPanel apLocatorPanel = this.apLocatorMasterPanel.getAPLocatorPanel();
            String title = "Setting AP (Access Point) Location";
            String currentLocation = this.locationCurrentLatLonField.getText().trim();
            if (!currentLocation.isEmpty()) {
                String[] fields = currentLocation.split(",");
                double latitude = Double.parseDouble(fields[0]);
                double longitude = Double.parseDouble(fields[1]);
                double mapRatioX = this.mercatorConverter.getRatioX(longitude);
                double mapRatioY = this.mercatorConverter.getRatioY(latitude);
                int mapPixelX = (int)((double)this.map.getImage().getWidth() * mapRatioX);
                int mapPixelY = (int)((double)this.map.getImage().getHeight() * mapRatioY);
                apLocatorPanel.setCurrentLocation(mapPixelX, mapPixelY);
            }
            if ((option = JOptionPane.showConfirmDialog(this, this.apLocatorMasterPanel, title, 2, -1, null)) != 0) {
                return;
            }
            Marker apMarker = this.apState.getMarker();
            apMarker.setEnabled(true);
            int apX = (int)Math.round(apLocatorPanel.getAPLocationX());
            int apY = (int)Math.round(apLocatorPanel.getAPLocationY());
            apMarker.setPixelPosition(apX, apY);
            this.locationAPPixelField.setText(String.format("%d,%d", apX, apY));
            if (this.map.gpsCoordinateAvailable()) {
                double apXRatio = (double)apX / (double)this.map.getImage().getWidth();
                double apYRatio = (double)apY / (double)this.map.getImage().getHeight();
                double psi = this.mercatorConverter.getPsi(apXRatio);
                double phi = this.mercatorConverter.getPhi(apYRatio);
                this.locationAPLatLonField.setText(String.format("%.6f,%.6f", phi, psi));
            }
            this.repaint();
        });
        this.locationMapScaleSetButton.addActionListener(event -> {
            int option;
            String title = "Setting Map Scale";
            MapScalePanel mapScalePanel = this.mapScaleMasterPanel.getMapScalePanel();
            if (this.mapScaleAvailable) {
                mapScalePanel.setReferenceLocations(this.referenceScaleXs[0], this.referenceScaleYs[0], this.referenceScaleXs[1], this.referenceScaleYs[1]);
            }
            if ((option = JOptionPane.showConfirmDialog(this, this.mapScaleMasterPanel, title, 2, -1, null)) != 0) {
                return;
            }
            if (!this.mapScaleMasterPanel.distanceInMetersInputValid() || !this.mapScaleMasterPanel.distanceInPixelsInputValid()) {
                this.displayInvalidInputMessage();
                return;
            }
            this.mapScaleAvailable = true;
            this.referenceScaleXs[0] = mapScalePanel.getReferenceX0();
            this.referenceScaleYs[0] = mapScalePanel.getReferenceY0();
            this.referenceScaleXs[1] = mapScalePanel.getReferenceX1();
            this.referenceScaleYs[1] = mapScalePanel.getReferenceY1();
            this.distancePerPixel = this.mapScaleMasterPanel.getDistanceInMeters() / this.mapScaleMasterPanel.getDistanceInPixels();
            this.locationMapScaleField.setText(String.format("%s", this.distancePerPixel));
            this.repaint();
        });
        this.locationAPClearButton.addActionListener(event -> {
            this.apState.getMarker().setEnabled(false);
            this.locationAPPixelField.setText("");
            this.locationAPLatLonField.setText("");
            this.repaint();
        });
        this.table.getSelectionModel().addListSelectionListener(event -> {
            for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
                SatelliteMapPanel satelliteMapPanel = satelliteMapMasterPanel.getSatelliteMapPanel();
                satelliteMapPanel.repaint();
            }
        });
    }

    private void displayInvalidInputMessage() {
        JOptionPane.showMessageDialog(this, "Invalid Input", "Error", -1, null);
    }

    private void clearFields() {
        this.positioningSatellitesInViewField.setText("");
        this.positioningSatellitesFixedField.setText("");
        this.locationCurrentLatLonField.setText("");
        this.locationCurrentDistanceField.setText("");
    }

    private void clearCoordinates() {
        this.table.clear();
        this.repaint();
    }

    private synchronized void setConnected(boolean value) {
        this.connected = value;
        this.serverWiFiIcon.setOnOff(value);
        this.positioningGPSIcon.setOnOff(value);
    }

    private synchronized void setConnectionStable(boolean value) {
        this.serverWiFiIcon.setConnectionStable(value);
    }

    private synchronized boolean isConnected() {
        return this.connected;
    }

    private void startUpdatingDataOnThreadGPSMode(String ip, int port) {
        while (this.isConnected()) {
            try {
                Thread.sleep(200L);
                String getLine = STATNetwork.query("GET", ip, port);
                JsonObject values = JsonParser.parseString(getLine).getAsJsonObject();
                System.out.println(getLine);
                SwingUtilities.invokeLater(() -> {
                    this.setConnectionStable(true);
                    boolean measurementLoggingEnabled = this.loggingOnButton.isSelected();
                    boolean gpsAvailable = false;
                    boolean measurementAvailable = false;
                    if (!values.has("gps")) {
                        System.out.println("[MESSAGE] GPS not enabled on the server.");
                        return;
                    }
                    JsonObject gps = values.get("gps").getAsJsonObject();
                    System.out.println(gps);
                    boolean gpsCoordinateUpdated = this.staState.updateGPS(gps);
                    boolean gpsValid = this.staState.getGPSValid();
                    int satInView = this.staState.getSatInView();
                    int satFixed = this.staState.getSatFixed();
                    String satInViewText = satInView == -1 ? "N/A" : String.format("%d", satInView);
                    this.positioningSatellitesInViewField.setText(satInViewText);
                    String satFixedText = satFixed == -1 ? "N/A" : String.format("%d", satFixed);
                    this.positioningSatellitesFixedField.setText(satFixedText);
                    if (!gpsValid) {
                        System.out.println("[MESSAGE] GPS not locked yet.");
                        return;
                    }
                    long gpsTime = this.staState.getGPSTime();
                    double latitude = this.staState.getGPSLatitude();
                    double longitude = this.staState.getGPSLongitude();
                    double mapRatioX = this.mercatorConverter.getRatioX(longitude);
                    double mapRatioY = this.mercatorConverter.getRatioY(latitude);
                    int mapPixelX = (int)((double)this.map.getImage().getWidth() * mapRatioX);
                    int mapPixelY = (int)((double)this.map.getImage().getHeight() * mapRatioY);
                    String gpsLine = String.format("%s,%s,%s,%s,%s,%s,%s", gpsTime, mapPixelX, mapPixelY, mapRatioX, mapRatioY, latitude, longitude);
                    System.out.println(gpsLine);
                    Marker staMarker = this.staState.getMarker();
                    if (gpsCoordinateUpdated) {
                        gpsAvailable = true;
                        this.loggingIcon.flash();
                        boolean followGPS = this.locationCurrentFollowCheckBox.isSelected();
                        this.locationCurrentLatLonField.setText(String.format("%.6f,%.6f", latitude, longitude));
                        for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
                            SatelliteMapPanel satelliteMapPanel = satelliteMapMasterPanel.getSatelliteMapPanel();
                            staMarker.setEnabled(true);
                            staMarker.setPixelPosition(mapPixelX, mapPixelY);
                            if (!followGPS) continue;
                            satelliteMapPanel.centerAt(mapPixelX, mapPixelY);
                        }
                    }
                    if (gpsCoordinateUpdated) {
                        staMarker.setLocationUnsure(false);
                    } else if (UtilTime.inMilliseconds() - this.staState.getGPSTime() > 5000L) {
                        staMarker.setLocationUnsure(true);
                    }
                    SpatialMeasurementNode node = new SpatialMeasurementNode(gpsTime, mapPixelX, mapPixelY, mapRatioX, mapRatioY, latitude, longitude);
                    Marker apMarker = this.apState.getMarker();
                    if (apMarker.isEnabled()) {
                        int apX = apMarker.getPixelX();
                        int apY = apMarker.getPixelY();
                        double apXRatio = (double)apX / (double)this.map.getImage().getWidth();
                        double apYRatio = (double)apY / (double)this.map.getImage().getHeight();
                        double apLatitude = this.mercatorConverter.getPhi(apYRatio);
                        double apLongitude = this.mercatorConverter.getPsi(apXRatio);
                        int distance = (int)Math.round(WebMercator.distanceInMeter(latitude, longitude, apLatitude, apLongitude));
                        node.setDistance(distance);
                        this.locationCurrentDistanceField.setText(String.format("%d", distance));
                    }
                    for (String measKey : this.satelliteMapMasterPanels.keySet()) {
                        node.add(measKey, null);
                    }
                    boolean degenerateNode = true;
                    JsonObject measurements = values.get("measurements").getAsJsonObject();
                    for (String measKey : measurements.keySet()) {
                        if (!this.lastDataTimeMap.containsKey(measKey)) continue;
                        JsonObject value = measurements.get(measKey).getAsJsonObject();
                        int measIndex = value.get("index").getAsInt();
                        long measTime = value.get("time").getAsLong();
                        JsonElement measPreValue = value.get("value");
                        if (measPreValue.isJsonNull()) continue;
                        double measValue = measPreValue.getAsDouble();
                        String measLine = String.format("%s,%s,%s,%s,%s", gpsTime, measKey, measValue, measIndex, measTime);
                        System.out.println(measLine);
                        if (!gpsCoordinateUpdated || measTime == this.lastDataTimeMap.get(measKey)) continue;
                        this.lastDataTimeMap.put(measKey, measTime);
                        this.graphCascadingPanel.addData(measKey, measValue);
                        node.add(measKey, measValue);
                        degenerateNode = false;
                        measurementAvailable = true;
                    }
                    if (measurementLoggingEnabled && !degenerateNode) {
                        this.table.addRow(node);
                        if (this.autoScrollCheckBox.isSelected()) {
                            this.table.scrollToBottom();
                        }
                    }
                    for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
                        SatelliteMapPanel satelliteMapPanel = satelliteMapMasterPanel.getSatelliteMapPanel();
                        satelliteMapPanel.repaint();
                    }
                    if (this.beepSoundCheckBox.isSelected()) {
                        if (gpsAvailable && measurementAvailable) {
                            this.soundDoubleBeep.play();
                        } else if (gpsAvailable) {
                            this.soundBeep.play();
                        }
                    }
                });
            }
            catch (Exception e) {
                this.setConnectionStable(false);
                e.printStackTrace();
            }
        }
        System.out.println("[CONNECTION THREAD EXIT]");
    }

    private void startUpdatingDataOnThreadManualMode(String ip, int port) {
        while (this.isConnected()) {
            try {
                Thread.sleep(200L);
                String getLine = STATNetwork.query("GET", ip, port);
                JsonObject values = JsonParser.parseString(getLine).getAsJsonObject();
                SwingUtilities.invokeLater(() -> {
                    boolean addLog;
                    boolean measurementAvailable = false;
                    this.setConnectionStable(true);
                    XY position = this.getClickedMapPosition();
                    long time = UtilTime.inMilliseconds();
                    int clickPixelX = 0;
                    int clickPixelY = 0;
                    double clickRatioX = 0.0;
                    double clickRatioY = 0.0;
                    if (position != null) {
                        clickPixelX = (int)position.getX();
                        clickPixelY = (int)position.getY();
                        clickRatioX = (double)clickPixelX / (double)this.map.getImage().getWidth();
                        clickRatioY = (double)clickPixelY / (double)this.map.getImage().getHeight();
                    }
                    JsonObject measurements = values.get("measurements").getAsJsonObject();
                    StringBuffer message = new StringBuffer();
                    for (String measKey : measurements.keySet()) {
                        JsonObject measData = measurements.getAsJsonObject(measKey);
                        double value = measData.get("value").getAsDouble();
                        int index = measData.get("index").getAsInt();
                        int decimal = this.satelliteMapMasterPanels.get(measKey).getConfigPanel().get().getDecimal();
                        String line = String.format("%s: (#%d)\n%." + decimal + "f\n\n", measKey, index, value);
                        message.append(line);
                    }
                    SpatialMeasurementNode node = new SpatialMeasurementNode(time, clickPixelX, clickPixelY, clickRatioX, clickRatioY);
                    if (position != null) {
                        int distance;
                        Marker apMarker = this.apState.getMarker();
                        int apX = apMarker.getPixelX();
                        int apY = apMarker.getPixelY();
                        double apXRatio = (double)apX / (double)this.map.getImage().getWidth();
                        double apYRatio = (double)apY / (double)this.map.getImage().getHeight();
                        double apLatitude = this.mercatorConverter.getPhi(apYRatio);
                        double apLongitude = this.mercatorConverter.getPsi(apXRatio);
                        if (this.map.gpsCoordinateAvailable()) {
                            double psi = this.mercatorConverter.getPsi(clickRatioX);
                            double phi = this.mercatorConverter.getPhi(clickRatioY);
                            this.locationCurrentLatLonField.setText(String.format("%.6f,%.6f", phi, psi));
                            node.updateLatitudeLongitude(phi, psi);
                            if (apMarker.isEnabled()) {
                                distance = (int)Math.round(WebMercator.distanceInMeter(phi, psi, apLatitude, apLongitude));
                                node.setDistance(distance);
                                this.locationCurrentDistanceField.setText(String.format("%d", distance));
                            }
                        } else if (apMarker.isEnabled() && this.mapScaleAvailable) {
                            double dx = clickPixelX - apX;
                            double dy = clickPixelY - apY;
                            distance = (int)Math.round(this.distancePerPixel * Math.sqrt(dx * dx + dy * dy));
                            node.setDistance(distance);
                            this.locationCurrentDistanceField.setText(String.format("%d", distance));
                        }
                    }
                    for (String measKey : this.satelliteMapMasterPanels.keySet()) {
                        node.add(measKey, null);
                    }
                    boolean degenerateNode = true;
                    for (String measKey : measurements.keySet()) {
                        if (!this.lastDataTimeMap.containsKey(measKey)) continue;
                        JsonObject measData = measurements.get(measKey).getAsJsonObject();
                        int measIndex = measData.get("index").getAsInt();
                        long measTime = measData.get("time").getAsLong();
                        JsonElement measPreValue = measData.get("value");
                        if (measPreValue.isJsonNull()) continue;
                        double measValue = measPreValue.getAsDouble();
                        String measLine = String.format("%s,%s,%s,%s,%s", time, measKey, measValue, measIndex, measTime);
                        System.out.println(measLine);
                        node.add(measKey, measValue);
                        if (measTime != this.lastDataTimeMap.get(measKey)) {
                            this.graphCascadingPanel.addData(measKey, measValue);
                            measurementAvailable = true;
                        }
                        this.lastDataTimeMap.put(measKey, measTime);
                        degenerateNode = false;
                    }
                    boolean bl = addLog = position != null && JOptionPane.showConfirmDialog(this, message.toString(), "Adding measurement data", 2, -1, null) == 0;
                    if (addLog) {
                        String positionLine = String.format("%s,%s,%s,%s,%s", time, clickPixelX, clickPixelY, clickRatioX, clickRatioY);
                        System.out.println(positionLine);
                    }
                    if (addLog && !degenerateNode) {
                        this.table.addRow(node);
                        if (this.autoScrollCheckBox.isSelected()) {
                            this.table.scrollToBottom();
                        }
                    }
                    boolean followGPS = this.locationCurrentFollowCheckBox.isSelected();
                    for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
                        SatelliteMapPanel satelliteMapPanel = satelliteMapMasterPanel.getSatelliteMapPanel();
                        if (followGPS) {
                            Marker apMarker = this.apState.getMarker();
                            satelliteMapPanel.centerAt(apMarker.getPixelX(), apMarker.getPixelY());
                        }
                        satelliteMapPanel.repaint();
                    }
                    if (this.beepSoundCheckBox.isSelected() && measurementAvailable) {
                        this.soundDoubleBeep.play();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("[CONNECTION THREAD EXIT]");
    }

    private boolean openMapImageFileSelector() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File("~"));
        fileChooser.setDialogTitle("Opening a map image file");
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showOpenDialog(this) != 0) {
            return false;
        }
        File imageFile = fileChooser.getSelectedFile();
        if (!this.loadImage(imageFile)) {
            String errorMessage = String.format("The image file could not be loaded: %s", imageFile.getName());
            UtilSwing.displayErrorMessage(this, errorMessage, new Object[0]);
            this.openMapImageFileSelector();
        }
        this.openPathPanel.setBackground(Color.LIGHT_GRAY);
        this.openPathLabel.setText(imageFile.getAbsolutePath());
        return true;
    }

    private void openMapGPSUpdater() {
        try {
            String message = "*If GPS coordinates are not applicable, press CANCEL for manual operation.\n\n";
            message = String.valueOf(message) + "FORMAT: (TOP-LEFT) LATITUDE, (TOP-LEFT) LONGTITUDE, (BOTTOM-RIGHT) LATITUDE, (BOTTOM-RIGHT) LONGTIUDE";
            String title = "Updating GPS Coordinates for the Input Map";
            String sampleText = this.mercatorConverter == null ? "<REPLACE-THIS>,<REPLACE-THIS>,<REPLACE-THIS>,<REPLACE-THIS>" : String.format("%s,%s,%s,%s", this.mercatorConverter.getStartPhi(), this.mercatorConverter.getStartPsi(), this.mercatorConverter.getEndPhi(), this.mercatorConverter.getEndPsi());
            Object input = JOptionPane.showInputDialog(this, message, title, -1, null, null, sampleText);
            if (input == null) {
                return;
            }
            String line = input.toString();
            String[] values = line.split(",", -1);
            double phi1 = Double.parseDouble(values[0]);
            double psi1 = Double.parseDouble(values[1]);
            double phi2 = Double.parseDouble(values[2]);
            double psi2 = Double.parseDouble(values[3]);
            this.locationTopLeftLatLonField.setText(String.format("%s,%s", phi1, psi1));
            this.locationBottomRightLatLonField.setText(String.format("%s,%s", phi2, psi2));
            this.map.setGPSCoordinates(phi1, psi1, phi2, psi2);
            this.mercatorConverter = this.map.getMercatorConverter();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.openMapGPSUpdater();
        }
    }

    private boolean loadImage(File imageFile) {
        try {
            boolean mapGPSCoordinateAvailable;
            this.map = SatelliteMap.load(imageFile);
            this.mercatorConverter = this.map.getMercatorConverter();
            if (this.mercatorConverter == null) {
                this.openMapGPSUpdater();
            }
            boolean bl = mapGPSCoordinateAvailable = this.mercatorConverter != null;
            if (!mapGPSCoordinateAvailable) {
                this.locationTopLeftLatLonField.setText("");
                this.locationBottomRightLatLonField.setText("");
                this.map.setGPSCoordinates(0.0, 0.0, 0.0, 0.0);
                this.mercatorConverter = this.map.getMercatorConverter();
            }
            this.locationMapScalePanel.setVisible(!mapGPSCoordinateAvailable);
            this.locationAPLatLonPanel.setVisible(mapGPSCoordinateAvailable);
            this.locationGPSMapPanel.setVisible(mapGPSCoordinateAvailable);
            this.positioningGPSModeButton.setSelected(mapGPSCoordinateAvailable);
            this.positioningSatellitesPanel.setVisible(mapGPSCoordinateAvailable);
            this.locationCurrentFollowCheckBox.setSelected(mapGPSCoordinateAvailable);
            this.locationCurrentPanel.setVisible(mapGPSCoordinateAvailable);
            this.locationPanel.setVisible(true);
            this.locationTopLeftLatLonField.setText(String.format("%.6f,%.6f", this.map.getPhi1(), this.map.getPsi1()));
            this.locationBottomRightLatLonField.setText(String.format("%.6f,%.6f", this.map.getPhi2(), this.map.getPsi2()));
            APLocatorPanel apLocatorPanel = this.apLocatorMasterPanel.getAPLocatorPanel();
            this.previewMapPanel.setImage(this.map.getImage());
            apLocatorPanel.setImage(this.map.getImage());
            this.mapScaleMasterPanel.getMapScalePanel().setImage(this.map.getImage());
            this.previewMapPanel.reset(1);
            apLocatorPanel.reset(2);
            this.mapScaleMasterPanel.getMapScalePanel().reset(2);
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            this.resetControl();
            UtilSwing.fixPreferredHeight(this.positioningPanel);
            UtilSwing.fixPreferredHeight(this.locationPanel);
            this.revalidate();
            this.repaint();
            this.requestFocusInWindow();
        }
    }

    private void updateClickedMapPosition(int x, int y) {
        this.clickedMapPosition = new XY(x, y);
        Marker staMarker = this.staState.getMarker();
        int mapPixelX = (int)Math.round(this.clickedMapPosition.getX());
        int mapPixelY = (int)Math.round(this.clickedMapPosition.getY());
        staMarker.setEnabled(true);
        staMarker.setPixelPosition(mapPixelX, mapPixelY);
        staMarker.setLocationUnsure(false);
    }

    private XY getClickedMapPosition() {
        XY position = this.clickedMapPosition;
        this.clickedMapPosition = null;
        return position;
    }

    private void addSatelliteMapMasterPanel(String name, SatelliteMapMasterPanel satelliteMapMasterPanel) {
        final SatelliteMapPanel satelliteMapPanel = satelliteMapMasterPanel.getSatelliteMapPanel();
        satelliteMapPanel.addObserver(this);
        satelliteMapPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MainSTAT.this.requestFocusInWindow();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!MainSTAT.this.positioningManualModeButton.isSelected() || !MainSTAT.this.connected) {
                    return;
                }
                switch (e.getButton()) {
                    case 2: 
                    case 3: {
                        Image image = satelliteMapPanel.getImage();
                        int x = (int)satelliteMapPanel.getTrueX(e.getX());
                        int y = (int)satelliteMapPanel.getTrueY(e.getY());
                        double imageWidth = image.getWidth(null);
                        double imageHeight = image.getHeight(null);
                        if (x < 0 || imageWidth < (double)x || y < 0 || imageHeight < (double)y) {
                            return;
                        }
                        MainSTAT.this.updateClickedMapPosition(x, y);
                        MainSTAT.this.repaint();
                    }
                }
            }
        });
        this.satelliteMapMasterPanels.put(name, satelliteMapMasterPanel);
        this.satelliteMapPane.add((Component)satelliteMapMasterPanel, name);
        JLabel label = new JLabel(name);
        label.setForeground(Color.BLACK);
        label.setFont(new Font("ARIAL", 0, 16));
        this.satelliteMapPane.setTabComponentAt(this.satelliteMapMasterPanels.size() - 1, label);
    }

    private void enableKeyboardMouseUI() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 65: {
                        MainSTAT.this.applyAspectFit();
                        break;
                    }
                    case 79: {
                        MainSTAT.this.applyOriginalFit();
                    }
                }
                MainSTAT.this.repaint();
            }
        });
    }

    @Override
    public void frameParameterChanged(ZoomableImagePanel source) {
        for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
            if (satelliteMapMasterPanel.getSatelliteMapPanel().equals(source)) continue;
            satelliteMapMasterPanel.getSatelliteMapPanel().setFrameLocation(source.frameX(), source.frameY());
            satelliteMapMasterPanel.getSatelliteMapPanel().setZoom(source.getZoom());
        }
        this.repaint();
    }

    @Override
    public void mouseEntered() {
        this.requestFocusInWindow();
    }

    @Override
    public void configChanged(String name, HeatmapRenderConfig config) {
        this.graphCascadingPanel.setGraphConfig(name, config);
    }

    @Override
    public void applyAspectFit() {
        if (this.previewMapPanel != null) {
            this.previewMapPanel.reset(1);
        }
        for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
            satelliteMapMasterPanel.getSatelliteMapPanel().reset(1);
        }
    }

    @Override
    public void applyOriginalFit() {
        if (this.previewMapPanel != null) {
            this.previewMapPanel.reset(0);
        }
        for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
            satelliteMapMasterPanel.getSatelliteMapPanel().reset(0);
        }
    }

    @Override
    public void adjustZoomRelativeToCurrent(double factor) {
        if (this.previewMapPanel != null) {
            this.previewMapPanel.adjustZoomRelativeToCurrent(factor);
        }
        for (SatelliteMapMasterPanel satelliteMapMasterPanel : this.satelliteMapMasterPanels.values()) {
            satelliteMapMasterPanel.getSatelliteMapPanel().adjustZoomRelativeToCurrent(factor);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            MainSTAT main = new MainSTAT();
            main.setVisible(true);
        });
    }

    public class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cellComponent.setForeground(column == 0 ? Color.RED : (column < 8 ? Color.YELLOW : Color.GREEN));
            cellComponent.setBackground(isSelected ? Color.GRAY : Color.BLACK);
            return cellComponent;
        }
    }
}

