/*
 * Decompiled with CFR 0.152.
 */
package AppWAVE;

import AppWAVE.DataSet;
import AppWAVE.Heatmap;
import AppWAVE.HeatmapMasterPanel;
import AppWAVE.HeatmapPanel;
import AppWAVE.WAVEConfigPanel;
import Config.HeatmapRenderConfig;
import Config.InitConfig;
import GUIModule.UIGuideBar.UIGuideBarListener;
import GUIModule.UIGuideBar.UIGuideBarPanel;
import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import GUIModule.ZoomableImageModule.ZoomableImageUIObserver;
import Loader.CSVLoader;
import Loader.CoordinatesFileLoader;
import Loader.DataFileLoader;
import Loader.InitConfigFileLoader;
import Main.AboutPanel;
import Main.Main;
import Util.UtilDate;
import Util.UtilSwing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class MainWAVE
extends JFrame
implements ZoomableImageUIObserver,
UIGuideBarListener {
    private static final long serialVersionUID = 1L;
    private AboutPanel aboutPanel = new AboutPanel();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu swissMenu = new JMenu("SWiSS");
    private JMenuItem aboutMenuItem = new JMenuItem("About");
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem openDataMenuItem = new JMenuItem("Open Data");
    private JMenuItem exportHeatmapsAsImagesMenuItem = new JMenuItem("Export Heatmaps As Images");
    private JMenuItem exportHeatmapsAsNumericCSVMenuItem = new JMenuItem("Export Heatmaps As Numeric CSV");
    private JPanel openPathPanel = new JPanel(new FlowLayout(1));
    private JLabel openPathLabel = new JLabel();
    private UIGuideBarPanel uiGuidePanel = new UIGuideBarPanel().addAspectFit(this).addOriginalFit(this).addZoomIn(this).addZoomOut(this).addMove();
    private JTabbedPane heatmapPane = new JTabbedPane();
    private Map<String, HeatmapMasterPanel> heatmapMasterPanels = new LinkedHashMap<String, HeatmapMasterPanel>();
    private File outputDirectory = null;

    public MainWAVE(InitConfig initConfig, File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.setIconImage(Main.swissImageIcon);
        this.setTitle("Newracom WiFi Area Visual Evaluator (WAVE) v1.0");
        this.setDefaultCloseOperation(0);
        this.setSize(new Window(null).getGraphicsConfiguration().getBounds().getSize());
        this.swissMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.swissMenu);
        this.fileMenu.add(this.openDataMenuItem);
        this.fileMenu.add(this.exportHeatmapsAsImagesMenuItem);
        this.fileMenu.add(this.exportHeatmapsAsNumericCSVMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.aboutMenuItem.addActionListener(event -> {
            this.aboutPanel.startAnimation();
            JOptionPane.showMessageDialog(this, this.aboutPanel, "About", -1, null);
            this.aboutPanel.stopAnimation();
            this.aboutPanel.setVisible(true);
        });
        this.openDataMenuItem.addActionListener(event -> this.openConfigFileSelector(false));
        this.exportHeatmapsAsImagesMenuItem.addActionListener(event -> this.exportHeatmapsAsImagesHandler());
        this.exportHeatmapsAsNumericCSVMenuItem.addActionListener(event -> this.exportHeatmapsAsNumericCSVHandler());
        this.setLayout(new BorderLayout());
        this.openPathPanel.add(this.openPathLabel);
        this.add((Component)this.openPathPanel, "North");
        this.add((Component)this.uiGuidePanel, "South");
        this.enableKeyboardUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                String message = "Are you sure you want to close the program?";
                String title = "Closing the program";
                int option = JOptionPane.showConfirmDialog(MainWAVE.this, message, title, 2, -1, null);
                if (option == 0) {
                    MainWAVE.this.dispose();
                    System.exit(0);
                }
            }
        });
        if (initConfig != null) {
            this.load(initConfig);
        } else {
            SwingUtilities.invokeLater(() -> this.openConfigFileSelector(true));
        }
    }

    private void openConfigFileSelector(boolean firstTime) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.outputDirectory);
        fileChooser.setDialogTitle("Loading a WAVE Config JSON file");
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showOpenDialog(this) != 0) {
            if (firstTime) {
                this.dispose();
                System.exit(0);
            }
            return;
        }
        File configFile = fileChooser.getSelectedFile();
        try {
            InitConfig initConfig = InitConfigFileLoader.loadJSON(configFile);
            if (!this.load(initConfig)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = String.format("The config file could not be loaded: %s\n", configFile.getName());
            UtilSwing.displayErrorMessage(this, errorMessage, new Object[0]);
            this.openConfigFileSelector(firstTime);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean load(InitConfig initConfig) {
        this.openPathPanel.setBackground(Color.LIGHT_GRAY);
        this.openPathLabel.setText(initConfig.getConfigPath());
        try {
            csvFile = null;
            dataFile = null;
            coordinateFile = null;
            imageFile = null;
            measurements = null;
            coordinates = null;
            csvAvailable = initConfig.getCSVPath() != null;
            imageFile = new File(initConfig.getImagePath());
            if (csvAvailable) {
                csvFile = new File(initConfig.getCSVPath());
                waveCSVLoader = CSVLoader.load(csvFile, imageFile);
                measurements = waveCSVLoader.getMeasurements();
                coordinates = waveCSVLoader.getCoordinates();
            } else {
                dataFile = new File(initConfig.getDataPath());
                coordinateFile = new File(initConfig.getCoordinatesPath());
                measurements = DataFileLoader.load(dataFile);
                coordinates = CoordinatesFileLoader.load(coordinateFile);
            }
            this.heatmapPane.removeAll();
            this.heatmapMasterPanels.clear();
            orderedKeys = new ArrayList<String>();
            orderedKeys.addAll(measurements.keySet());
            if (initConfig != null) {
                Collections.sort(orderedKeys, initConfig.getKeyOrderComparator());
            }
            var11_11 = orderedKeys.iterator();
            while (true) {
                if (!var11_11.hasNext()) {
                    this.add((Component)this.heatmapPane, "Center");
                }
                dataKey = (String)var11_11.next();
                data = measurements.get(dataKey);
                mapImage = ImageIO.read(imageFile);
                dataSet = new DataSet(data, coordinates);
                heatmapMasterPanel = new HeatmapMasterPanel(dataKey, mapImage, dataSet);
                heatmapMasterPanel.getHeatmapPanel().addObserver(this);
                configPanel = heatmapMasterPanel.getConfigPanel();
                if (initConfig != null) {
                    renderConfig = initConfig.getHeatmapRenderConfig(dataKey);
                    if (initConfig.isAPLocationAvailable()) {
                        renderConfig.setAPLocation(initConfig.getAPX(), initConfig.getAPY());
                    }
                    if (renderConfig == null) continue;
                    configPanel.set(renderConfig);
                }
                this.heatmapPane.add(dataKey, heatmapMasterPanel);
                this.heatmapMasterPanels.put(dataKey, heatmapMasterPanel);
                heatmapMasterPanel.configPanelUpdated(configPanel);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.revalidate();
            this.repaint();
            ** for (heatmapMasterPanel : this.heatmapMasterPanels.values())
        }
lbl-1000:
        // 1 sources

        {
            heatmapMasterPanel.getHeatmapPanel().reset(1);
            continue;
        }
lbl60:
        // 1 sources

        return false;
    }

    private void exportToImage() {
        Calendar calendar = Calendar.getInstance();
        String format = "png";
        for (String dataKey : this.heatmapMasterPanels.keySet()) {
            HeatmapMasterPanel heatmapMasterPanel = this.heatmapMasterPanels.get(dataKey);
            HeatmapPanel heatmapPanel = heatmapMasterPanel.getHeatmapPanel();
            WAVEConfigPanel configPanel = heatmapMasterPanel.getConfigPanel();
            HeatmapRenderConfig config = configPanel.get();
            double dataScale = config.getDataScale();
            int footnoteMargin = 25;
            int imageWidth = heatmapPanel.getImage().getWidth(null);
            int canvasWidth = heatmapPanel.getCombinedElementWidth();
            int canvasHeight = heatmapPanel.getImage().getHeight(null);
            BufferedImage canvas = new BufferedImage(canvasWidth, canvasHeight + footnoteMargin, 2);
            Graphics2D g = canvas.createGraphics();
            heatmapPanel.paint(g, 0.0, 0.0, 1.0);
            g.setFont(new Font("COURIER NEW", 0, 20));
            g.setColor(Color.BLACK);
            g.fillRect(0, canvasHeight, canvasWidth, footnoteMargin);
            g.setColor(new Color(240, 134, 16));
            String leftText = "Newracom SWiSS Toolkit v1.0";
            int verticalPadding = 2;
            ((Graphics)g).drawString(leftText, 0, canvasHeight + footnoteMargin - verticalPadding);
            String rightText = String.format("%s", configPanel.getTitle());
            if (dataScale != 1.0) {
                rightText = String.format("(scale: %s) %s", dataScale, rightText);
            }
            int rightTextOffsetX = -g.getFontMetrics().stringWidth(rightText);
            ((Graphics)g).drawString(rightText, imageWidth + rightTextOffsetX, canvasHeight + footnoteMargin - verticalPadding);
            g.dispose();
            String outputPath = String.format("%s/%s_%s.%s", this.outputDirectory.getAbsolutePath(), UtilDate.getDate_YYYY_MM_DD_hh_mm_ss(calendar), dataKey, format);
            try {
                ImageIO.write((RenderedImage)canvas, format, new File(outputPath));
            }
            catch (Exception e) {
                e.printStackTrace();
                UtilSwing.displayErrorMessage(this, "Images could not be exported.", new Object[0]);
            }
        }
    }

    private void exportToNumericCSV() {
        Calendar calendar = Calendar.getInstance();
        for (String dataKey : this.heatmapMasterPanels.keySet()) {
            HeatmapMasterPanel heatmapMasterPanel = this.heatmapMasterPanels.get(dataKey);
            String outputPath = String.format("%s/%s_numeric_%s.csv", this.outputDirectory.getAbsolutePath(), UtilDate.getDate_YYYY_MM_DD_hh_mm_ss(calendar), dataKey);
            File outputFile = new File(outputPath);
            Heatmap heatmap = heatmapMasterPanel.getHeatmap();
            Heatmap.saveHeatmap(heatmap, outputFile);
        }
    }

    private boolean setExportDirectory() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.outputDirectory);
        fileChooser.setSelectedFile(this.outputDirectory);
        System.out.println(this.outputDirectory);
        fileChooser.setDialogTitle("Select the output directory");
        fileChooser.setFileSelectionMode(1);
        fileChooser.setSelectedFile(null);
        if (fileChooser.showSaveDialog(this) != 0) {
            return false;
        }
        this.outputDirectory = fileChooser.getSelectedFile();
        return true;
    }

    private void exportHeatmapsAsImagesHandler() {
        if (this.setExportDirectory()) {
            this.exportToImage();
        }
    }

    private void exportHeatmapsAsNumericCSVHandler() {
        if (this.setExportDirectory()) {
            this.exportToNumericCSV();
        }
    }

    private void enableKeyboardUI() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 65: {
                        MainWAVE.this.applyAspectFit();
                        break;
                    }
                    case 79: {
                        MainWAVE.this.applyOriginalFit();
                    }
                }
                MainWAVE.this.repaint();
            }
        });
        this.heatmapPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MainWAVE.this.requestFocusInWindow();
            }
        });
    }

    @Override
    public void frameParameterChanged(ZoomableImagePanel source) {
        for (HeatmapMasterPanel heatmapMasterPanel : this.heatmapMasterPanels.values()) {
            HeatmapPanel heatmapPanel = heatmapMasterPanel.getHeatmapPanel();
            if (heatmapPanel.equals(source)) continue;
            heatmapPanel.setFrameLocation(source.frameX(), source.frameY());
            heatmapPanel.setZoom(source.getZoom());
        }
        this.repaint();
    }

    @Override
    public void mouseEntered() {
        this.requestFocusInWindow();
    }

    @Override
    public void applyAspectFit() {
        for (HeatmapMasterPanel heatmapMasterPanel : this.heatmapMasterPanels.values()) {
            heatmapMasterPanel.getHeatmapPanel().reset(1);
        }
    }

    @Override
    public void applyOriginalFit() {
        for (HeatmapMasterPanel heatmapMasterPanel : this.heatmapMasterPanels.values()) {
            heatmapMasterPanel.getHeatmapPanel().reset(0);
        }
    }

    @Override
    public void adjustZoomRelativeToCurrent(double factor) {
        for (HeatmapMasterPanel heatmapMasterPanel : this.heatmapMasterPanels.values()) {
            heatmapMasterPanel.getHeatmapPanel().adjustZoomRelativeToCurrent(factor);
        }
    }

    private static void printCLIUsageAndExit() {
        System.out.println("WAVE arguments: <Input Config File>");
        System.exit(1);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            InitConfig initConfig = null;
            File outputDirectory = null;
            if (args.length > 0) {
                if (1 <= args.length) {
                    File inputFile = new File(args[0]);
                    if (inputFile.isDirectory()) {
                        File[] fileArray = inputFile.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            if (file.getName().toLowerCase().endsWith(".json")) {
                                inputFile = file;
                                break;
                            }
                            ++n2;
                        }
                    }
                    outputDirectory = new File(inputFile.getAbsolutePath()).getParentFile();
                    String lowerCaseName = inputFile.getName().toLowerCase();
                    if (lowerCaseName.endsWith(".json")) {
                        initConfig = InitConfigFileLoader.loadJSON(inputFile);
                    } else if (lowerCaseName.endsWith(".cfg")) {
                        initConfig = InitConfigFileLoader.loadCFG(inputFile);
                    } else {
                        MainWAVE.printCLIUsageAndExit();
                    }
                }
                if (args.length > 1) {
                    MainWAVE.printCLIUsageAndExit();
                }
            }
            MainWAVE main = new MainWAVE(initConfig, outputDirectory);
            main.setVisible(true);
        });
    }
}

