/*
 * Decompiled with CFR 0.152.
 */
package AppWAVE;

import AppWAVE.ColorPickerButton;
import AppWAVE.WAVEConfigPanelObserver;
import Config.HeatmapRenderConfig;
import GUIModule.Colors;
import GUIModule.GUIFactory;
import Util.UtilSwing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class WAVEConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String title = "";
    private JComboBox<String> typeComboBox = GUIFactory.makeComboBox();
    private JCheckBox boundedCheckBox = GUIFactory.makeCheckBox("Bounded");
    private JTextField radiusField = GUIFactory.makeTextField(5);
    private JTextField alphaField = GUIFactory.makeTextField(3);
    private JSlider alphaSlider = GUIFactory.makeSlider(0, 255, 128);
    private JTextField decimalField = GUIFactory.makeTextField(2);
    private JSlider decimalSlider = GUIFactory.makeSlider(0, 9, 0);
    private JLabel dataMinLabel = GUIFactory.makeLabel("Min:");
    private JTextField dataMinField = GUIFactory.makeTextField(10);
    private JLabel dataMaxLabel = GUIFactory.makeLabel("Max:");
    private JTextField dataMaxField = GUIFactory.makeTextField(10);
    private JLabel dataScaleLabel = GUIFactory.makeLabel("Scale:");
    private JTextField dataScaleField = GUIFactory.makeTextField(10);
    private JCheckBox imageCheckBox = GUIFactory.makeCheckBox("Image");
    private JCheckBox heatmapCheckBox = GUIFactory.makeCheckBox("Heatmap");
    private JCheckBox pointCheckBox = GUIFactory.makeCheckBox("Point");
    private JCheckBox valueCheckBox = GUIFactory.makeCheckBox("Value");
    private JComboBox<String> fontNameComboBox = GUIFactory.makeComboBox();
    private JLabel fontSizeLabel = GUIFactory.makeLabel("Size:");
    private JComboBox<Integer> fontSizeComboBox = GUIFactory.makeComboBox();
    private JLabel fontColorLabel = GUIFactory.makeLabel("Color:");
    private ColorPickerButton fontColorButton = new ColorPickerButton();
    private JButton applyButton = GUIFactory.makeButton("Apply");
    private boolean apLocationAvailable = false;
    private int apPixelX = -1;
    private int apPixelY = -1;

    private static JPanel WC(LayoutManager layoutManager, String title, JComponent ... components) {
        JPanel panel = new JPanel(layoutManager){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMaximumSize() {
                Dimension defaultMax = super.getMaximumSize();
                Dimension preferred = this.getPreferredSize();
                return new Dimension(defaultMax.width, preferred.height);
            }
        };
        panel.setBackground(GUIFactory.panelBG);
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent component = jComponentArray[n2];
            panel.add(component);
            ++n2;
        }
        if (title != null) {
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), title, 2, 1, new Font("ARIAL", 0, 16), Color.WHITE));
        }
        return panel;
    }

    private static JPanel WC(String title, JComponent ... components) {
        return WAVEConfigPanel.WC(new FlowLayout(1), title, components);
    }

    private void synchronizeSliderWithField(JSlider slider, JTextField field) {
        field.setText(String.format(" %s ", slider.getValue()));
        slider.addChangeListener(event -> {
            field.setText(String.format(" %s ", slider.getValue()));
            this.repaint();
        });
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public WAVEConfigPanel(String title, WAVEConfigPanelObserver observer) {
        this.title = title;
        this.setBackground(Color.DARK_GRAY);
        this.setLayout(new BoxLayout(this, 1));
        this.typeComboBox.addItem("BLUR");
        this.typeComboBox.addItem("VORONOI");
        this.add(WAVEConfigPanel.WC("TYPE", this.typeComboBox));
        this.add(WAVEConfigPanel.WC("RADIUS", this.boundedCheckBox, this.radiusField));
        this.add(WAVEConfigPanel.WC(new GridLayout(2, 1), "ALPHA", WAVEConfigPanel.WC(new FlowLayout(1), null, this.alphaField), this.alphaSlider));
        this.add(WAVEConfigPanel.WC(new GridLayout(2, 1), "DECIMAL", WAVEConfigPanel.WC(new FlowLayout(1), null, this.decimalField), this.decimalSlider));
        this.add(WAVEConfigPanel.WC(new GridLayout(3, 1), "DATA", WAVEConfigPanel.WC(new FlowLayout(2), null, this.dataMinLabel, this.dataMinField), WAVEConfigPanel.WC(new FlowLayout(2), null, this.dataMaxLabel, this.dataMaxField), WAVEConfigPanel.WC(new FlowLayout(2), null, this.dataScaleLabel, this.dataScaleField)));
        this.add(WAVEConfigPanel.WC(new GridLayout(4, 1), "PLOT OPTIONS", this.imageCheckBox, this.heatmapCheckBox, this.pointCheckBox, this.valueCheckBox));
        this.add(WAVEConfigPanel.WC(new GridLayout(3, 1), "FONT", WAVEConfigPanel.WC(new FlowLayout(1), null, this.fontNameComboBox, this.fontSizeComboBox), WAVEConfigPanel.WC(new FlowLayout(1), null, this.fontSizeLabel, this.fontSizeComboBox), WAVEConfigPanel.WC(new FlowLayout(1), null, this.fontColorLabel, this.fontColorButton)));
        this.add(WAVEConfigPanel.WC(null, this.applyButton));
        this.boundedCheckBox.setForeground(Colors.LIGHTER_GRAY_COLOR);
        this.imageCheckBox.setForeground(Colors.LIGHTER_GRAY_COLOR);
        this.heatmapCheckBox.setForeground(Colors.LIGHTER_GRAY_COLOR);
        this.valueCheckBox.setForeground(Colors.LIGHTER_GRAY_COLOR);
        this.pointCheckBox.setForeground(Colors.LIGHTER_GRAY_COLOR);
        this.radiusField.setText("100");
        this.dataMinField.setText("0");
        this.dataMaxField.setText("1.15e7");
        this.dataScaleField.setText("1e-3");
        this.imageCheckBox.setSelected(true);
        this.heatmapCheckBox.setSelected(true);
        this.valueCheckBox.setSelected(true);
        this.pointCheckBox.setSelected(true);
        this.alphaField.setHorizontalAlignment(0);
        this.alphaField.setEditable(false);
        this.decimalField.setHorizontalAlignment(0);
        this.decimalField.setEditable(false);
        this.fontNameComboBox.addItem("SWiSS 3x5");
        this.fontNameComboBox.addItem("Arial");
        this.fontNameComboBox.addItem("Courier New");
        this.fontNameComboBox.addItem("Times New Roman");
        this.fontNameComboBox.addItem("Verdana");
        int size = 10;
        while (size <= 64) {
            this.fontSizeComboBox.addItem(size);
            ++size;
        }
        this.synchronizeSliderWithField(this.alphaSlider, this.alphaField);
        this.synchronizeSliderWithField(this.decimalSlider, this.decimalField);
        this.fontNameComboBox.addActionListener(event -> {
            boolean swissFontSelected = UtilSwing.getSelectedItem(this.fontNameComboBox).equals("SWiSS 3x5");
            this.fontSizeComboBox.setEnabled(!swissFontSelected);
        });
        this.applyButton.addActionListener(event -> {
            this.unlockApplyButton(false);
            if (observer != null) {
                observer.configPanelUpdated(this);
            }
        });
    }

    private static int BAI(double value, int min, int max) {
        int intValue = (int)value;
        if (intValue < min) {
            return min;
        }
        if (intValue > max) {
            return max;
        }
        return intValue;
    }

    private static int GTFI(JTextField field) {
        return (int)Double.parseDouble(field.getText());
    }

    private static double GTFD(JTextField field) {
        return Double.parseDouble(field.getText());
    }

    private static void BTFI(JTextField field, int min, int max) {
        field.setText(String.format("%d", WAVEConfigPanel.BAI(WAVEConfigPanel.GTFD(field), min, max)));
    }

    public HeatmapRenderConfig get() {
        try {
            this.radiusField.setText(String.format("%d", (int)Double.parseDouble(this.radiusField.getText())));
            WAVEConfigPanel.BTFI(this.radiusField, 0, Integer.MAX_VALUE);
            HeatmapRenderConfig config = new HeatmapRenderConfig();
            config.setType(UtilSwing.getSelectedItem(this.typeComboBox));
            config.setBoundedRadius(this.boundedCheckBox.isSelected());
            config.setRadius(WAVEConfigPanel.GTFI(this.radiusField));
            config.setAlpha(this.alphaSlider.getValue());
            config.setDecimal(this.decimalSlider.getValue());
            config.setDataMin(WAVEConfigPanel.GTFD(this.dataMinField));
            config.setDataMax(WAVEConfigPanel.GTFD(this.dataMaxField));
            config.setDataScale(WAVEConfigPanel.GTFD(this.dataScaleField));
            config.setImagePlotEnabled(this.imageCheckBox.isSelected());
            config.setHeatmapPlotEnabled(this.heatmapCheckBox.isSelected());
            config.setPointPlotEnabled(this.pointCheckBox.isSelected());
            config.setValuePlotEnabled(this.valueCheckBox.isSelected());
            if (this.apLocationAvailable) {
                config.setAPLocation(this.apPixelX, this.apPixelY);
            }
            config.setFontName(UtilSwing.getSelectedItem(this.fontNameComboBox));
            config.setFontSize(UtilSwing.getSelectedItem(this.fontSizeComboBox));
            config.setFontColor(this.fontColorButton.getColor());
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void set(HeatmapRenderConfig config) {
        this.typeComboBox.setSelectedItem(config.getType());
        this.boundedCheckBox.setSelected(config.getBoundedRadius());
        this.radiusField.setText(String.format("%d", config.getRadius()));
        this.alphaSlider.setValue(config.getAlpha());
        this.decimalSlider.setValue(config.getDecimal());
        this.dataMinField.setText(String.format("%s", config.getDataMin()));
        this.dataMaxField.setText(String.format("%s", config.getDataMax()));
        this.dataScaleField.setText(String.format("%s", config.getDataScale()));
        this.heatmapCheckBox.setSelected(config.getHeatmapPlotEnabled());
        this.imageCheckBox.setSelected(config.getImagePlotEnabled());
        this.pointCheckBox.setSelected(config.getPointPlotEnabled());
        this.valueCheckBox.setSelected(config.getValuePlotEnabled());
        this.apLocationAvailable = config.getAPLocationAvailable();
        this.apPixelX = config.getAPPixelX();
        this.apPixelY = config.getAPPixelY();
        this.fontNameComboBox.setSelectedItem(config.getFontName());
        this.fontSizeComboBox.setSelectedItem(config.getFontSize());
        this.fontColorButton.setColor(config.getFontColor());
    }

    public void unlockApplyButton(boolean value) {
        this.applyButton.setEnabled(value);
    }
}

