/*
 * Decompiled with CFR 0.152.
 */
package GUIModule.AnimatedIcons;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class SatelliteIcon
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int RADIUS = 16;
    private boolean isAvailable = true;
    private boolean isOn;
    private static final Color COLOR_WINGS = new Color(0, 0, 64);
    private static final Color COLOR_GRID = new Color(64, 64, 0);
    private static Color[] GREENS = new Color[]{new Color(0, 165, 0), new Color(0, 195, 0), new Color(0, 225, 0), new Color(0, 255, 0)};

    public SatelliteIcon() {
        this.setBackground(Color.DARK_GRAY);
        int diameter = 33;
        this.setPreferredSize(new Dimension(diameter, diameter));
    }

    public void setOnOff(boolean value) {
        this.isOn = value;
    }

    public void setAvailable(boolean value) {
        this.isAvailable = value;
    }

    private void drawWing(Graphics g, int x, int y) {
        int yOffset;
        int wingWidth = 8;
        int wingHeight = 24;
        g.setColor(COLOR_WINGS);
        g.fillRect(x, y, wingWidth, wingHeight);
        g.setColor(Color.DARK_GRAY);
        int j = 0;
        while (j <= 8) {
            yOffset = wingHeight * j / 8;
            g.drawLine(x, y + yOffset, x + wingWidth, y + yOffset);
            ++j;
        }
        g.setColor(COLOR_GRID);
        int i = 0;
        while (i <= 2) {
            int xOffset = wingWidth * i / 2;
            g.drawLine(x + xOffset, y, x + xOffset, y + wingHeight);
            ++i;
        }
        j = 0;
        while (j <= 4) {
            yOffset = wingHeight * j / 4;
            g.drawLine(x, y + yOffset, x + wingWidth, y + yOffset);
            ++j;
        }
    }

    private void drawBody(Graphics g, int x, int y) {
        g.setColor(Color.GRAY);
        g.fillPolygon(new int[]{x - 4, x, x + 4}, new int[]{y + 4, y, y + 4}, 3);
        g.setColor(Color.GRAY);
        g.fillRect(x - 8, y - 0, 16, 1);
        if (this.isOn) {
            long time = System.currentTimeMillis();
            int i = 3;
            while (i >= 0) {
                g.setColor(GREENS[3 - i]);
                int r = i * 16 / 4 + (int)(time >> 4) % 16 / 4;
                g.drawOval(x - 4 - r, y + 8 + r, 8 + 2 * r, 2);
                --i;
            }
        }
        g.setColor(Color.GRAY);
        g.fillRect(x - 2, y - 1, 4, 2);
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(x - 0, y + 4, 0, 4);
        g.setColor(Color.GRAY);
        g.fillOval(x - 1, y + 8 - 1, 2, 2);
        if (!this.isAvailable) {
            ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
            g.setColor(Color.RED.darker());
            g.drawLine(0, 0, 33, 33);
            g.drawLine(33, 0, 0, 33);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.drawWing(g, 4, 4);
        this.drawWing(g, 20, 4);
        this.drawBody(g, 16, 16);
    }
}

