/*
 * Decompiled with CFR 0.152.
 */
package GUIModule.AnimatedIcons;

import GUIModule.ColorGradient;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class SpinningLEDIcon
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int RADIUS = 16;
    private static Color[] GRAYSCALES = new Color[256];
    private static Color[] RAINBOWS = new Color[256];
    private static final int LED_COUNT = 16;
    private static final int[] LED_PXS = new int[16];
    private static final int[] LED_PYS = new int[16];
    private static final int[] LED_QXS = new int[16];
    private static final int[] LED_QYS = new int[16];
    private long highlightInitTime;
    private int highlightLevel = 0;
    private boolean isOn;

    private static void loadGlobalVariables() {
        if (GRAYSCALES[0] != null) {
            return;
        }
        ColorGradient rainbowGradient = ColorGradient.getRainbowScheme(16);
        int i = 0;
        while (i < 256) {
            SpinningLEDIcon.GRAYSCALES[i] = new Color(i, i, i);
            SpinningLEDIcon.RAINBOWS[i] = new Color(rainbowGradient.getARGB((double)i / 256.0));
            ++i;
        }
        double multiplier = 0.39269908169872414;
        int rMajor = 15;
        int rMinor = 12;
        int i2 = 0;
        while (i2 < 16) {
            double c = Math.cos((double)i2 * multiplier);
            double s = Math.sin((double)i2 * multiplier);
            SpinningLEDIcon.LED_PXS[i2] = (int)(16.0 + (double)rMajor * c);
            SpinningLEDIcon.LED_PYS[i2] = (int)(16.0 + (double)rMajor * s);
            SpinningLEDIcon.LED_QXS[i2] = (int)(16.0 + (double)rMinor * c);
            SpinningLEDIcon.LED_QYS[i2] = (int)(16.0 + (double)rMinor * s);
            ++i2;
        }
    }

    public SpinningLEDIcon() {
        this.setBackground(Color.DARK_GRAY);
        int diameter = 33;
        this.setPreferredSize(new Dimension(diameter, diameter));
        SpinningLEDIcon.loadGlobalVariables();
    }

    public void flash() {
        this.highlightInitTime = System.currentTimeMillis();
        this.highlightLevel = 16;
    }

    public void setOnOff(boolean value) {
        this.isOn = value;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int i = 0;
        while (i < 16) {
            int d = 2 * i + 1;
            g.setColor(GRAYSCALES[64 - i]);
            g.drawOval(16 - i, 16 - i, d, d);
            ++i;
        }
        g.setColor(Color.GREEN);
        long time = System.currentTimeMillis();
        long shift = time >> 2;
        this.highlightLevel = (int)Math.max(0L, (long)this.highlightLevel - (time - this.highlightInitTime >> 7));
        if (this.highlightLevel > 0) {
            int r = 16 - this.highlightLevel;
            g.setColor(GRAYSCALES[200 - 8 * r]);
            g.drawOval(16 - r, 16 - r, 2 * r + 1, 2 * r + 1);
        }
        g.setColor(Color.DARK_GRAY);
        int i2 = 0;
        while (i2 < 16) {
            int rainbowIndex = 256 * i2 / 16;
            rainbowIndex = (int)((long)rainbowIndex + shift);
            rainbowIndex &= 0xFF;
            if (this.isOn) {
                g.setColor(RAINBOWS[rainbowIndex]);
            }
            g.drawLine(LED_PXS[i2], LED_PYS[i2], LED_QXS[i2], LED_QYS[i2]);
            ++i2;
        }
    }
}

