/*
 * Decompiled with CFR 0.152.
 */
package GUIModule.AnimatedIcons;

import GUIModule.ColorGradient;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JPanel;

public class WiFiIcon
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int RADIUS = 16;
    private static Color[] GRAYSCALES = new Color[256];
    private static Color[] RAINBOWS = new Color[256];
    private static final int LED_COUNT = 32;
    private static final int[] LED_PXS = new int[32];
    private static final int[] LED_PYS = new int[32];
    private static final int[] LED_QXS = new int[32];
    private static final int[] LED_QYS = new int[32];
    private boolean isOn;
    private boolean isStable;
    private static Color DARK_RED = new Color(128, 0, 0);
    private static Color[] GREENS = new Color[]{new Color(0, 165, 0), new Color(0, 195, 0), new Color(0, 225, 0), new Color(0, 255, 0)};
    private static Color[] YELLOWS = new Color[]{new Color(165, 165, 0), new Color(195, 195, 0), new Color(225, 225, 0), new Color(255, 255, 0)};

    private static void loadGlobalVariables() {
        if (GRAYSCALES[0] != null) {
            return;
        }
        ColorGradient rainbowGradient = ColorGradient.getRainbowScheme(16);
        int i = 0;
        while (i < 256) {
            WiFiIcon.GRAYSCALES[i] = new Color(i, i, i);
            WiFiIcon.RAINBOWS[i] = new Color(rainbowGradient.getARGB((double)i / 256.0));
            ++i;
        }
        double multiplier = 0.19634954084936207;
        int rMajor = 15;
        int rMinor = 14;
        int i2 = 0;
        while (i2 < 32) {
            double c = Math.cos((double)i2 * multiplier);
            double s = Math.sin((double)i2 * multiplier);
            WiFiIcon.LED_PXS[i2] = (int)(16.0 + (double)rMajor * c);
            WiFiIcon.LED_PYS[i2] = (int)(16.0 + (double)rMajor * s);
            WiFiIcon.LED_QXS[i2] = (int)(16.0 + (double)rMinor * c);
            WiFiIcon.LED_QYS[i2] = (int)(16.0 + (double)rMinor * s);
            ++i2;
        }
    }

    public WiFiIcon() {
        this.setBackground(Color.DARK_GRAY);
        int diameter = 33;
        this.setPreferredSize(new Dimension(diameter, diameter));
        WiFiIcon.loadGlobalVariables();
    }

    public void setOnOff(boolean value) {
        this.isOn = value;
    }

    public void setConnectionStable(boolean value) {
        this.isStable = value;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Stroke originalStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(3.0f));
        long time = System.currentTimeMillis();
        g.setColor(DARK_RED);
        int i = 0;
        while (i < 4) {
            int sectorRadius = (i + 1) * 16 / 2;
            if (this.isOn) {
                int colorWheelIndex = (int)(((long)i + (time >> 8)) % 4L);
                g.setColor(this.isStable ? GREENS[colorWheelIndex] : YELLOWS[colorWheelIndex]);
            }
            g.drawOval(16 - sectorRadius / 2, 24 - sectorRadius / 2, sectorRadius, sectorRadius);
            ++i;
        }
        g2.setStroke(originalStroke);
        g.setColor(this.getBackground());
        g.fillPolygon(new int[]{16, 32, 32}, new int[]{32, 32, 14}, 3);
        int[] nArray = new int[3];
        nArray[0] = 16;
        g.fillPolygon(nArray, new int[]{32, 32, 14}, 3);
        g.fillRect(0, 30, 32, 8);
        g.fillRect(30, 0, 32, 32);
    }
}

