/*
 * Decompiled with CFR 0.152.
 */
package GUIModule;

import GUIModule.AlternativeColorMatrix;
import Util.UtilMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public abstract class ColorGradient {
    private static final int F = 255;
    private static final boolean ALTERNATIVE_COLOR_SCHEME = false;
    private static ColorGradient singletonRGScheme = new RGScheme();
    private static ColorGradient singletonRYGScheme = new RYGScheme();
    private static final int COLOR_BAR_WIDTH = 30;
    private static final int COLOR_BAR_FONT_SIZE = 16;
    private static final int COLOR_BAR_MARKER_COUNT = 10;
    private static final Font COLOR_BAR_FONT = new Font("ARIAL", 0, 16);

    public abstract int getARGB(double var1);

    public static ColorGradient getRGScheme() {
        return singletonRGScheme;
    }

    public static ColorGradient getRYGScheme() {
        return singletonRYGScheme;
    }

    public static ColorGradient getRainbowScheme(int defaultAlpha) {
        return new RainbowScheme(defaultAlpha);
    }

    public static ColorGradient getSeamlessRainbowScheme() {
        return new SeamlessRainbowScheme();
    }

    private String getColorBarMarkerText(int i, int decimal, double min, double max) {
        double value = UtilMath.map((double)i / 10.0, 0.0, 1.0, min, max);
        String text = String.format(" %." + decimal + "f", value);
        if (i == 0) {
            text = String.valueOf(text) + ">";
        } else if (i == 10) {
            text = String.valueOf(text) + "<";
        }
        return text;
    }

    public void drawColorBar(Graphics g, int x, int y, int h, int decimal, double min, double max) {
        int marginY;
        int i = marginY = 16;
        while (i < h - marginY) {
            int argb = this.getARGB((double)(i - marginY) / (double)(h - 2 * marginY));
            g.setColor(new Color(argb));
            g.fillRect(x, y + h - i - 1, 30, 1);
            ++i;
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y + marginY, 30, h - 2 * marginY);
        g.setColor(Color.WHITE);
        g.setFont(COLOR_BAR_FONT);
        i = 0;
        while (i <= 10) {
            String text = this.getColorBarMarkerText(i, decimal, min, max);
            g.drawString(text, x + 30, y + 8 + h - marginY - i * (h - 2 * marginY) / 10);
            ++i;
        }
    }

    public int computeMaxColorBarTextEndX(int decimal, double min, double max) {
        BufferedImage offscreenImage = new BufferedImage(1, 1, 2);
        Graphics g = offscreenImage.getGraphics();
        g.setFont(COLOR_BAR_FONT);
        int maxTextWidth = 0;
        int i = 0;
        while (i <= 10) {
            String text = this.getColorBarMarkerText(i, decimal, min, max);
            int textWidth = g.getFontMetrics().stringWidth(text);
            if (maxTextWidth < textWidth) {
                maxTextWidth = textWidth;
            }
            ++i;
        }
        return 30 + maxTextWidth;
    }

    private static class AlternativeRainbowScheme
    extends ColorGradient {
        private int defaultAlpha;

        public AlternativeRainbowScheme(int defaultAlpha) {
            this.defaultAlpha = defaultAlpha;
        }

        @Override
        public int getARGB(double intensity) {
            intensity = UtilMath.cap(intensity, 0.0, 1.0);
            int DEFAULT_RGB = this.defaultAlpha << 24;
            int DEFAULT_ALPHA = this.defaultAlpha << 24;
            int argb = DEFAULT_RGB;
            if (intensity >= 0.0) {
                int index = (int)UtilMath.map(intensity, 0.0, 1.0, 0.0, AlternativeColorMatrix.size() - 1);
                int rgb = AlternativeColorMatrix.get(index);
                argb = DEFAULT_ALPHA | (rgb &= 0xFFFFFF);
            }
            return argb;
        }
    }

    private static class RGScheme
    extends ColorGradient {
        private RGScheme() {
        }

        @Override
        public int getARGB(double intensity) {
            int argb = -16777216;
            if (intensity >= 0.0) {
                int x = (int)UtilMath.map(intensity, 0.0, 1.0, 0.0, 255.0);
                argb = 0x40000000 | 255 - x << 16 | x << 8;
            }
            return argb;
        }
    }

    private static class RYGScheme
    extends ColorGradient {
        private RYGScheme() {
        }

        @Override
        public int getARGB(double intensity) {
            int BASE_COUNT = 2;
            int DEFAULT_RGB = -16777216;
            int DEFAULT_ALPHA = 0x40000000;
            int argb = DEFAULT_RGB;
            int r = 0;
            int g = 0;
            int b = 0;
            if (intensity >= 0.0) {
                int x = (int)UtilMath.map(intensity, 0.0, 1.0, 0.0, 255 * BASE_COUNT);
                int k = x / 255;
                int z = x - 255 * k;
                int w = 255 - z;
                argb = DEFAULT_ALPHA;
                switch (k) {
                    case 0: {
                        r = 255;
                        g = z;
                        b = 0;
                        break;
                    }
                    case 1: {
                        r = w;
                        g = 255;
                        b = 0;
                        break;
                    }
                    case 2: {
                        g = 255;
                    }
                }
                argb |= r << 16 | g << 8 | b;
            }
            return argb;
        }
    }

    private static class RainbowScheme
    extends ColorGradient {
        private int defaultAlpha;

        public RainbowScheme(int defaultAlpha) {
            this.defaultAlpha = defaultAlpha;
        }

        @Override
        public int getARGB(double intensity) {
            intensity = UtilMath.cap(intensity, 0.0, 1.0);
            int BASE_COUNT = 5;
            int DEFAULT_RGB = this.defaultAlpha << 24;
            int DEFAULT_ALPHA = this.defaultAlpha << 24;
            int argb = DEFAULT_RGB;
            int r = 0;
            int g = 0;
            int b = 0;
            if (intensity >= 0.0) {
                int x = (int)UtilMath.map(intensity, 0.0, 1.0, 0.0, 255 * BASE_COUNT);
                int k = x / 255;
                int z = x - 255 * k;
                int w = 255 - z;
                argb = DEFAULT_ALPHA;
                switch (k) {
                    case 0: {
                        r = 255;
                        g = z;
                        b = 0;
                        break;
                    }
                    case 1: {
                        r = w;
                        g = 255;
                        b = 0;
                        break;
                    }
                    case 2: {
                        r = 0;
                        g = 255;
                        b = z;
                        break;
                    }
                    case 3: {
                        r = 0;
                        g = w;
                        b = 255;
                        break;
                    }
                    case 4: {
                        r = z;
                        g = 0;
                        b = 255;
                        break;
                    }
                    case 5: {
                        r = 255;
                        g = 0;
                        b = 255;
                    }
                }
                argb |= r << 16 | g << 8 | b;
            }
            return argb;
        }
    }

    private static class SeamlessRainbowScheme
    extends ColorGradient {
        private SeamlessRainbowScheme() {
        }

        @Override
        public int getARGB(double intensity) {
            intensity = UtilMath.cap(intensity, 0.0, 1.0);
            int BASE_COUNT = 6;
            int DEFAULT_RGB = -16777216;
            int DEFAULT_ALPHA = -16777216;
            int argb = DEFAULT_RGB;
            int r = 0;
            int g = 0;
            int b = 0;
            if (intensity >= 0.0) {
                int x = (int)UtilMath.map(intensity, 0.0, 1.0, 0.0, 255 * BASE_COUNT - 1);
                int k = x / 255;
                int z = x - 255 * k;
                int w = 255 - z;
                argb = DEFAULT_ALPHA;
                switch (k) {
                    case 0: {
                        r = 255;
                        g = z;
                        b = 0;
                        break;
                    }
                    case 1: {
                        r = w;
                        g = 255;
                        b = 0;
                        break;
                    }
                    case 2: {
                        r = 0;
                        g = 255;
                        b = z;
                        break;
                    }
                    case 3: {
                        r = 0;
                        g = w;
                        b = 255;
                        break;
                    }
                    case 4: {
                        r = z;
                        g = 0;
                        b = 255;
                        break;
                    }
                    case 5: {
                        r = 255;
                        g = 0;
                        b = w;
                    }
                }
                argb |= r << 16 | g << 8 | b;
            }
            return argb;
        }
    }
}

