/*
 * Decompiled with CFR 0.152.
 */
package GUIModule.DynamicTable;

import GUIModule.DynamicTable.DynamicTableEntry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class DynamicTable<T extends DynamicTableEntry>
extends JTable
implements Iterable<T> {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel model = new DefaultTableModel();
    private List<T> list = new ArrayList<T>();

    public DynamicTable() {
        this.setModel(this.model);
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.getTableHeader().setBackground(Color.DARK_GRAY);
        this.getTableHeader().setForeground(Color.WHITE);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void addColumn(String name) {
        this.model.addColumn(name);
    }

    public void addColumns(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addColumn(name);
            ++n2;
        }
    }

    public void addRow(T t) {
        this.list.add(t);
        this.model.addRow(t.toArray());
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public List<T> getListBuffer() {
        return this.list;
    }

    public void clear() {
        this.model.setRowCount(0);
        this.list.clear();
    }

    public Set<Integer> getSelectedIndices() {
        HashSet<Integer> set = new HashSet<Integer>();
        int[] nArray = this.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            set.add(index);
            ++n2;
        }
        return set;
    }

    public void removeSelectedIndices() {
        Set<Integer> set = this.getSelectedIndices();
        ArrayList<T> newList = new ArrayList<T>();
        int n = this.list.size();
        int i = 0;
        while (i < n) {
            if (!set.contains(i)) {
                newList.add((DynamicTableEntry)this.list.get(i));
            }
            ++i;
        }
        int[] rows = this.getSelectedRows();
        int i2 = rows.length - 1;
        while (i2 >= 0) {
            this.model.removeRow(rows[i2]);
            --i2;
        }
        this.list = newList;
    }

    public void scrollToBottom() {
        int lastRow = this.getModel().getRowCount() - 1;
        this.scrollRectToVisible(this.getCellRect(lastRow, 0, true));
    }
}

