/*
 * Decompiled with CFR 0.152.
 */
package Graphing;

import Data.XY;
import Graphing.GraphIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GraphVector
extends GraphIterable {
    private List<XY> values = new ArrayList<XY>();
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;

    public String toString() {
        return String.format("GraphVector[title=%s,size=%d]", this.getTitle(), this.size());
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public void add(XY xy) {
        int n = this.size();
        double x = xy.getX();
        double y = xy.getY();
        this.xMin = x < this.xMin || n == 0 ? x : this.xMin;
        this.yMin = y < this.yMin || n == 0 ? y : this.yMin;
        this.xMax = x > this.xMax || n == 0 ? x : this.xMax;
        this.yMax = y > this.yMax || n == 0 ? y : this.yMax;
        this.values.add(xy);
    }

    @Override
    public void clear() {
        this.values.clear();
        this.yMax = 0.0;
        this.xMax = 0.0;
        this.yMin = 0.0;
        this.xMin = 0.0;
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getYMin() {
        return this.yMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    public double getYMax() {
        return this.yMax;
    }

    public XY get(int index) {
        return this.values.get(index);
    }

    @Override
    public Iterator<XY> iterator() {
        return this.values.iterator();
    }
}

