/*
 * Decompiled with CFR 0.152.
 */
package Loader;

import Data.XY;
import Map.WebMercatorConverter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class CSVLoader {
    private static int COL_OFFSET_INDEX = 0;
    private static int COL_OFFSET_POSITION_X = 1;
    private static int COL_OFFSET_POSITION_Y = 2;
    private static int COL_OFFSET_LATITUDE = 5;
    private static int COL_OFFSET_LONGITUDE = 6;
    private static int COL_OFFSET_DATA = 8;
    private Map<Long, XY> coordinates = new LinkedHashMap<Long, XY>();
    private Map<String, Map<Long, Double>> measurements = new LinkedHashMap<String, Map<Long, Double>>();

    private CSVLoader(Map<Long, XY> coordinates, Map<String, Map<Long, Double>> measurements) {
        this.coordinates = coordinates;
        this.measurements = measurements;
    }

    private static double[] extractMapGPSInfo(File mapImageFile) {
        int separatorIndex;
        String name;
        block4: {
            name = mapImageFile.getName();
            separatorIndex = name.lastIndexOf("$");
            if (separatorIndex != -1) break block4;
            return null;
        }
        try {
            int extensionIndex = name.lastIndexOf(".");
            name = name.substring(separatorIndex + 1, extensionIndex);
            String[] fields = name.split(",");
            double[] values = new double[4];
            int i = 0;
            while (i < 4) {
                values[i] = Double.parseDouble(fields[i].trim());
                ++i;
            }
            return values;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static CSVLoader load(File csvFile, File mapImageFile) throws IOException {
        System.out.println("<LOADING FROM CSV>");
        BufferedImage mapImage = ImageIO.read(mapImageFile);
        int mapWidth = mapImage.getWidth();
        int mapHeight = mapImage.getHeight();
        double[] gpsInfo = CSVLoader.extractMapGPSInfo(mapImageFile);
        WebMercatorConverter mercatorConverter = null;
        if (gpsInfo != null) {
            mercatorConverter = new WebMercatorConverter(gpsInfo[0], gpsInfo[1], gpsInfo[2], gpsInfo[3]);
        }
        LinkedHashMap<Long, XY> coordinates = new LinkedHashMap<Long, XY>();
        LinkedHashMap<String, Map<Long, Double>> measurements = new LinkedHashMap<String, Map<Long, Double>>();
        Iterator<String> lines = Files.readAllLines(csvFile.toPath()).iterator();
        String[] headerFields = lines.next().split(",");
        int colCount = headerFields.length;
        int dataKeyCount = colCount - COL_OFFSET_DATA;
        String[] dataKeys = new String[dataKeyCount];
        int i = 0;
        while (i < dataKeyCount) {
            String dataKey;
            dataKeys[i] = dataKey = headerFields[i + COL_OFFSET_DATA].trim();
            measurements.put(dataKey, new LinkedHashMap());
            ++i;
        }
        while (lines.hasNext()) {
            String line = lines.next().trim();
            System.out.println(line);
            if (line.isEmpty()) continue;
            String[] fields = line.split(",", -1);
            System.out.println(line);
            long index = Long.parseLong(fields[COL_OFFSET_INDEX]);
            double x = -1.0;
            double y = -1.0;
            boolean xySetViaGPS = false;
            if (gpsInfo != null) {
                String latString = fields[COL_OFFSET_LATITUDE].trim();
                String lonString = fields[COL_OFFSET_LONGITUDE].trim();
                if (!latString.isEmpty() && !lonString.isEmpty()) {
                    double lat = Double.parseDouble(latString);
                    double lon = Double.parseDouble(lonString);
                    x = mercatorConverter.getRatioX(lon) * (double)mapWidth;
                    y = mercatorConverter.getRatioY(lat) * (double)mapHeight;
                    xySetViaGPS = true;
                    System.out.println("GPS Coordinate Available");
                }
            }
            if (!xySetViaGPS) {
                x = Long.parseLong(fields[COL_OFFSET_POSITION_X]);
                y = Long.parseLong(fields[COL_OFFSET_POSITION_Y]);
            }
            XY xy = new XY(x, y);
            coordinates.put(index, xy);
            int i2 = 0;
            while (i2 < dataKeyCount) {
                try {
                    String dataKey = headerFields[i2 + COL_OFFSET_DATA].trim();
                    String valueString = fields[i2 + COL_OFFSET_DATA].trim();
                    if (!valueString.isEmpty()) {
                        double value = Double.parseDouble(valueString);
                        ((Map)measurements.get(dataKey)).put(index, value);
                    }
                }
                catch (Exception e) {
                    System.err.println("[LINE PARSE ERROR] " + line);
                }
                ++i2;
            }
        }
        return new CSVLoader(coordinates, measurements);
    }

    public Map<Long, XY> getCoordinates() {
        return this.coordinates;
    }

    public Map<String, Map<Long, Double>> getMeasurements() {
        return this.measurements;
    }
}

