/*
 * Decompiled with CFR 0.152.
 */
package Map;

import Config.HeatmapRenderConfig;
import Graphing.GraphPanel;
import Map.GraphMasterPanel;
import Util.UtilSystem;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GraphCascadingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static long MONITORING_INTERVAL_MS = 10000L;
    private Map<String, GraphMasterPanel> graphMasterPanels = new LinkedHashMap<String, GraphMasterPanel>();
    private Map<String, HeatmapRenderConfig> renderConfigs = new LinkedHashMap<String, HeatmapRenderConfig>();

    public GraphCascadingPanel() {
        this.setBackground(Color.DARK_GRAY);
        this.startRealTimeUpdateThread();
        this.setLayout(new BoxLayout(this, 1));
    }

    private void startRealTimeUpdateThread() {
        new Thread(() -> {
            while (true) {
                SwingUtilities.invokeLater(() -> {
                    for (String key : this.graphMasterPanels.keySet()) {
                        this.updateTimeShift(key);
                    }
                });
                UtilSystem.sleep(16);
            }
        }).start();
    }

    private void refreshConfig(String name) {
        HeatmapRenderConfig config = this.renderConfigs.get(name);
        double scaledDataMin = 0.0;
        double scaledDataMax = 1.0;
        double dataScale = config.getDataScale();
        scaledDataMin = dataScale * config.getDataMin();
        scaledDataMax = dataScale * config.getDataMax();
        String barValueFormat = "%." + config.getDecimal() + "f";
        GraphMasterPanel graphMasterPanel = this.graphMasterPanels.get(name);
        graphMasterPanel.setValueFormat(barValueFormat);
        graphMasterPanel.setScaledDataMinMaxWithScale(scaledDataMin, scaledDataMax, dataScale);
        graphMasterPanel.repaint();
    }

    private void updateTimeShift(String name) {
        long timeEnd = System.currentTimeMillis();
        long timeStart = timeEnd - MONITORING_INTERVAL_MS;
        GraphMasterPanel graphMasterPanel = this.graphMasterPanels.get(name);
        GraphPanel graphPanel = graphMasterPanel.getGraphPanel();
        graphPanel.setPlotMinMaxX(timeStart, timeEnd);
        graphMasterPanel.repaint();
    }

    public void addGraphMasterPanel(String name) {
        if (this.graphMasterPanels.containsKey(name)) {
            return;
        }
        for (GraphMasterPanel panel : this.graphMasterPanels.values()) {
            this.remove(panel);
        }
        GraphMasterPanel graphMasterPanel = new GraphMasterPanel(name);
        this.graphMasterPanels.put(name, graphMasterPanel);
        this.setLayout(new GridLayout(this.graphMasterPanels.size(), 1));
        for (GraphMasterPanel panel : this.graphMasterPanels.values()) {
            this.add(panel);
        }
        this.revalidate();
        this.repaint();
    }

    public void addData(String name, double value) {
        GraphMasterPanel graphMasterPanel = this.graphMasterPanels.get(name);
        HeatmapRenderConfig config = this.renderConfigs.get(name);
        double dataScale = config.getDataScale();
        double scaledValue = dataScale * value;
        graphMasterPanel.addValue(scaledValue);
    }

    public void setGraphConfig(String name, HeatmapRenderConfig config) {
        this.renderConfigs.put(name, config);
        this.graphMasterPanels.get(name).clear();
        this.refreshConfig(name);
    }
}

