/*
 * Decompiled with CFR 0.152.
 */
package Map;

import GUIModule.GUIFactory;
import Graphing.GraphIterables;
import Graphing.GraphPanel;
import Graphing.GraphQueue;
import Map.BarPanel;
import Util.UtilSwing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GraphMasterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final String title;
    private JPanel topPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel titlePanel = GUIFactory.makePanel(new GridBagLayout());
    private JLabel titleLabel = GUIFactory.makeLabel();
    private JPanel valuePanel = GUIFactory.makePanel(new FlowLayout(0));
    private JTextField valueField = GUIFactory.makeTextField(8);
    private GraphPanel graphPanel = new GraphPanel();
    private BarPanel barPanel = new BarPanel();
    private GraphIterables graphIterables = new GraphIterables();
    private GraphQueue graphQueue = new GraphQueue();
    private String valueFormat = "%.0f";

    public GraphMasterPanel(String title) {
        this.title = title;
        this.setBackground(Color.BLACK);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 1));
        this.titleLabel.setText(title);
        this.titleLabel.setFont(new Font("ARIAL", 1, 14));
        this.valueField.setEditable(false);
        this.graphIterables.add(this.graphQueue);
        this.graphPanel.setIterables(this.graphIterables);
        this.topPanel.add((Component)UtilSwing.add(this.titlePanel, this.titleLabel), "Center");
        this.topPanel.add((Component)UtilSwing.add(this.valuePanel, this.valueField), "East");
        this.add((Component)this.topPanel, "North");
        this.add((Component)this.graphPanel, "Center");
        this.add((Component)this.barPanel, "East");
    }

    public void clear() {
        this.barPanel.clear();
        this.valueField.setText("");
        this.graphQueue.clear();
    }

    public void addValue(double value) {
        this.graphQueue.add(System.currentTimeMillis(), value);
        this.barPanel.setValue(value);
        this.valueField.setText(String.format(this.valueFormat, value));
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public void setValueFormat(String format) {
        this.valueFormat = format;
        this.graphPanel.setPlotBarFormat(format);
    }

    public void setScaledDataMinMaxWithScale(double scaledMin, double scaledMax, double dataScale) {
        this.graphPanel.setPlotMinMaxY(scaledMin, scaledMax);
        this.titleLabel.setText(String.valueOf(this.title) + (dataScale == 1.0 ? "" : String.format("(x%s)", dataScale)));
        this.barPanel.setMinMax(scaledMin, scaledMax);
    }
}

