/*
 * Decompiled with CFR 0.152.
 */
package Map;

import Config.HeatmapRenderConfig;
import GUIModule.ColorGradient;
import GUIModule.DynamicTable.DynamicTable;
import Map.ColorBarPanel;
import Map.GraphCascadingPanel;
import Map.MapConfigChangeObserver;
import Map.MapConfigPanel;
import Map.SatelliteMap;
import Map.SatelliteMapPanel;
import Map.SpatialMeasurementNode;
import Util.UtilSwing;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SatelliteMapMasterPanel
extends JPanel
implements MapConfigChangeObserver {
    private static final long serialVersionUID = 1L;
    private GraphCascadingPanel cascadingPanel;
    private String key;
    private JPanel leftPanel = new JPanel(new BorderLayout());
    private ColorBarPanel colorBarPanel = new ColorBarPanel();
    private MapConfigPanel configPanel;
    private SatelliteMapPanel satelliteMapPanel;

    public SatelliteMapMasterPanel(GraphCascadingPanel cascadingPanel, SatelliteMap map, DynamicTable<SpatialMeasurementNode> nodes, String key) {
        this(cascadingPanel, map, nodes, key, true);
    }

    public SatelliteMapMasterPanel(GraphCascadingPanel cascadingPanel, SatelliteMap map, DynamicTable<SpatialMeasurementNode> nodes, String key, boolean addLeftPanel) {
        this.cascadingPanel = cascadingPanel;
        this.key = key;
        this.satelliteMapPanel = new SatelliteMapPanel(map, nodes, key);
        this.configPanel = new MapConfigPanel(key, this);
        this.setLayout(new BorderLayout());
        if (addLeftPanel) {
            this.leftPanel.add((Component)this.colorBarPanel, "Center");
            this.leftPanel.add((Component)this.configPanel, "South");
            this.add((Component)new JScrollPane(this.leftPanel), "West");
        }
        this.add((Component)this.satelliteMapPanel, "Center");
        UtilSwing.setBorder(this.colorBarPanel, "COLOR BAR");
    }

    @Override
    public String toString() {
        return String.format("SatelliteMapMasterPanel[key=%s]", this.key);
    }

    public SatelliteMapPanel getSatelliteMapPanel() {
        return this.satelliteMapPanel;
    }

    @Override
    public void configChanged(String name, HeatmapRenderConfig config) {
        this.satelliteMapPanel.setDecimal(config.getDecimal());
        this.satelliteMapPanel.setDataMinMax(config.getDataMin(), config.getDataMax(), config.getDataScale());
        this.satelliteMapPanel.setValuePlot(config.getValuePlotEnabled());
        this.colorBarPanel.setColorGradient(ColorGradient.getRainbowScheme(0), config.getDataMin(), config.getDataMax(), config.getDataScale(), config.getDecimal());
        if (this.cascadingPanel != null) {
            this.cascadingPanel.setGraphConfig(name, config);
        }
        this.repaint();
    }

    public MapConfigPanel getConfigPanel() {
        return this.configPanel;
    }
}

