/*
 * Decompiled with CFR 0.152.
 */
package Map;

import GUIModule.ColorGradient;
import GUIModule.DynamicTable.DynamicTable;
import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import Map.Marker;
import Map.SatelliteMap;
import Map.SpatialMeasurementNode;
import Util.UtilMath;
import Util.UtilString;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SatelliteMapPanel
extends ZoomableImagePanel {
    private static final long serialVersionUID = 1L;
    private double dataMin = 0.0;
    private double dataMax = 100.0;
    private double dataScale = 1.0;
    private boolean valuePlot;
    private int decimalPoint;
    private SatelliteMap map;
    private ColorGradient colorGradient = ColorGradient.getRainbowScheme(128);
    private DynamicTable<SpatialMeasurementNode> table;
    private String key;
    private boolean enableDrawingFromTable = true;
    private Marker apMarker;
    private List<Marker> staMarkers = new ArrayList<Marker>();

    public SatelliteMapPanel(SatelliteMap satelliteMap, DynamicTable<SpatialMeasurementNode> table, String key) {
        this.map = satelliteMap;
        this.table = table;
        this.key = key;
        this.setImage(this.map.getImage());
        this.setBackground(Color.BLACK);
    }

    public void setAPMarker(Marker marker) {
        this.apMarker = marker;
    }

    public void addSTAMarker(Marker marker) {
        this.staMarkers.add(marker);
    }

    public void setDataMinMax(double dataMin, double dataMax, double dataScale) {
        this.dataMin = dataMin;
        this.dataMax = dataMax;
        this.dataScale = dataScale;
    }

    public void setDrawingFromTableEnabled(boolean value) {
        this.enableDrawingFromTable = value;
    }

    private void drawNodesFromTable(Graphics g, int mapWidth, int mapHeight) {
        int radius = (int)Math.round(5.0 / this.getZoom());
        int markerDiameter = 2 * radius + 1;
        Font font = new Font("ARIAL", 0, (int)Math.round(20.0 / this.getZoom()));
        Set<Integer> selectedIndices = this.table.getSelectedIndices();
        int index = 0;
        for (SpatialMeasurementNode node : this.table) {
            boolean selected = selectedIndices.contains(index);
            ++index;
            if (!node.has(this.key)) continue;
            double value = node.get(this.key);
            int nodeX = (int)((double)mapWidth * node.ratioX);
            int nodeY = (int)((double)mapHeight * node.ratioY);
            double intensity = UtilMath.map(value, this.dataMin, this.dataMax, 0.0, 1.0);
            g.setColor(new Color(this.colorGradient.getARGB(intensity)));
            g.fillRect(nodeX - radius, nodeY - radius, markerDiameter, markerDiameter);
            if (!this.valuePlot) continue;
            g.setColor(selected ? Color.MAGENTA : Color.BLACK);
            g.setFont(font);
            String text = String.format("%." + this.decimalPoint + "f", this.dataScale * value);
            g.drawString(text, nodeX -= g.getFontMetrics().stringWidth(text) / 2, nodeY += g.getFont().getSize());
        }
    }

    private void drawMarker(Graphics g, Marker marker) {
        String text;
        if (!marker.isEnabled()) {
            return;
        }
        int markerX = marker.getPixelX();
        int markerY = marker.getPixelY();
        this.drawCrossHair(g, markerX, markerY, marker.getColor());
        if (marker.isSelected()) {
            int r = 12;
            int d = 2 * r + 1;
            g.setColor(Color.BLACK);
            g.drawOval(markerX - r, markerY - r, d, d);
            g.setColor(Color.WHITE);
            g.drawOval(markerX - --r, markerY - r, d -= 2, d);
            g.setColor(Color.BLACK);
            g.drawOval(markerX - --r, markerY - r, d -= 2, d);
        }
        if (marker.isLocationUnsure()) {
            int invalidFontSize = 20;
            Font invalidFont = new Font("Monospaced", 0, invalidFontSize);
            g.setFont(invalidFont.deriveFont(1));
            g.setColor(Color.BLACK);
            int invalidX = markerX - g.getFontMetrics().stringWidth("?") / 2;
            int invalidY = markerY - invalidFontSize;
            g.drawString("?", invalidX, invalidY);
            g.setFont(invalidFont);
            g.setColor(Color.WHITE);
            g.drawString("?", invalidX, invalidY);
        }
        if (!(text = marker.getText()).isEmpty()) {
            int textFontSize = (int)Math.round(16.0 / this.getZoom());
            Font textFont = new Font("Monospaced", 0, textFontSize);
            g.setFont(textFont);
            String[] lines = text.split("\n");
            int maxLengthIndex = UtilString.maxLengthIndex(lines);
            int boxWidth = g.getFontMetrics().stringWidth(lines[maxLengthIndex]);
            int boxHeight = lines.length * textFontSize;
            int boxX = markerX + 10;
            int boxY = markerY;
            g.setColor(new Color(0, 0, 0, marker.isSelected() ? 175 : 100));
            g.fillRect(boxX, boxY, boxWidth, boxHeight);
            g.setColor(g.getColor().darker());
            g.fillRect(boxX, boxY, boxWidth, textFontSize);
            int n = lines.length;
            g.setColor(Color.WHITE);
            int i = 0;
            while (i < n) {
                String line = lines[i];
                g.setFont(i == 0 ? textFont.deriveFont(1) : textFont);
                g.drawString(line, boxX, boxY += textFontSize);
                ++i;
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Image mapImage = this.getImage();
        int mapWidth = mapImage.getWidth(null);
        int mapHeight = mapImage.getHeight(null);
        if (this.enableDrawingFromTable) {
            this.drawNodesFromTable(g, mapWidth, mapHeight);
        }
        for (Marker marker : this.staMarkers) {
            this.drawMarker(g, marker);
        }
        if (this.apMarker != null) {
            this.drawMarker(g, this.apMarker);
        }
        for (Marker marker : this.staMarkers) {
            if (!marker.isSelected()) continue;
            this.drawMarker(g, marker);
        }
    }

    private void drawCrossHair(Graphics g, int x, int y, Color color) {
        int crossHairRadius = 10;
        int crossHairDiameter = crossHairRadius * 2 + 1;
        g.setColor(Color.WHITE);
        g.drawRect(x - crossHairRadius, y - 1, crossHairDiameter, 3);
        g.drawRect(x - 1, y - crossHairRadius, 3, crossHairDiameter);
        g.setColor(color);
        g.drawRect(x - --crossHairRadius, y, crossHairDiameter -= 2, 1);
        g.drawRect(x, y - crossHairRadius, 1, crossHairDiameter);
    }

    public void setValuePlot(boolean valuePlot) {
        this.valuePlot = valuePlot;
    }

    public void setDecimal(int decimalPoint) {
        this.decimalPoint = decimalPoint;
    }

    public void centerAtAPCoordinate() {
        if (this.apMarker.isEnabled()) {
            this.centerAt(this.apMarker.getPixelX(), this.apMarker.getPixelY());
        }
    }
}

