/*
 * Decompiled with CFR 0.152.
 */
package Map;

public class WebMercator {
    private static final double PI = Math.PI;
    private static final double NRSC_TO_GEOLOC = Math.PI * 2;
    private static final double GEOLOC_TO_NRSC = 0.15915494309189535;
    private static final double DEG_TO_RAD = Math.PI / 180;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final double EARTH_RADIUS_IN_METERS = 6371000.0;

    public static double distanceInMeter(double phi1, double psi1, double phi2, double psi2) {
        double deltaPhi = (phi2 *= Math.PI / 180) - (phi1 *= Math.PI / 180);
        double deltaPsi = (psi2 *= Math.PI / 180) - (psi1 *= Math.PI / 180);
        double p = Math.sin(deltaPhi / 2.0);
        double q = Math.sin(deltaPsi / 2.0);
        double a = p * p + Math.cos(phi1) * Math.cos(phi2) * q * q;
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return 6371000.0 * c;
    }

    public static double psiToNormalizedResourceX(double psi) {
        return 0.15915494309189535 * (Math.PI / 180 * psi + Math.PI);
    }

    public static double phiToNormalizedResourceY(double phi) {
        return 0.15915494309189535 * (Math.PI - Math.log(Math.tan(0.7853981633974483 + Math.PI / 180 * phi / 2.0)));
    }

    public static double normalizedResourceXToPsi(double normalizedResourceX) {
        return 57.29577951308232 * (normalizedResourceX * (Math.PI * 2) - Math.PI);
    }

    public static double normalizedResourceYToPhi(double normalizedResourceY) {
        return 114.59155902616465 * (Math.atan(Math.exp(Math.PI - normalizedResourceY * (Math.PI * 2))) - 0.7853981633974483);
    }
}

