/*
 * Decompiled with CFR 0.152.
 */
package Server.STA.NRC5292Modem;

import Main.Encryption;
import Server.STA.NRC5292Modem.SWiSSSTAServerConfig;
import Server.STA.NRC5292Modem.Serial;
import Server._Common.Client;
import Server._Common.GPSData;
import Server._Common.MeasurementData;
import Server._Common.TCPServer;
import Util.UtilSystem;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SWiSSSTAServer
extends TCPServer {
    private SWiSSSTAServerConfig config;
    private GPSData gps;
    private Map<String, MeasurementData> measurements = new LinkedHashMap<String, MeasurementData>();
    private Serial dut;
    private int payloadSize;
    private int packetCount;
    private int txpwr;

    public SWiSSSTAServer(SWiSSSTAServerConfig config) {
        super(config.getServerPort());
        this.config = config;
    }

    private synchronized void setGPSData(GPSData gps) {
        this.gps = gps;
    }

    private synchronized GPSData getGPSData() {
        return this.gps;
    }

    private synchronized void addMeasurementData(MeasurementData measurement) {
        this.measurements.put(measurement.getName(), measurement);
    }

    private Thread updateAsynchronouslyForever(Runnable runnable) {
        return UtilSystem.startThread(() -> {
            while (true) {
                try {
                    while (true) {
                        runnable.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UtilSystem.sleep(1000);
                    continue;
                }
                break;
            }
        });
    }

    private void updateRate(MeasurementData rssiData, MeasurementData snrData, MeasurementData rateData) {
        try {
            int[] nArray = new int[9];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 3;
            nArray[4] = 4;
            nArray[5] = 5;
            nArray[6] = 6;
            nArray[7] = 7;
            nArray[8] = 10;
            int[] v = nArray;
            StringBuffer s = new StringBuffer();
            ArrayList<Integer> rates = new ArrayList<Integer>();
            int[] nArray2 = v;
            int n = v.length;
            int n2 = 0;
            while (n2 < n) {
                int mcs = nArray2[n2];
                if (mcs != 10 || this.config.getBandwidth() == 1) {
                    char c;
                    this.dut.query("set packet mcs %d", mcs);
                    s.setLength(0);
                    this.dut.write('%');
                    long timeInit = System.currentTimeMillis();
                    long timeEnd = 0L;
                    do {
                        c = (char)this.dut.readBlocking();
                        s.append(c);
                        System.out.print(c);
                    } while (!s.toString().endsWith("Done"));
                    timeEnd = System.currentTimeMillis();
                    while (this.dut.availableBytesExist()) {
                        c = (char)this.dut.readBlocking();
                        s.append(c);
                        System.out.print(c);
                    }
                    String[] lines = s.toString().trim().split("\n");
                    String line = lines[lines.length - 1];
                    String[] fields = line.substring(line.indexOf("=") + 1).trim().split("\\s+");
                    int successCount = Integer.parseInt(fields[0]);
                    double bps = 8000.0 * (double)this.payloadSize * (double)successCount / (double)(timeEnd - timeInit);
                    rates.add((int)bps);
                }
                ++n2;
            }
            int rateMax = 0;
            Iterator iterator = rates.iterator();
            while (iterator.hasNext()) {
                int rate = (Integer)iterator.next();
                if (rateMax >= rate) continue;
                rateMax = rate;
            }
            String rxStatsLine = this.dut.query("show mac simple_rx", new Object[0]).split("\n")[1];
            String[] rxStatsFields = rxStatsLine.split("\\s+");
            int rssi = Integer.parseInt(rxStatsFields[1]);
            int snr = Integer.parseInt(rxStatsFields[11]);
            rssiData.update(rssi);
            snrData.update(snr);
            rateData.update(rateMax);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeDUT() {
        this.payloadSize = 1500;
        this.packetCount = 50 * this.config.getBandwidth();
        this.txpwr = 3;
        this.dut = new Serial();
        this.dut.connect(this.config.getDUTSerialPort());
        try {
            this.dut.query("", new Object[0]);
            String args = null;
            switch (this.config.getBandwidth()) {
                case 1: {
                    args = "1m 1m 1";
                    break;
                }
                case 2: {
                    args = "2m 2m 0";
                    break;
                }
                case 4: {
                    args = "4m 4m 1";
                    break;
                }
                default: {
                    System.err.println("[ERROR] Invalid Bandwidth");
                    System.exit(1);
                }
            }
            this.dut.query("set packet off", new Object[0]);
            this.dut.query("modem freq_bw_prim %.1f %s", this.config.getFrequency(), args);
            this.dut.query("modem txgain %d", 26 + this.txpwr);
            this.dut.query("set packet length %d", this.payloadSize);
            this.dut.query("set packet count %d", this.packetCount);
            this.dut.query("set packet ack on", new Object[0]);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    public void preStart() {
        if (this.config.gpsEnabled()) {
            this.gps = new GPSData();
            this.setGPSData(this.gps);
            String gpsSerialPort = this.config.gpsSerialPort();
            Serial gpsSerial = new Serial();
            if (!gpsSerial.connect(gpsSerialPort)) {
                System.err.println("[ERROR] Could not connect to the GPS device.");
                System.exit(1);
            }
            gpsSerial.getSerialPort().setComPortTimeouts(65536, 256, 4096);
            this.updateAsynchronouslyForever(() -> GPSData.updateGPS(gpsSerial.getSerialPort(), this.gps));
        }
        this.initializeDUT();
        MeasurementData rssiData = new MeasurementData("RSSI[dBm]", -90.0, -30.0, 1.0, 0);
        MeasurementData snrData = new MeasurementData("SNR[dB]", 0.0, 35.0, 1.0, 0);
        MeasurementData rateData = new MeasurementData("RATE[bps]", 0.0, (double)this.config.getBandwidth() * 2500000.0, 1.0, 0);
        this.addMeasurementData(rssiData);
        this.addMeasurementData(snrData);
        this.addMeasurementData(rateData);
        this.updateAsynchronouslyForever(() -> this.updateRate(rssiData, snrData, rateData));
    }

    @Override
    public void handleClientRequest(Client client, String address) {
        try {
            String command = client.readLine();
            command = Encryption.decodeLine(command);
            System.out.printf("[COMMAND(%s)] %s\n", address, command);
            JsonObject res = new JsonObject();
            switch (command) {
                case "HEAD": {
                    res.addProperty("version", "v1.0");
                    res.addProperty("passive_mode", false);
                    JsonObject measurementHead = new JsonObject();
                    for (String key : this.measurements.keySet()) {
                        measurementHead.add(key, this.measurements.get(key).head());
                    }
                    res.add("measurements", measurementHead);
                    break;
                }
                case "GET": {
                    GPSData gpsData = this.getGPSData();
                    if (gpsData != null) {
                        res.add("gps", gpsData.get());
                    }
                    JsonObject measurementGet = new JsonObject();
                    for (String key : this.measurements.keySet()) {
                        measurementGet.add(key, this.measurements.get(key).get());
                    }
                    res.add("measurements", measurementGet);
                    break;
                }
                default: {
                    System.err.printf("[ERROR(%s)] Unknown Command: %s\n", address, command);
                    return;
                }
            }
            String line = res.toString();
            line = Encryption.encodeLine(line);
            client.writeLine(line);
            UtilSystem.sleep(100);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

