/*
 * Decompiled with CFR 0.152.
 */
package Server.STA.NRC5292Modem;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class SWiSSSTAServerConfig {
    private int serverPort;
    private String dutSerialPort;
    private boolean gpsEnabled;
    private String gpsSerialPort;
    private double frequency;
    private int bandwidth;

    public SWiSSSTAServerConfig(File file) throws IOException {
        String text = new String(Files.readAllBytes(file.toPath()));
        JsonObject json = JsonParser.parseString(text).getAsJsonObject();
        for (String key : json.keySet()) {
            System.out.println("KEY=[" + key + "]");
            switch (key) {
                case "SERVER_PORT": {
                    this.serverPort = json.get(key).getAsInt();
                    break;
                }
                case "DUT_SERIAL_PORT": {
                    this.dutSerialPort = json.get(key).getAsString();
                    break;
                }
                case "USE_GPS": {
                    this.gpsEnabled = json.get(key).getAsBoolean();
                    break;
                }
                case "GPS_SERIAL_PORT": {
                    this.gpsSerialPort = json.get(key).getAsString();
                    break;
                }
                case "FREQ": {
                    this.frequency = json.get(key).getAsDouble();
                    break;
                }
                case "BW": {
                    this.bandwidth = json.get(key).getAsInt();
                    break;
                }
                default: {
                    System.err.printf("[ERROR] Unknown STA configuration parameter: %s\n", key);
                }
            }
        }
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getDUTSerialPort() {
        return this.dutSerialPort;
    }

    public boolean gpsEnabled() {
        return this.gpsEnabled;
    }

    public String gpsSerialPort() {
        return this.gpsSerialPort;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public int getBandwidth() {
        return this.bandwidth;
    }
}

