/*
 * Decompiled with CFR 0.152.
 */
package Server._Common;

import Util.UtilSystem;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class Client
implements Closeable {
    private Socket socket;
    private InputStream is;
    private OutputStream os;
    private BufferedReader reader;
    private PrintWriter writer;

    public Client(Socket socket) throws IOException {
        this.socket = socket;
        this.is = socket.getInputStream();
        this.os = socket.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(this.is));
        this.writer = new PrintWriter(this.os, true);
    }

    public Client(String ip, int port) throws UnknownHostException, IOException {
        this(new Socket(ip, port));
    }

    @Override
    public void close() {
        UtilSystem.close(this.socket);
        UtilSystem.close(this.reader);
        UtilSystem.close(this.writer);
    }

    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    public void writeLine(String line) {
        this.writer.println(line);
    }
}

