/*
 * Decompiled with CFR 0.152.
 */
package Server._Common;

import Server._Common.Client;
import Util.UtilSystem;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public abstract class TCPServer {
    private int port;
    private ServerSocket server;

    protected void preStart() {
    }

    protected abstract void handleClientRequest(Client var1, String var2);

    public void handleClientRequestAndClose(Socket socket, String address) {
        block5: {
            Client client = null;
            try {
                try {
                    client = new Client(socket);
                    this.handleClientRequest(client, address);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    UtilSystem.close(client);
                    System.out.printf("[CLOSING] %s\n", address);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                UtilSystem.close(client);
                System.out.printf("[CLOSING] %s\n", address);
                throw throwable;
            }
            UtilSystem.close(client);
            System.out.printf("[CLOSING] %s\n", address);
        }
    }

    public TCPServer(int port) {
        this.port = port;
    }

    public void start() {
        this.preStart();
        try {
            System.out.printf("[LISTENING] %d\n", this.port);
            this.server = new ServerSocket(this.port);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.server.setReuseAddress(true);
        }
        catch (SocketException e) {
            e.printStackTrace();
            UtilSystem.close(this.server);
        }
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    String address = socket.getInetAddress().getHostAddress();
                    System.out.printf("[CONNECTED] %s\n", address);
                    UtilSystem.startThread(() -> this.handleClientRequestAndClose(socket, address));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

