/*
 * Decompiled with CFR 0.152.
 */
package Util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class UtilSwing {
    private static final Color BORDER_COLOR = Color.ORANGE.darker();
    private static final Font BORDER_FONT = new Font("ARIAL", 1, 20);
    private static final Color MINOR_BORDER_COLOR = Color.LIGHT_GRAY;
    private static final Font MINOR_BORDER_FONT = new Font("ARIAL", 0, 16);

    public static Container add(Container container, Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            container.add(component);
            ++n2;
        }
        return container;
    }

    public static void displayErrorMessage(Component parent, String format, Object ... args) {
        String errorMessage = String.format(format, args);
        JOptionPane.showMessageDialog(parent, errorMessage, "Error", -1, null);
    }

    public static void setEditable(boolean value, JTextField ... fields) {
        JTextField[] jTextFieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            JTextField field = jTextFieldArray[n2];
            field.setEditable(value);
            ++n2;
        }
    }

    public static void groupRadioButtons(JRadioButton ... radioButtons) {
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton[] jRadioButtonArray = radioButtons;
        int n = radioButtons.length;
        int n2 = 0;
        while (n2 < n) {
            JRadioButton radioButton = jRadioButtonArray[n2];
            buttonGroup.add(radioButton);
            ++n2;
        }
    }

    public static void setEnabled(boolean value, Component ... components) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.setEnabled(value);
            ++n2;
        }
    }

    public static void setBorder(JComponent component, String title) {
        component.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title, 1, 1, BORDER_FONT, BORDER_COLOR));
    }

    public static void setMinorBorder(JComponent component, String title) {
        component.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), title, 1, 1, MINOR_BORDER_FONT, MINOR_BORDER_COLOR));
    }

    public static void fixPreferredHeight(Component component) {
        Dimension preferredSize = component.getPreferredSize();
        component.setMaximumSize(new Dimension(Integer.MAX_VALUE, preferredSize.height));
    }

    public static <T> T getSelectedItem(JComboBox<T> comboBox) {
        int index = comboBox.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return comboBox.getItemAt(index);
    }
}

