/*
 * Decompiled with CFR 0.152.
 */
package AppSCAN;

import AppSCAN.MeasurementKeyManager;
import AppSCAN.SCANNetwork;
import GUIModule.AnimatedIcons.SpinningLEDIcon;
import GUIModule.AnimatedIcons.WiFiIcon;
import GUIModule.Colors;
import GUIModule.DynamicTable.DynamicTable;
import GUIModule.GUIFactory;
import GUIModule.UIGuideBar.UIGuideBarListener;
import GUIModule.UIGuideBar.UIGuideBarPanel;
import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import GUIModule.ZoomableImageModule.ZoomableImageUIObserver;
import Main.AboutPanel;
import Main.GlobalAnimationThread;
import Map.MapScaleMasterPanel;
import Map.MapScalePanel;
import Map.Marker;
import Map.NodeState;
import Map.SatelliteMap;
import Map.SatelliteMapMasterPanel;
import Map.SatelliteMapPanel;
import Map.SpatialMeasurementNode;
import Map.WebMercator;
import Map.WebMercatorConverter;
import Sound.Sound;
import Util.UtilDate;
import Util.UtilString;
import Util.UtilSwing;
import Util.UtilTime;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public class MainSCAN
extends JFrame
implements ZoomableImageUIObserver,
UIGuideBarListener {
    private static final long serialVersionUID = 1L;
    private AboutPanel aboutPanel = new AboutPanel();
    private SatelliteMap map;
    private WebMercatorConverter mercatorConverter;
    private JPanel openPathPanel = new JPanel(new FlowLayout(1));
    private JLabel openPathLabel = new JLabel();
    private SatelliteMapMasterPanel satelliteMapMasterPanel = null;
    private JPanel rightPanel = GUIFactory.makeCascadingPanel();
    private JScrollPane rightPane = new JScrollPane(this.rightPanel);
    private JPanel serverPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel serverTopPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JTextField serverIPField = GUIFactory.makeTextField(12);
    private JLabel serverColonLabel = GUIFactory.makeLabel(":");
    private JTextField serverPortField = GUIFactory.makeTextField(5);
    private JPanel serverCenterPanel = GUIFactory.makePanel(new FlowLayout(0));
    private WiFiIcon serverWiFiIcon = new WiFiIcon();
    private JButton serverConnectButton = GUIFactory.makeButton("Connect");
    private JButton serverStatusButton = GUIFactory.makeButton("Status");
    private JPanel loggingPanel = GUIFactory.makePanel(new FlowLayout(0));
    private SpinningLEDIcon loggingIcon = new SpinningLEDIcon();
    private JRadioButton loggingOnButton = GUIFactory.makeRadioButton("On");
    private JRadioButton loggingOffButton = GUIFactory.makeRadioButton("Off");
    private JPanel locationPanel = GUIFactory.makeCascadingPanel();
    private JPanel locationMapScalePanel = GUIFactory.makeCascadingPanel();
    private JPanel locationMapScaleLabelPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JLabel locationMapScaleLabel = GUIFactory.makeBorderLabel("Map Scale:");
    private JButton locationMapScaleSetButton = GUIFactory.makeButton("Set");
    private JPanel locationMapScaleFieldPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JTextField locationMapScaleField = GUIFactory.makeTextField(16);
    private JPanel locationMapScaleUnitLabelPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JLabel locationMapScaleUnitLabel = GUIFactory.makeLabel("Meters per Pixel");
    private JPanel locationGPSMapPanel = GUIFactory.makeCascadingPanel();
    private JPanel locationMapTopLabelPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JLabel locationMapTopLabel = GUIFactory.makeBorderLabel("Map GPS Coordinates:");
    private JPanel locationTopLeftLatLonPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationTopLeftLatLonField = GUIFactory.makeTextField(16);
    private JPanel locationBottomRightPanel = GUIFactory.makePanel(new BorderLayout());
    private JPanel locationBottomRightLatLonPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationBottomRightLatLonField = GUIFactory.makeTextField(16);
    private JPanel locationMapBottomLabelPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JLabel locationMapBottomLabel = GUIFactory.makeLabel("Top-Left/Bottom-Right");
    private JPanel locationNodePanel = GUIFactory.makeCascadingPanel();
    private JPanel locationNodeLabelPanel = GUIFactory.makePanel(new FlowLayout(0));
    private JLabel locationNodeLabel = GUIFactory.makeBorderLabel("Node:");
    private JCheckBox locationNodeFollowCheckBox = GUIFactory.makeCheckBox("Follow");
    private JCheckBox locationNodeUseGPSCheckBox = GUIFactory.makeCheckBox("Use GPS");
    private JPanel locationNodeIDPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationNodeIDField = GUIFactory.makeTextField(20);
    private JPanel locationNodeLatLonPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationNodeLatLonField = GUIFactory.makeTextField(16);
    private JPanel locationNodeDistancePanel = GUIFactory.makePanel(new FlowLayout(1));
    private JTextField locationNodeDistanceField = GUIFactory.makeTextField(5);
    private JLabel locationNodeDistanceLabel = GUIFactory.makeLabel("m");
    private JPanel locationNodeBottomLabelPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JLabel locationNodeBottomLabel = GUIFactory.makeLabel("ID/Location/Distance");
    private JPanel tablePanel = GUIFactory.makePanel(new BorderLayout());
    DynamicTable<SpatialMeasurementNode> table = new DynamicTable();
    private JScrollPane tablePane = new JScrollPane(this.table);
    private JPanel controlPanel = GUIFactory.makePanel(new FlowLayout(1));
    private JButton showHideTableButton = GUIFactory.makeButton("Hide Table");
    private JButton showHideControlButton = GUIFactory.makeButton("Hide Control");
    private JButton removeSelectedRowsButton = GUIFactory.makeButton("Remove Selected Rows");
    private JButton clearAllRowsButton = GUIFactory.makeButton("Clear All Rows");
    private JCheckBox autoScrollCheckBox = GUIFactory.makeCheckBox("Auto-Scroll");
    private JPanel bottomPanel = GUIFactory.makePanel(new BorderLayout());
    private UIGuideBarPanel uiGuidePanel = new UIGuideBarPanel().addAspectFit(this).addOriginalFit(this).addZoomIn(this).addZoomOut(this).addMove().addPosition();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu swissMenu = new JMenu("SWiSS");
    private JMenuItem aboutMenuItem = new JMenuItem("About");
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem saveResultsMenuItem = new JMenuItem("Save Results");
    private boolean connected = false;
    private Thread connectionThread;
    private MapScaleMasterPanel mapScaleMasterPanel = new MapScaleMasterPanel();
    private boolean mapScaleAvailable = false;
    private double distancePerPixel;
    private int[] referenceScaleXs = new int[2];
    private int[] referenceScaleYs = new int[2];
    private JPanel nodePanel = GUIFactory.makePanel(new BorderLayout());
    private DefaultListModel<NodeState> nodeModel = new DefaultListModel();
    private JList<NodeState> nodeList = new JList<NodeState>(this.nodeModel);
    private JScrollPane nodePane = GUIFactory.makeScrollPane(this.nodePanel);
    private Sound soundBeep = new Sound("beep.wav");
    private Sound soundDoubleBeep = new Sound("double_beep.wav");
    private MeasurementKeyManager sharedMeasurementKeyManager = new MeasurementKeyManager();
    private NodeState apState = new NodeState("AP");
    private Map<String, NodeState> staStates = new HashMap<String, NodeState>();
    private static final int DATA_FETCH_PERIOD_MS = 500;

    public MainSCAN() {
        this.soundBeep.open();
        this.soundDoubleBeep.open();
        this.setTitle("Station Control & Activity Nexus (SCAN) v1.0");
        this.setDefaultCloseOperation(0);
        Dimension fullSize = new Window(null).getGraphicsConfiguration().getBounds().getSize();
        this.setSize(fullSize);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.BLACK);
        this.serverIPField.setText("172.16.200.93");
        this.serverPortField.setText("12346");
        UtilSwing.setEditable(false, this.locationTopLeftLatLonField, this.locationBottomRightLatLonField, this.locationNodeLatLonField, this.locationNodeIDField);
        this.openPathPanel.add(this.openPathLabel);
        this.add((Component)this.openPathPanel, "North");
        UtilSwing.groupRadioButtons(this.loggingOnButton, this.loggingOffButton);
        this.loggingOffButton.setSelected(true);
        this.serverPanel.add((Component)UtilSwing.add(this.serverTopPanel, this.serverIPField, this.serverColonLabel, this.serverPortField), "North");
        this.serverPanel.add((Component)UtilSwing.add(this.serverCenterPanel, this.serverWiFiIcon, this.serverConnectButton, this.serverStatusButton), "Center");
        UtilSwing.add(this.locationMapScalePanel, UtilSwing.add(this.locationMapScaleLabelPanel, this.locationMapScaleLabel, this.locationMapScaleSetButton), UtilSwing.add(this.locationMapScaleFieldPanel, this.locationMapScaleField), UtilSwing.add(this.locationMapScaleUnitLabelPanel, this.locationMapScaleUnitLabel));
        UtilSwing.add(this.locationGPSMapPanel, UtilSwing.add(this.locationMapTopLabelPanel, this.locationMapTopLabel), UtilSwing.add(this.locationTopLeftLatLonPanel, this.locationTopLeftLatLonField), UtilSwing.add(this.locationBottomRightLatLonPanel, this.locationBottomRightLatLonField), UtilSwing.add(this.locationMapBottomLabelPanel, this.locationMapBottomLabel));
        UtilSwing.add(this.locationNodePanel, UtilSwing.add(this.locationNodeLabelPanel, this.locationNodeLabel, this.locationNodeFollowCheckBox, this.locationNodeUseGPSCheckBox), UtilSwing.add(this.locationNodeIDPanel, this.locationNodeIDField), UtilSwing.add(this.locationNodeLatLonPanel, this.locationNodeLatLonField), UtilSwing.add(this.locationNodeDistancePanel, this.locationNodeDistanceField, this.locationNodeDistanceLabel), UtilSwing.add(this.locationNodeBottomLabelPanel, this.locationNodeBottomLabel));
        this.rightPanel.add(this.serverPanel);
        this.rightPanel.add(UtilSwing.add(this.loggingPanel, this.loggingIcon, this.loggingOnButton, this.loggingOffButton));
        this.rightPanel.add(UtilSwing.add(this.locationPanel, this.locationNodePanel, this.locationMapScalePanel, this.locationGPSMapPanel));
        this.add((Component)this.rightPane, "East");
        this.nodePanel.add(this.nodeList, "Center");
        this.add((Component)this.nodePane, "West");
        this.apState.getMarker().setColor(Color.RED);
        this.nodeModel.addElement(this.apState);
        this.nodeList.setBackground(Colors.DARKER_GRAY_COLOR);
        this.nodeList.setForeground(Color.ORANGE);
        this.nodePane.setPreferredSize(new Dimension(200, 200));
        this.tablePane.setPreferredSize(new Dimension(200, 200));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.addColumns("TIMESTAMP", "ID", "PIXEL(X)", "PIXEL(Y)", "RATIO(X)", "RATIO(Y)", "LATITUDE[deg]", "LONGITUDE[deg]", "DISTANCE[m]");
        this.table.setDefaultRenderer(Object.class, new ColoredTableCellRenderer());
        this.tablePane.getViewport().setBackground(Color.BLACK);
        this.tablePanel.add((Component)this.tablePane, "Center");
        this.bottomPanel.add(this.tablePanel);
        UtilSwing.add(this.controlPanel, this.showHideControlButton, this.showHideTableButton, this.removeSelectedRowsButton, this.clearAllRowsButton, this.autoScrollCheckBox);
        this.tablePanel.add((Component)this.controlPanel, "South");
        this.bottomPanel.add((Component)this.uiGuidePanel, "South");
        this.add((Component)this.bottomPanel, "South");
        this.locationNodeFollowCheckBox.setEnabled(false);
        this.locationNodeUseGPSCheckBox.setEnabled(false);
        this.autoScrollCheckBox.setSelected(true);
        this.locationPanel.setVisible(false);
        this.locationMapScalePanel.setVisible(false);
        this.locationGPSMapPanel.setVisible(false);
        GlobalAnimationThread.add(this.serverWiFiIcon);
        GlobalAnimationThread.add(this.loggingIcon);
        UtilSwing.setBorder(this.serverPanel, "AP Server Connection");
        UtilSwing.setBorder(this.loggingPanel, "Continuous Logging");
        UtilSwing.setBorder(this.locationPanel, "Location");
        UtilSwing.setBorder(this.nodePanel, "Nodes");
        this.locationMapScalePanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationGPSMapPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationBottomRightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.locationNodePanel.setBorder(BorderFactory.createEtchedBorder());
        UtilSwing.fixPreferredHeight(this.serverPanel);
        UtilSwing.fixPreferredHeight(this.loggingPanel);
        UtilSwing.fixPreferredHeight(this.locationPanel);
        this.setupMenu();
        this.setupButtonUI();
        this.resetControl();
        this.enableKeyboardMouseUI();
        this.requestFocusInWindow();
        this.nodeList.addListSelectionListener(event -> {
            Marker marker;
            this.locationNodeIDField.setText("");
            this.locationNodeLatLonField.setText("");
            this.locationNodeDistanceField.setText("");
            Enumeration<NodeState> nodes = this.nodeModel.elements();
            while (nodes.hasMoreElements()) {
                nodes.nextElement().setSelected(false);
            }
            int[] selectedIndices = this.nodeList.getSelectedIndices();
            if (selectedIndices.length == 0) {
                return;
            }
            int topSelectedIndex = selectedIndices[0];
            this.locationNodeFollowCheckBox.setEnabled(true);
            this.locationNodeUseGPSCheckBox.setEnabled(true);
            NodeState topState = this.nodeModel.get(topSelectedIndex);
            this.locationNodeIDField.setText(topState.getID());
            topState.setSelected(true);
            this.locationNodeLatLonField.setText(String.format("%.6f,%.6f", topState.getGPSLatitude(), topState.getGPSLongitude()));
            this.locationNodeDistanceField.setText(String.format("%d", topState.getDistance()));
            if (this.locationNodeFollowCheckBox.isSelected() && (marker = topState.getMarker()).isEnabled()) {
                SatelliteMapPanel satelliteMapPanel = this.satelliteMapMasterPanel.getSatelliteMapPanel();
                satelliteMapPanel.centerAt(marker.getPixelX(), marker.getPixelY());
            }
            this.locationNodeUseGPSCheckBox.setSelected(topState.isGPSEnabled());
            this.repaint();
        });
        this.locationNodeUseGPSCheckBox.addActionListener(event -> {
            int selectedIndex = this.nodeList.getSelectedIndex();
            if (selectedIndex == -1) {
                return;
            }
            NodeState state = this.nodeModel.get(selectedIndex);
            state.setGPSEnabled(this.locationNodeUseGPSCheckBox.isSelected());
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                String message = "Are you sure you want to close the program?";
                String title = "Closing the program";
                int option = JOptionPane.showConfirmDialog(MainSCAN.this, message, title, 2, -1, null);
                if (option == 0) {
                    MainSCAN.this.disconnect();
                    MainSCAN.this.dispose();
                    System.exit(0);
                }
            }
        });
        SwingUtilities.invokeLater(() -> {
            this.openMapImageFileSelector();
            if (this.map == null) {
                this.dispose();
                System.exit(0);
            }
        });
    }

    private String getTableAsCSVs() {
        StringBuffer s = new StringBuffer();
        s.append("TIMESTAMP,ID,PIXEL(X),PIXEL(Y),RATIO(X),RATIO(Y),LATITUDE[deg],LONGITUDE[deg],DISTANCE[m],");
        s.append(this.sharedMeasurementKeyManager.getKeysAsCSV());
        s.append('\n');
        Set<String> sharedMeasurementKeySet = this.sharedMeasurementKeyManager.keySet();
        for (SpatialMeasurementNode node : this.table) {
            s.append(node.coordinateAsCSV());
            s.append(",");
            s.append(node.getDistanceAsString());
            for (String sharedKey : sharedMeasurementKeySet) {
                s.append(",");
                if (!node.has(sharedKey)) continue;
                s.append(node.get(sharedKey));
            }
            s.append('\n');
        }
        return s.toString();
    }

    private void setupMenu() {
        this.swissMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.swissMenu);
        this.fileMenu.add(this.saveResultsMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.aboutMenuItem.addActionListener(event -> {
            this.aboutPanel.startAnimation();
            JOptionPane.showMessageDialog(this, this.aboutPanel, "About", -1, null);
            this.aboutPanel.stopAnimation();
        });
        this.saveResultsMenuItem.addActionListener(event -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(new File("~"));
            fileChooser.setDialogTitle("Select the output directory");
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showSaveDialog(this) != 0) {
                return;
            }
            String timestamp = UtilDate.getDate_YYYY_MM_DD_hh_mm_ss();
            String logDirectoryName = String.valueOf(timestamp) + "_swiss_stat_logs";
            File directory = new File(String.valueOf(fileChooser.getSelectedFile().getAbsolutePath()) + "/" + logDirectoryName);
            try {
                if (!Files.exists(directory.toPath(), new LinkOption[0])) {
                    Files.createDirectories(directory.toPath(), new FileAttribute[0]);
                }
                String directoryPath = directory.getAbsolutePath();
                String csvFileName = String.valueOf(timestamp) + "_raw.csv";
                String configFileName = String.valueOf(timestamp) + "_config.json";
                String imageFileName = String.valueOf(timestamp) + "_" + this.map.getImageFile().getName();
                System.out.println(imageFileName);
                File csvFile = new File(String.valueOf(directoryPath) + "/" + csvFileName);
                Files.write(csvFile.toPath(), this.getTableAsCSVs().getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                JsonObject config = new JsonObject();
                JsonObject appConfig = new JsonObject();
                appConfig.addProperty("name", "SCAN");
                appConfig.addProperty("version", "v1.0");
                config.add("app", appConfig);
                JsonObject pathConfig = new JsonObject();
                pathConfig.addProperty("csv", "./" + csvFileName);
                pathConfig.addProperty("image", "./" + imageFileName);
                config.add("path", pathConfig);
                String configText = new GsonBuilder().setPrettyPrinting().create().toJson(config);
                File configFile = new File(String.valueOf(directoryPath) + "/" + configFileName);
                Files.write(configFile.toPath(), configText.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                File imageFile = new File(String.valueOf(directoryPath) + "/" + imageFileName);
                ImageIO.write((RenderedImage)this.map.getImage(), this.map.getImageFileExtension(), imageFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void resetControl() {
        boolean connected = this.isConnected();
        boolean measuringInGPSMode = connected && this.loggingOnButton.isSelected();
        this.serverConnectButton.setText(connected ? "Disconnect" : "Connect");
        this.serverStatusButton.setEnabled(connected);
        UtilSwing.setEnabled(!connected, this.serverIPField, this.serverPortField);
        UtilSwing.setEnabled(connected, this.loggingOnButton, this.loggingOffButton);
        this.loggingIcon.setOnOff(measuringInGPSMode);
    }

    private void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connectionThread.interrupt();
        this.connectionThread = null;
        this.setConnected(false);
        this.loggingOffButton.setSelected(true);
        this.resetControl();
        this.repaint();
    }

    private void setupButtonUI() {
        this.serverConnectButton.addActionListener(event -> {
            if (this.connected) {
                this.disconnect();
            } else {
                String ip = this.serverIPField.getText().trim();
                int port = Integer.parseInt(this.serverPortField.getText().trim());
                this.connectionThread = new Thread(() -> this.startUpdatingDataOnThreadGPSMode(ip, port));
                this.connectionThread.start();
                this.setConnected(true);
                this.resetControl();
            }
        });
        this.serverStatusButton.addActionListener(event -> {
            String ip = this.serverIPField.getText().trim();
            int port = Integer.parseInt(this.serverPortField.getText().trim());
            String responseText = SCANNetwork.query("STATUS", ip, port);
            JsonObject response = JsonParser.parseString(responseText).getAsJsonObject();
            JsonObject status = response.get("status").getAsJsonObject();
            JTabbedPane statusPane = new JTabbedPane();
            for (String key : status.keySet()) {
                JTextArea textArea = new JTextArea();
                textArea.setFont(new Font("Monospaced", 0, 12));
                textArea.setEditable(false);
                textArea.setText(status.get(key).getAsString());
                statusPane.add(key, textArea);
            }
            JOptionPane.showMessageDialog(this, statusPane, "Status", -1, null);
        });
        this.loggingOnButton.addActionListener(event -> this.resetControl());
        this.loggingOffButton.addActionListener(event -> this.resetControl());
        this.removeSelectedRowsButton.addActionListener(event -> this.table.removeSelectedIndices());
        this.clearAllRowsButton.addActionListener(event -> {
            String message = "Are you sure you want to clear all the rows?";
            String title = "Warning";
            int option = JOptionPane.showConfirmDialog(this, message, title, 2, -1, null);
            if (option != 0) {
                return;
            }
            this.clearCoordinates();
        });
        this.showHideControlButton.addActionListener(event -> {
            this.rightPane.setVisible(!this.rightPane.isVisible());
            this.showHideControlButton.setText(this.rightPane.isVisible() ? "Hide Control" : "Show Control");
            this.revalidate();
            this.repaint();
        });
        this.showHideTableButton.addActionListener(event -> {
            this.tablePane.setVisible(!this.tablePane.isVisible());
            UtilSwing.setEnabled(this.tablePane.isVisible(), this.removeSelectedRowsButton, this.clearAllRowsButton, this.autoScrollCheckBox);
            this.showHideTableButton.setText(this.tablePane.isVisible() ? "Hide Table" : "Show Table");
            this.table.clearSelection();
            this.revalidate();
            this.repaint();
        });
        this.locationMapScaleSetButton.addActionListener(event -> {
            int option;
            String title = "Setting Map Scale";
            MapScalePanel mapScalePanel = this.mapScaleMasterPanel.getMapScalePanel();
            if (this.mapScaleAvailable) {
                mapScalePanel.setReferenceLocations(this.referenceScaleXs[0], this.referenceScaleYs[0], this.referenceScaleXs[1], this.referenceScaleYs[1]);
            }
            if ((option = JOptionPane.showConfirmDialog(this, this.mapScaleMasterPanel, title, 2, -1, null)) != 0) {
                return;
            }
            if (!this.mapScaleMasterPanel.distanceInMetersInputValid() || !this.mapScaleMasterPanel.distanceInPixelsInputValid()) {
                this.displayInvalidInputMessage();
                return;
            }
            this.mapScaleAvailable = true;
            this.referenceScaleXs[0] = mapScalePanel.getReferenceX0();
            this.referenceScaleYs[0] = mapScalePanel.getReferenceY0();
            this.referenceScaleXs[1] = mapScalePanel.getReferenceX1();
            this.referenceScaleYs[1] = mapScalePanel.getReferenceY1();
            this.distancePerPixel = this.mapScaleMasterPanel.getDistanceInMeters() / this.mapScaleMasterPanel.getDistanceInPixels();
            this.locationMapScaleField.setText(String.format("%s", this.distancePerPixel));
            this.repaint();
        });
        this.table.getSelectionModel().addListSelectionListener(event -> {
            SatelliteMapPanel satelliteMapPanel = this.satelliteMapMasterPanel.getSatelliteMapPanel();
            satelliteMapPanel.repaint();
        });
    }

    private void displayInvalidInputMessage() {
        JOptionPane.showMessageDialog(this, "Invalid Input", "Error", -1, null);
    }

    private void clearCoordinates() {
        this.table.clear();
        this.repaint();
    }

    private synchronized void setConnected(boolean value) {
        this.connected = value;
        this.serverWiFiIcon.setOnOff(value);
    }

    private synchronized void setConnectionStable(boolean value) {
        this.serverWiFiIcon.setConnectionStable(value);
    }

    private synchronized boolean isConnected() {
        return this.connected;
    }

    private void startUpdatingDataOnThreadGPSMode(String ip, int port) {
        while (this.isConnected()) {
            try {
                Thread.sleep(500L);
                String gpsInfoLine = SCANNetwork.query("GPS_INFO", ip, port);
                JsonObject gpsInfo = JsonParser.parseString(gpsInfoLine).getAsJsonObject();
                System.out.println(gpsInfo);
                String staInfoLine = SCANNetwork.query("STA_INFO", ip, port);
                JsonObject staInfo = JsonParser.parseString(staInfoLine).getAsJsonObject();
                System.out.println(staInfo);
                SwingUtilities.invokeLater(() -> {
                    this.setConnectionStable(true);
                    int mapWidth = this.map.getImage().getWidth();
                    int mapHeight = this.map.getImage().getHeight();
                    SatelliteMapPanel satelliteMapPanel = this.satelliteMapMasterPanel.getSatelliteMapPanel();
                    boolean apGPSEnabled = this.apState.isGPSEnabled();
                    boolean apGPSAvailable = gpsInfo.has("gps");
                    boolean apGPSUpdated = false;
                    Marker apMarker = this.apState.getMarker();
                    apMarker.setLocationUnsure(apGPSEnabled);
                    if (apGPSEnabled && apGPSAvailable) {
                        JsonObject apGPSObject = gpsInfo.get("gps").getAsJsonObject();
                        apGPSUpdated = this.apState.updateGPS(apGPSObject);
                        if (apGPSUpdated || !this.apState.isGPSEnabled()) {
                            apMarker.setLocationUnsure(false);
                        } else if (UtilTime.inMilliseconds() - this.apState.getGPSTime() > 5000L) {
                            apMarker.setLocationUnsure(true);
                        }
                        long apGPSTime = this.apState.getGPSTime();
                        double apLatitude = this.apState.getGPSLatitude();
                        double apLongitude = this.apState.getGPSLongitude();
                        double apMapRatioX = this.mercatorConverter.getRatioX(this.apState.getGPSLongitude());
                        double apMapRatioY = this.mercatorConverter.getRatioY(this.apState.getGPSLatitude());
                        int apMapPixelX = (int)((double)mapWidth * apMapRatioX);
                        int apMapPixelY = (int)((double)mapHeight * apMapRatioY);
                        String apGPSLine = String.format("%s,%s,%s,%s,%s,%s,%s", apGPSTime, apMapPixelX, apMapPixelY, apMapRatioX, apMapRatioY, apLatitude, apLongitude);
                        System.out.println(apGPSLine);
                        if (apGPSUpdated) {
                            this.loggingIcon.flash();
                            if (this.apState.isSelected()) {
                                this.locationNodeLatLonField.setText(String.format("%.6f,%.6f", apLatitude, apLongitude));
                                this.locationNodeDistanceField.setText("0");
                                if (this.locationNodeFollowCheckBox.isSelected()) {
                                    satelliteMapPanel.centerAt(apMapPixelX, apMapPixelY);
                                }
                            }
                            apMarker.setEnabled(true);
                            apMarker.setPixelPosition(apMapPixelX, apMapPixelY);
                        }
                    }
                    String apMarkerTextTitle = "[AP]";
                    if (this.apState.isGPSEnabled()) {
                        apMarkerTextTitle = String.valueOf(apMarkerTextTitle) + " (GPS)";
                    }
                    apMarker.setText(apMarkerTextTitle);
                    JsonObject stas = staInfo.get("sta_info").getAsJsonObject();
                    for (String staKey : stas.keySet()) {
                        NodeState staState = this.staStates.get(staKey);
                        if (staState == null) {
                            staState = new NodeState(staKey);
                            this.staStates.put(staKey, staState);
                            this.nodeModel.addElement(staState);
                            this.satelliteMapMasterPanel.getSatelliteMapPanel().addSTAMarker(staState.getMarker());
                        }
                        JsonObject staValue = stas.get(staKey).getAsJsonObject();
                        boolean staGPSEnabled = staState.isGPSEnabled();
                        boolean staGPSUpdated = false;
                        Marker staMarker = staState.getMarker();
                        staMarker.setLocationUnsure(staGPSEnabled);
                        long staGPSTime = UtilTime.inMilliseconds();
                        double staLatitude = staState.getGPSLatitude();
                        double staLongitude = staState.getGPSLongitude();
                        double staMapRatioX = this.mercatorConverter.getRatioX(staLongitude);
                        double staMapRatioY = this.mercatorConverter.getRatioY(staLatitude);
                        int staMapPixelX = (int)((double)mapWidth * staMapRatioX);
                        int staMapPixelY = (int)((double)mapHeight * staMapRatioY);
                        if (staGPSEnabled && staValue.has("gps")) {
                            JsonObject staGPSObject = staValue.get("gps").getAsJsonObject();
                            staGPSUpdated = staState.updateGPS(staGPSObject);
                            if (staGPSUpdated || !staState.isGPSEnabled()) {
                                staMarker.setLocationUnsure(false);
                            }
                            staMarker.setEnabled(staState.getGPSValid());
                            if (staGPSUpdated) {
                                staGPSTime = UtilTime.inMilliseconds();
                                staLatitude = staState.getGPSLatitude();
                                staLongitude = staState.getGPSLongitude();
                                staMapRatioX = this.mercatorConverter.getRatioX(staLongitude);
                                staMapRatioY = this.mercatorConverter.getRatioY(staLatitude);
                                staMapPixelX = (int)((double)mapWidth * staMapRatioX);
                                staMapPixelY = (int)((double)mapHeight * staMapRatioY);
                                staMarker.setEnabled(true);
                                staMarker.setPixelPosition(staMapPixelX, staMapPixelY);
                                if (staState.isSelected()) {
                                    this.locationNodeLatLonField.setText(String.format("%.6f,%.6f", staLatitude, staLongitude));
                                    if (this.locationNodeFollowCheckBox.isSelected()) {
                                        satelliteMapPanel.centerAt(staMapPixelX, staMapPixelY);
                                    }
                                }
                            }
                        }
                        if (staValue.has("measurements")) {
                            JsonObject staMeasurementObject = staValue.get("measurements").getAsJsonObject();
                            List<String> updatedMeasurementKeys = staState.updateMeasurements(staMeasurementObject);
                            int maxKeyLength = staState.getMaxKeyLength();
                            StringBuffer markerTextBuffer = new StringBuffer();
                            String[] staKeySplit = staKey.split("/");
                            String staIP = staKeySplit[0];
                            String staID = staKeySplit[1];
                            String staMarkerTextTitle = "[" + staIP + "]";
                            if (staState.isGPSEnabled()) {
                                staMarkerTextTitle = String.valueOf(staMarkerTextTitle) + " (GPS)";
                            }
                            markerTextBuffer.append(String.valueOf(staMarkerTextTitle) + "\n");
                            markerTextBuffer.append(String.valueOf(staID) + "\n");
                            for (String staMeasurementKey : staState) {
                                if (this.sharedMeasurementKeyManager.registerMeasurementKey(staMeasurementKey)) {
                                    this.table.addColumn(staMeasurementKey);
                                }
                                double staMeasurementValue = staState.getMeasurementValue(staMeasurementKey);
                                String staMarkerLine = String.format("%s: %s\n", staMeasurementKey, staMeasurementValue);
                                UtilString.headPad(markerTextBuffer, maxKeyLength - staMeasurementKey.length());
                                markerTextBuffer.append(staMarkerLine);
                            }
                            String markerText = markerTextBuffer.toString().trim();
                            staMarker.setText(markerText);
                            if (this.loggingOnButton.isSelected() && !updatedMeasurementKeys.isEmpty()) {
                                SpatialMeasurementNode node = this.sharedMeasurementKeyManager.createSpatialMeasurementNode(staGPSTime, staMapPixelX, staMapPixelY, staMapRatioX, staMapRatioY, staLatitude, staLongitude);
                                node.setID(staKey);
                                if (this.apState.getGPSValid()) {
                                    node.setDistance(staState.getDistance());
                                }
                                for (String updatedMeasurementKey : updatedMeasurementKeys) {
                                    node.add(updatedMeasurementKey, staState.getMeasurementValue(updatedMeasurementKey));
                                }
                                this.table.addRow(node);
                                if (this.autoScrollCheckBox.isSelected()) {
                                    this.table.scrollToBottom();
                                }
                            }
                        }
                        if (!this.apState.getGPSValid() || !staState.getGPSValid()) continue;
                        double phi1 = this.apState.getGPSLatitude();
                        double psi1 = this.apState.getGPSLongitude();
                        double phi2 = staState.getGPSLatitude();
                        double psi2 = staState.getGPSLongitude();
                        int distance = (int)Math.round(WebMercator.distanceInMeter(phi1, psi1, phi2, psi2));
                        staState.setDistance(distance);
                        if (!staState.isSelected()) continue;
                        this.locationNodeDistanceField.setText(String.format("%d", staState.getDistance()));
                    }
                    for (NodeState staState : this.staStates.values()) {
                        if (!staState.isGPSEnabled() || UtilTime.inMilliseconds() - staState.getGPSTime() <= 5000L) continue;
                        staState.getMarker().setLocationUnsure(true);
                    }
                    this.repaint();
                });
            }
            catch (Exception e) {
                this.setConnectionStable(false);
                e.printStackTrace();
            }
        }
        System.out.println("[CONNECTION THREAD EXIT]");
    }

    private boolean openMapImageFileSelector() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File("~"));
        fileChooser.setDialogTitle("Opening a map image file");
        fileChooser.setFileSelectionMode(0);
        if (fileChooser.showOpenDialog(this) != 0) {
            return false;
        }
        File imageFile = fileChooser.getSelectedFile();
        if (!this.loadImage(imageFile)) {
            String errorMessage = String.format("The image file could not be loaded: %s", imageFile.getName());
            UtilSwing.displayErrorMessage(this, errorMessage, new Object[0]);
            this.openMapImageFileSelector();
        }
        this.openPathPanel.setBackground(Color.LIGHT_GRAY);
        this.openPathLabel.setText(imageFile.getAbsolutePath());
        return true;
    }

    private void openMapGPSUpdater() {
        try {
            String message = "*If GPS coordinates are not applicable, press CANCEL for manual operation.\n\n";
            message = String.valueOf(message) + "FORMAT: (TOP-LEFT) LATITUDE, (TOP-LEFT) LONGTITUDE, (BOTTOM-RIGHT) LATITUDE, (BOTTOM-RIGHT) LONGTIUDE";
            String title = "Updating GPS Coordinates for the Input Map";
            String sampleText = this.mercatorConverter == null ? "<REPLACE-THIS>,<REPLACE-THIS>,<REPLACE-THIS>,<REPLACE-THIS>" : String.format("%s,%s,%s,%s", this.mercatorConverter.getStartPhi(), this.mercatorConverter.getStartPsi(), this.mercatorConverter.getEndPhi(), this.mercatorConverter.getEndPsi());
            Object input = JOptionPane.showInputDialog(this, message, title, -1, null, null, sampleText);
            if (input == null) {
                return;
            }
            String line = input.toString();
            String[] values = line.split(",", -1);
            double phi1 = Double.parseDouble(values[0]);
            double psi1 = Double.parseDouble(values[1]);
            double phi2 = Double.parseDouble(values[2]);
            double psi2 = Double.parseDouble(values[3]);
            this.locationTopLeftLatLonField.setText(String.format("%s,%s", phi1, psi1));
            this.locationBottomRightLatLonField.setText(String.format("%s,%s", phi2, psi2));
            this.map.setGPSCoordinates(phi1, psi1, phi2, psi2);
            this.mercatorConverter = this.map.getMercatorConverter();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.openMapGPSUpdater();
        }
    }

    private boolean loadImage(File imageFile) {
        try {
            boolean mapGPSCoordinateAvailable;
            this.map = SatelliteMap.load(imageFile);
            this.satelliteMapMasterPanel = new SatelliteMapMasterPanel(null, this.map, this.table, null, false);
            final SatelliteMapPanel satelliteMapPanel = this.satelliteMapMasterPanel.getSatelliteMapPanel();
            satelliteMapPanel.setAPMarker(this.apState.getMarker());
            satelliteMapPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    MainSCAN.this.requestFocusInWindow();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!MainSCAN.this.connected) {
                        return;
                    }
                    switch (e.getButton()) {
                        case 2: 
                        case 3: {
                            Image image = satelliteMapPanel.getImage();
                            int mapPixelX = (int)satelliteMapPanel.getTrueX(e.getX());
                            int mapPixelY = (int)satelliteMapPanel.getTrueY(e.getY());
                            double imageWidth = image.getWidth(null);
                            double imageHeight = image.getHeight(null);
                            if (mapPixelX < 0 || imageWidth < (double)mapPixelX || mapPixelY < 0 || imageHeight < (double)mapPixelY) {
                                return;
                            }
                            int selectedIndex = MainSCAN.this.nodeList.getSelectedIndex();
                            if (selectedIndex == -1) {
                                return;
                            }
                            NodeState state = (NodeState)MainSCAN.this.nodeModel.get(selectedIndex);
                            if (!state.isGPSEnabled()) {
                                Marker marker = state.getMarker();
                                marker.setEnabled(true);
                                marker.setPixelPosition(mapPixelX, mapPixelY);
                                int mapWidth = MainSCAN.this.map.getImage().getWidth();
                                int mapHeight = MainSCAN.this.map.getImage().getHeight();
                                double mapRatioX = (double)mapPixelX / (double)mapWidth;
                                double mapRatioY = (double)mapPixelY / (double)mapHeight;
                                double latitude = MainSCAN.this.mercatorConverter.getPhi(mapRatioY);
                                double longitude = MainSCAN.this.mercatorConverter.getPsi(mapRatioX);
                                state.updateGPSManually(latitude, longitude);
                                MainSCAN.this.locationNodeLatLonField.setText(String.format("%.6f,%.6f", latitude, longitude));
                                if (MainSCAN.this.apState.getGPSValid()) {
                                    double apLatitude = MainSCAN.this.apState.getGPSLatitude();
                                    double apLongitude = MainSCAN.this.apState.getGPSLongitude();
                                    int distance = (int)Math.round(WebMercator.distanceInMeter(apLatitude, apLongitude, latitude, longitude));
                                    state.setDistance(distance);
                                    if (state.isSelected()) {
                                        MainSCAN.this.locationNodeDistanceField.setText(String.format("%d", state.getDistance()));
                                    }
                                }
                            }
                            MainSCAN.this.repaint();
                        }
                    }
                }
            });
            this.add((Component)this.satelliteMapMasterPanel, "Center");
            this.mercatorConverter = this.map.getMercatorConverter();
            if (this.mercatorConverter == null) {
                this.openMapGPSUpdater();
            }
            boolean bl = mapGPSCoordinateAvailable = this.mercatorConverter != null;
            if (!mapGPSCoordinateAvailable) {
                this.locationTopLeftLatLonField.setText("");
                this.locationBottomRightLatLonField.setText("");
                this.map.setGPSCoordinates(0.0, 0.0, 0.0, 0.0);
                this.mercatorConverter = this.map.getMercatorConverter();
            }
            this.locationMapScalePanel.setVisible(!mapGPSCoordinateAvailable);
            this.locationNodeLatLonPanel.setVisible(mapGPSCoordinateAvailable);
            this.locationGPSMapPanel.setVisible(mapGPSCoordinateAvailable);
            this.locationPanel.setVisible(true);
            this.locationTopLeftLatLonField.setText(String.format("%.6f,%.6f", this.map.getPhi1(), this.map.getPsi1()));
            this.locationBottomRightLatLonField.setText(String.format("%.6f,%.6f", this.map.getPhi2(), this.map.getPsi2()));
            this.mapScaleMasterPanel.getMapScalePanel().setImage(this.map.getImage());
            this.mapScaleMasterPanel.getMapScalePanel().reset(2);
            return true;
        }
        catch (Exception e) {
            return false;
        }
        finally {
            this.resetControl();
            UtilSwing.fixPreferredHeight(this.locationPanel);
            this.revalidate();
            this.repaint();
            this.requestFocusInWindow();
        }
    }

    private void enableKeyboardMouseUI() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println(e);
                switch (e.getKeyCode()) {
                    case 65: {
                        MainSCAN.this.applyAspectFit();
                        break;
                    }
                    case 79: {
                        MainSCAN.this.applyOriginalFit();
                    }
                }
                MainSCAN.this.repaint();
            }
        });
    }

    @Override
    public void frameParameterChanged(ZoomableImagePanel source) {
        if (this.satelliteMapMasterPanel != null) {
            SatelliteMapPanel satelliteMapPanel = this.satelliteMapMasterPanel.getSatelliteMapPanel();
            if (satelliteMapPanel.equals(source)) {
                return;
            }
            satelliteMapPanel.setFrameLocation(source.frameX(), source.frameY());
            satelliteMapPanel.setZoom(source.getZoom());
        }
        this.repaint();
    }

    @Override
    public void mouseEntered() {
        this.requestFocusInWindow();
    }

    @Override
    public void applyAspectFit() {
        if (this.satelliteMapMasterPanel != null) {
            this.satelliteMapMasterPanel.getSatelliteMapPanel().reset(1);
        }
    }

    @Override
    public void applyOriginalFit() {
        if (this.satelliteMapMasterPanel != null) {
            this.satelliteMapMasterPanel.getSatelliteMapPanel().reset(0);
        }
    }

    @Override
    public void adjustZoomRelativeToCurrent(double factor) {
        if (this.satelliteMapMasterPanel != null) {
            this.satelliteMapMasterPanel.getSatelliteMapPanel().adjustZoomRelativeToCurrent(factor);
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            MainSCAN main = new MainSCAN();
            main.setVisible(true);
        });
    }

    public class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cellComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cellComponent.setForeground(column == 0 ? Color.RED : (column < 8 ? Color.YELLOW : Color.GREEN));
            cellComponent.setBackground(isSelected ? Color.GRAY : Color.BLACK);
            return cellComponent;
        }
    }
}

