/*
 * Decompiled with CFR 0.152.
 */
package AppSCAN;

import Map.SpatialMeasurementNode;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MeasurementKeyManager {
    private Map<String, Integer> keyIndices = new LinkedHashMap<String, Integer>();

    public boolean registerMeasurementKey(String measurementKey) {
        if (this.keyIndices.containsKey(measurementKey)) {
            return false;
        }
        this.keyIndices.put(measurementKey, this.keyIndices.size());
        return true;
    }

    public String getKeysAsCSV() {
        if (this.keyIndices.isEmpty()) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (String key : this.keyIndices.keySet()) {
            s.append(key);
            s.append(',');
        }
        return s.toString().substring(0, s.length() - 1);
    }

    public int getMeasurementKeyIndex(String measurementKey) {
        return this.keyIndices.get(measurementKey);
    }

    public SpatialMeasurementNode createSpatialMeasurementNode(long timestamp, int pixelX, int pixelY, double ratioX, double ratioY, double latitude, double longitude) {
        SpatialMeasurementNode node = new SpatialMeasurementNode(timestamp, pixelX, pixelY, ratioX, ratioY, latitude, longitude);
        for (String key : this.keyIndices.keySet()) {
            node.add(key, null);
        }
        return node;
    }

    public Set<String> keySet() {
        LinkedHashSet<String> copy = new LinkedHashSet<String>();
        copy.addAll(this.keyIndices.keySet());
        return copy;
    }
}

