/*
 * Decompiled with CFR 0.152.
 */
package AppSPOT;

import AppSPOT.Coordinate;
import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.DefaultListModel;

public class CoordinateMarkerPanel
extends ZoomableImagePanel {
    private static final long serialVersionUID = 1L;
    private static final Font fontPlain = new Font("Courier New", 0, 20);
    private static final Font fontBold = new Font("Courier New", 1, 20);
    private DefaultListModel<Coordinate> coordinates;

    public CoordinateMarkerPanel(DefaultListModel<Coordinate> coordinates) {
        this.coordinates = coordinates;
        this.setBackground(Color.BLACK);
    }

    @Override
    public void paint(Graphics g, double frameX, double frameY, double zoom) {
        super.paint(g, frameX, frameY, zoom);
        int R = 5;
        int D = 2 * R + 1;
        int n = this.coordinates.size();
        int i = 0;
        while (i < n) {
            Coordinate c = this.coordinates.get(i);
            long index = c.getIndex();
            int x = c.getPixelX();
            int y = c.getPixelY();
            g.setColor(Color.BLACK);
            g.drawOval(x - R, y - R, D, D);
            g.setColor(c.isSelected() ? Color.MAGENTA : Color.CYAN);
            g.drawOval(x - R + 1, y - R + 1, D - 2, D - 2);
            g.setColor(Color.BLACK);
            g.drawOval(x - R + 2, y - R + 2, D - 4, D - 4);
            String text = Long.toString(index);
            int textOffsetX = -g.getFontMetrics().stringWidth(text) / 2;
            int textOffsetY = -R;
            g.setColor(Color.BLACK);
            g.setFont(fontBold);
            g.drawString(text, x + textOffsetX, y + textOffsetY);
            g.setColor(Color.RED);
            g.setFont(fontPlain);
            g.drawString(text, x + textOffsetX, y + textOffsetY);
            ++i;
        }
        if (this.getImage() != null && this.mouseEntered()) {
            int x = (int)this.getTrueX(this.mouseMovedX());
            int y = (int)this.getTrueY(this.mouseMovedY());
            g.setColor(Color.BLUE);
            g.drawOval(x - R, y - R, D, D);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.frameX(), this.frameY(), this.getZoom());
    }

    @Override
    public void reset(int resetMode) {
        super.reset(resetMode);
    }
}

