/*
 * Decompiled with CFR 0.152.
 */
package AppWAVE;

import AppWAVE.DataPoint;
import Data.XY;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataSet
implements Iterable<DataPoint> {
    private List<DataPoint> dataPoints = new ArrayList<DataPoint>();
    private double minValue = 0.0;
    private double maxValue = 0.0;

    public DataSet(Map<Long, Double> dataMap, Map<Long, XY> coordinatesMap) {
        for (long index : dataMap.keySet()) {
            if (!coordinatesMap.containsKey(index)) continue;
            double value = dataMap.get(index);
            XY xy = coordinatesMap.get(index);
            this.add(new DataPoint(index, xy, value));
        }
    }

    public void add(DataPoint dataPoint) {
        double value = dataPoint.getValue();
        if (this.dataPoints.isEmpty()) {
            this.minValue = this.maxValue = value;
        }
        this.minValue = value < this.minValue ? value : this.minValue;
        this.maxValue = value > this.maxValue ? value : this.maxValue;
        this.dataPoints.add(dataPoint);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[DATA SET]\n");
        for (DataPoint dataPoint : this.dataPoints) {
            s.append(String.format("%s\n", dataPoint));
        }
        return s.toString();
    }

    @Override
    public Iterator<DataPoint> iterator() {
        return this.dataPoints.iterator();
    }

    public int size() {
        return this.dataPoints.size();
    }

    public DataPoint get(int index) {
        return this.dataPoints.get(index);
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

