/*
 * Decompiled with CFR 0.152.
 */
package AppWAVE;

import AppWAVE.DataSet;
import AppWAVE.Heatmap;
import AppWAVE.HeatmapImageGenerator;
import AppWAVE.HeatmapPanel;
import AppWAVE.HeatmapProgressObserver;
import AppWAVE.WAVEConfigPanel;
import AppWAVE.WAVEConfigPanelObserver;
import Config.HeatmapRenderConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class HeatmapMasterPanel
extends JPanel
implements WAVEConfigPanelObserver {
    private static final long serialVersionUID = 1L;
    private HeatmapPanel heatmapPanel = new HeatmapPanel();
    private WAVEConfigPanel configPanel;
    private int w;
    private int h;
    private BufferedImage mapImage;
    private BufferedImage heatmapImage;
    private DataSet dataSet;
    private Heatmap heatmap;

    public HeatmapMasterPanel(String title, BufferedImage mapImage, DataSet dataSet) {
        this.w = mapImage.getWidth();
        this.h = mapImage.getHeight();
        this.mapImage = mapImage;
        this.dataSet = dataSet;
        this.configPanel = new WAVEConfigPanel(title, this);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.configPanel), "West");
        this.add((Component)this.heatmapPanel, "Center");
    }

    public Heatmap generateHeatmap(HeatmapProgressObserver observer) {
        HeatmapRenderConfig config = this.configPanel.get();
        int maxR = Math.max(this.w, this.h);
        int r = config.getBoundedRadius() ? Math.min(config.getRadius(), maxR) : maxR;
        return Heatmap.generate(config.getType(), this.dataSet, this.w, this.h, r, observer);
    }

    private void refresh() {
        HeatmapRenderConfig config = this.configPanel.get();
        double dataMin = config.getDataMin();
        double dataMax = config.getDataMax();
        double dataScale = config.getDataScale();
        int decimal = config.getDecimal();
        this.heatmapPanel.setDataMinMaxScale(dataMin, dataMax, dataScale);
        this.heatmapPanel.setDecimal(decimal);
        this.heatmapPanel.setImage(config.getImagePlotEnabled() ? this.mapImage : null);
        this.heatmapPanel.setHeatmap(config.getHeatmapPlotEnabled() ? this.heatmapImage : null);
        this.repaint();
    }

    private synchronized void setHeatmap(Heatmap heatmap) {
        this.heatmap = heatmap;
    }

    public synchronized Heatmap getHeatmap() {
        return this.heatmap;
    }

    @Override
    public void configPanelUpdated(WAVEConfigPanel configPanel) {
        HeatmapRenderConfig config = configPanel.get();
        final JDialog dialog = new JDialog();
        dialog.setTitle("Generating Heatmap: " + configPanel.getTitle());
        Dimension dialogSize = new Dimension(300, 100);
        dialog.setMinimumSize(dialogSize);
        dialog.setMaximumSize(dialogSize);
        dialog.setLocationRelativeTo(null);
        dialog.setLayout(new BorderLayout());
        dialog.setAlwaysOnTop(true);
        final JProgressBar progressBar = new JProgressBar(0, 100);
        dialog.setContentPane(progressBar);
        progressBar.setValue(0);
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(0);
        final AtomicBoolean aborted = new AtomicBoolean(false);
        new Thread(() -> {
            HeatmapProgressObserver observer = new HeatmapProgressObserver(){

                @Override
                public AtomicBoolean communicateHeatmapProgress(double value) {
                    SwingUtilities.invokeLater(() -> {
                        progressBar.setValue((int)(100.0 * value));
                        progressBar.repaint();
                    });
                    return aborted;
                }
            };
            Heatmap heatmap = this.generateHeatmap(observer);
            this.setHeatmap(heatmap);
            SwingUtilities.invokeLater(() -> {
                this.heatmapImage = HeatmapImageGenerator.generateImage(this.w, this.h, this.dataSet, heatmap, config.getDataMin(), config.getDataMax(), config.getDataScale(), config.getAlpha(), config.getDecimal(), config.getHeatmapPlotEnabled(), config.getPointPlotEnabled(), config.getValuePlotEnabled(), config.getAPLocationAvailable(), config.getAPPixelX(), config.getAPPixelY(), config.getFontName(), config.getFontSize(), config.getFontColor());
                dialog.dispose();
                configPanel.unlockApplyButton(true);
                this.refresh();
            });
        }).start();
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                aborted.set(true);
                dialog.dispose();
            }
        });
    }

    public WAVEConfigPanel getConfigPanel() {
        return this.configPanel;
    }

    public HeatmapPanel getHeatmapPanel() {
        return this.heatmapPanel;
    }
}

