/*
 * Decompiled with CFR 0.152.
 */
package AppWAVE;

import GUIModule.ColorGradient;
import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class HeatmapPanel
extends ZoomableImagePanel {
    private static final long serialVersionUID = 1L;
    private BufferedImage heatmap;
    private int decimal;
    private double dataMin;
    private double dataMax;
    private double dataScale;
    private ColorGradient colorGradient = ColorGradient.getRainbowScheme(255);
    private static final int COLOR_BAR_OFFSET_X = 5;

    public HeatmapPanel() {
        this.setBackground(Color.BLACK);
    }

    public void setHeatmap(BufferedImage heatmap) {
        this.heatmap = heatmap;
    }

    public BufferedImage getHeatmap() {
        return this.heatmap;
    }

    public void setDataMinMaxScale(double dataMin, double dataMax, double dataScale) {
        this.dataMin = dataMin;
        this.dataMax = dataMax;
        this.dataScale = dataScale;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public int getCombinedElementWidth() {
        return 5 + this.getImage().getWidth(null) + this.colorGradient.computeMaxColorBarTextEndX(this.decimal, this.dataMin * this.dataScale, this.dataMax * this.dataScale);
    }

    @Override
    public void paint(Graphics g, double frameX, double frameY, double zoom) {
        super.paint(g, frameX, frameY, zoom);
        if (this.heatmap != null) {
            g.drawImage(this.heatmap, 0, 0, null);
            g.setColor(Color.BLACK);
            g.fillRect(this.heatmap.getWidth(), 0, 5 + this.colorGradient.computeMaxColorBarTextEndX(this.decimal, this.dataMin, this.dataMax), this.heatmap.getHeight());
            this.colorGradient.drawColorBar(g, this.heatmap.getWidth() + 5, 0, this.heatmap.getHeight(), this.decimal, this.dataMin * this.dataScale, this.dataMax * this.dataScale);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.frameX(), this.frameY(), this.getZoom());
    }
}

