/*
 * Decompiled with CFR 0.152.
 */
package Config;

import Config.HeatmapRenderConfig;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InitConfig
implements Iterable<String> {
    private String configPath;
    private String csvPath;
    private String dataPath;
    private String coordinatesPath;
    private String imagePath;
    private Map<String, HeatmapRenderConfig> heatmapRenderConfigMap;
    private Map<String, Integer> keyOrdinal = new HashMap<String, Integer>();
    private boolean apLocationAvailable;
    private int apX;
    private int apY;

    public InitConfig(String configPath, String csvPath, String dataPath, String coordinatesPath, String imagePath, Map<String, HeatmapRenderConfig> heatmapRenderConfigMap, boolean apLocationAvailable, int apX, int apY) {
        this.configPath = configPath;
        this.csvPath = csvPath;
        this.dataPath = dataPath;
        this.coordinatesPath = coordinatesPath;
        this.imagePath = imagePath;
        this.heatmapRenderConfigMap = heatmapRenderConfigMap;
        int keyOrdinalIndex = 0;
        for (String key : heatmapRenderConfigMap.keySet()) {
            this.keyOrdinal.put(key, keyOrdinalIndex++);
        }
        this.apLocationAvailable = apLocationAvailable;
        this.apX = apX;
        this.apY = apY;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getCSVPath() {
        return this.csvPath;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public String getCoordinatesPath() {
        return this.coordinatesPath;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public HeatmapRenderConfig getHeatmapRenderConfig(String dataKey) {
        return this.heatmapRenderConfigMap.get(dataKey);
    }

    public Comparator<String> getKeyOrderComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String key1, String key2) {
                if (!InitConfig.this.keyOrdinal.containsKey(key1) || !InitConfig.this.keyOrdinal.containsKey(key2)) {
                    return -1;
                }
                return Integer.compare((Integer)InitConfig.this.keyOrdinal.get(key1), (Integer)InitConfig.this.keyOrdinal.get(key2));
            }
        };
    }

    @Override
    public Iterator<String> iterator() {
        return this.heatmapRenderConfigMap.keySet().iterator();
    }

    public boolean isAPLocationAvailable() {
        return this.apLocationAvailable;
    }

    public int getAPX() {
        return this.apX;
    }

    public int getAPY() {
        return this.apY;
    }
}

