/*
 * Decompiled with CFR 0.152.
 */
package GUIModule;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class GUIFactory {
    public static final Color comboBoxBG = Color.LIGHT_GRAY;
    public static final Color panelBG = Color.DARK_GRAY;
    public static final Color buttonBG = Color.LIGHT_GRAY;
    public static final Color labelBG = Color.DARK_GRAY;
    public static final Color textFieldBG = Color.BLACK;
    public static final Color textFieldFG = Color.WHITE;
    public static final Color scrollPaneBG = Color.DARK_GRAY;
    public static final Color textAreaBG = Color.BLACK;
    public static final Color checkBoxBG = Color.DARK_GRAY;
    public static final Color checkBoxFG = Color.WHITE;
    public static final Color sliderBG = Color.DARK_GRAY;
    public static final Color radioButtonBG = Color.DARK_GRAY;

    public static JPanel makePanel(LayoutManager layoutManager) {
        JPanel panel = new JPanel(layoutManager);
        panel.setBackground(panelBG);
        return panel;
    }

    public static JButton makeButton(String title) {
        JButton button = new JButton(title);
        button.setBackground(buttonBG);
        return button;
    }

    public static JLabel makeLabel() {
        JLabel label = new JLabel();
        label.setForeground(Color.WHITE);
        label.setBackground(labelBG);
        return label;
    }

    public static JLabel makeBorderLabel(String title) {
        JLabel label = new JLabel(title);
        label.setFont(new Font("ARIAL", 1, 14));
        label.setForeground(Color.WHITE);
        label.setBackground(labelBG);
        return label;
    }

    public static JLabel makeLabel(String title) {
        JLabel label = new JLabel(title);
        label.setForeground(Color.WHITE);
        label.setBackground(labelBG);
        return label;
    }

    public static <T> JComboBox<T> makeComboBox() {
        JComboBox comboBox = new JComboBox();
        comboBox.setBackground(comboBoxBG);
        return comboBox;
    }

    public static JTextField makeTextField(int carets) {
        JTextField field = new JTextField(carets);
        field.setHorizontalAlignment(0);
        field.setCaretColor(Color.WHITE);
        field.setBackground(textFieldBG);
        field.setForeground(textFieldFG);
        return field;
    }

    public static JScrollPane makeScrollPane(Component view) {
        JScrollPane scrollPane = new JScrollPane(view);
        scrollPane.setBackground(scrollPaneBG);
        return scrollPane;
    }

    public static JTextArea makeTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setBackground(textAreaBG);
        return textArea;
    }

    public static JTextArea makeTextArea(Color foreground) {
        JTextArea textArea = GUIFactory.makeTextArea();
        textArea.setForeground(foreground);
        return textArea;
    }

    public static JLabel makeIconLabel(ImageIcon imageIcon, String text) {
        JLabel label = new JLabel();
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        label.setForeground(Color.WHITE);
        label.setText(text);
        label.setIcon(imageIcon);
        return label;
    }

    public static JLabel makeIconLabel(char c, String text) {
        int size = 25;
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g = image.createGraphics();
        g.setFont(new Font("Georgia", 0, size));
        FontMetrics fm = g.getFontMetrics();
        int x = (image.getWidth() - fm.stringWidth("A")) / 2;
        int y = fm.getAscent() + (image.getHeight() - (fm.getAscent() + fm.getDescent())) / 2;
        ((Graphics)g).drawString(Character.toString(c), x, y);
        g.dispose();
        ImageIcon imageIcon = new ImageIcon();
        imageIcon.setImage(image);
        return GUIFactory.makeIconLabel(imageIcon, text);
    }

    public static JCheckBox makeCheckBox(String title) {
        JCheckBox checkBox = new JCheckBox(title);
        checkBox.setBackground(checkBoxBG);
        checkBox.setForeground(checkBoxFG);
        return checkBox;
    }

    public static JSlider makeSlider(int min, int max, int value) {
        JSlider slider = new JSlider(min, max, value);
        slider.setBackground(sliderBG);
        return slider;
    }

    public static JRadioButton makeRadioButton(String text) {
        JRadioButton radioButton = new JRadioButton(text);
        radioButton.setForeground(Color.WHITE);
        radioButton.setBackground(radioButtonBG);
        return radioButton;
    }

    public static JPanel makeCascadingPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBackground(panelBG);
        return panel;
    }
}

