/*
 * Decompiled with CFR 0.152.
 */
package GUIModule.ZoomableImageModule;

import GUIModule.ZoomableImageModule.ZoomableImageUIObserver;
import Util.UtilMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class ZoomableImagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private double frameX;
    private double frameY;
    private boolean mouseEntered;
    private int mouseMovedX;
    private int mouseMovedY;
    private int mousePressedX;
    private int mousePressedY;
    private int mousePressedFrameX;
    private int mousePressedFrameY;
    private Image image;
    private double zoom = 1.0;
    private List<ZoomableImageUIObserver> observers = new ArrayList<ZoomableImageUIObserver>();
    public static final int RESET_ORIGINAL_FIT = 0;
    public static final int RESET_ASPECT_FIT = 1;
    public static final int RESET_PREFERRED_FIT = 2;

    public ZoomableImagePanel() {
        this.setBackground(Color.BLACK);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ZoomableImagePanel.this.mouseEntered = true;
                ZoomableImagePanel.this.notifyMouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ZoomableImagePanel.this.mouseEntered = false;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                switch (e.getButton()) {
                    case 1: {
                        ZoomableImagePanel.this.mousePressedX = e.getX();
                        ZoomableImagePanel.this.mousePressedY = e.getY();
                        ZoomableImagePanel.this.mousePressedFrameX = (int)Math.round(ZoomableImagePanel.this.frameX);
                        ZoomableImagePanel.this.mousePressedFrameY = (int)Math.round(ZoomableImagePanel.this.frameY);
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ZoomableImagePanel.this.mouseMovedX = e.getX();
                ZoomableImagePanel.this.mouseMovedY = e.getY();
                ZoomableImagePanel.this.repaint();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                switch (e.getButton()) {
                    case 2: 
                    case 3: {
                        break;
                    }
                    default: {
                        ZoomableImagePanel.this.frameX = (double)ZoomableImagePanel.this.mousePressedFrameX + (double)(e.getX() - ZoomableImagePanel.this.mousePressedX) / ZoomableImagePanel.this.zoom;
                        ZoomableImagePanel.this.frameY = (double)ZoomableImagePanel.this.mousePressedFrameY + (double)(e.getY() - ZoomableImagePanel.this.mousePressedY) / ZoomableImagePanel.this.zoom;
                        ZoomableImagePanel.this.notifyFrameParameterChanged();
                        ZoomableImagePanel.this.repaint();
                    }
                }
            }
        });
        this.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                double rotation = -e.getPreciseWheelRotation();
                rotation = UtilMath.cap(rotation, -1.5, 1.5);
                int mouseX = e.getX();
                int mouseY = e.getY();
                double trueX = ZoomableImagePanel.this.getTrueX(mouseX);
                double trueY = ZoomableImagePanel.this.getTrueY(mouseY);
                ZoomableImagePanel.this.zoom = ZoomableImagePanel.this.clampZoom(ZoomableImagePanel.this.zoom * Math.exp(rotation / 100.0));
                ZoomableImagePanel.this.frameX = (double)mouseX / ZoomableImagePanel.this.zoom - trueX;
                ZoomableImagePanel.this.frameY = (double)mouseY / ZoomableImagePanel.this.zoom - trueY;
                ZoomableImagePanel.this.notifyFrameParameterChanged();
                ZoomableImagePanel.this.repaint();
            }
        });
    }

    private double clampZoom(double zoom) {
        return UtilMath.cap(zoom, 0.125, 8.0);
    }

    public void addObserver(ZoomableImageUIObserver observer) {
        this.observers.add(observer);
    }

    private void notifyMouseEntered() {
        for (ZoomableImageUIObserver observer : this.observers) {
            observer.mouseEntered();
        }
    }

    private void notifyFrameParameterChanged() {
        for (ZoomableImageUIObserver observer : this.observers) {
            observer.frameParameterChanged(this);
        }
    }

    public void centerAt(int pixelX, int pixelY) {
        this.frameX = (double)(this.getWidth() / 2) / this.zoom - (double)pixelX;
        this.frameY = (double)(this.getHeight() / 2) / this.zoom - (double)pixelY;
    }

    public double frameX() {
        return this.frameX;
    }

    public double frameY() {
        return this.frameY;
    }

    public boolean mouseEntered() {
        return this.mouseEntered;
    }

    public int mousePressedX() {
        return this.mousePressedX;
    }

    public int mousePressedY() {
        return this.mousePressedY;
    }

    public int mouseMovedX() {
        return this.mouseMovedX;
    }

    public int mouseMovedY() {
        return this.mouseMovedY;
    }

    public void setFrameLocation(double frameX, double frameY) {
        this.frameX = frameX;
        this.frameY = frameY;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public double getTrueX(double px) {
        return px / this.zoom - this.frameX;
    }

    public double getTrueY(double py) {
        return py / this.zoom - this.frameY;
    }

    public void paint(Graphics gBase, double frameX, double frameY, double zoom) {
        super.paint(gBase);
        Graphics2D g = (Graphics2D)gBase;
        g.scale(zoom, zoom);
        g.translate(frameX, frameY);
        if (this.image != null) {
            g.drawImage(this.image, 0, 0, null);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.paint(g, this.frameX, this.frameY, this.zoom);
    }

    public void reset(int resetMode) {
        if (this.image == null || resetMode == 0) {
            this.frameX = 0.0;
            this.frameY = 0.0;
            this.zoom = 1.0;
        } else if (resetMode == 1) {
            this.frameX = 0.0;
            this.frameY = 0.0;
            double frameWidth = this.getWidth();
            double frameHeight = this.getHeight();
            double imageWidth = this.getImage().getWidth(null);
            double imageHeight = this.getImage().getHeight(null);
            double ratioW = frameWidth / imageWidth;
            double ratioH = frameHeight / imageHeight;
            this.zoom = Math.min(ratioW, ratioH);
        } else if (resetMode == 2) {
            this.frameX = 0.0;
            this.frameY = 0.0;
            Dimension preferredSize = this.getPreferredSize();
            double imageWidth = this.getImage().getWidth(null);
            double imageHeight = this.getImage().getHeight(null);
            double ratioW = preferredSize.getWidth() / imageWidth;
            double ratioH = preferredSize.getHeight() / imageHeight;
            this.zoom = Math.min(ratioW, ratioH);
        }
        this.repaint();
    }

    public void adjustZoomRelativeToCurrent(double factor) {
        this.zoom = this.clampZoom(this.zoom * factor);
        this.repaint();
    }
}

